local S = minetest.get_translator("lzr_laser")

minetest.register_tool("lzr_laser:block_state_toggler", {
	description = S("Block State Toggler"),
	inventory_image = "lzr_laser_emitter_toggler.png",
	groups = { cheat_item = 1 },
	on_use = function(itemstack, user, pointed_thing)
		if pointed_thing.type ~= "node" then
			return itemstack
		end
		local pos = pointed_thing.under
		local node = minetest.get_node(pos)
		local def = minetest.registered_nodes[node.name]
		if def._lzr_on_toggle then
			def._lzr_on_toggle(pos, node)
		end
		return itemstack
	end,
})

-- The Block State Toggler replaces the Emitter Toggler
minetest.register_alias("lzr_laser:emit_toggler", "lzr_laser:block_state_toggler")
