local S = minetest.get_translator("lzr_tt")

tt.register_snippet(function(itemstring)
	if minetest.get_item_group(itemstring, "disable_jump") == 1 then
		return S("Cannot jump in it")
	end
end)

tt.register_snippet(function(itemstring)
	if minetest.get_item_group(itemstring, "punchdig") == 1 then
		return S("Destroyed on touch")
	end
end)

tt.register_snippet(function(itemstring)
	if minetest.get_item_group(itemstring, "explosion_destroys") == 1 then
		return S("Destroyed by explosions")
	end
end)

tt.register_snippet(function(itemstring)
	if minetest.get_item_group(itemstring, "laser_destroys") == 1 then
		return S("Destroyed by lasers")
	end
end)

if minetest.settings:get_bool("lzr_debug", false) == true then
	tt.register_snippet(function(itemstring)
		if minetest.get_item_group(itemstring, "laser_incompatible") == 1 then
			--~ Technical designation for a node (block) that doesn’t interact well with lasers
			return S("Laser-incompatible")
		end
	end)
end

