local S = minetest.get_translator("lzr_levels_core")

lzr_levels.register_level_pack("__core",
	{
		--~ Name of main level pack, should be same as the game name
		title = S("Lazarr!"),
		description = S("The main adventure that comes pre-installed with the game."),
		builtin = true,
		textdomain_npc_texts = "lzr_levels_core_npc_texts",
		textdomain_level_names = "lzr_levels_core_level_names",
	}
)

minetest.register_on_joinplayer(function(player)
	if player:get_player_name() == "singleplayer" then
		local level_data_core = lzr_levels.get_level_pack("__core")
		local treasures = lzr_levels.count_total_collected_treasures(level_data_core)
		lzr_levels.on_collected_treasure(level_data_core, treasures)
	end
end)
