-- Adds a start block (historically called "teleporter").
-- It does nothing on its own,
-- but is meant to be placed in levels as the starter
-- block for the player to spawn on.

-- The name "teleporter" is only for internal/historic reasons,
-- because the player appears to "teleport" to each level.
-- But lore-wise, the player actually just travels to
-- the level (no actual teleportation devices in this game),
-- the travel itself is simply not shown.

local S = minetest.get_translator("lzr_teleporter")

minetest.register_node("lzr_teleporter:teleporter_off", {
	--~ A block on which the player starts in a level
	description = S("Start Block"),
	paramtype2 = "4dir",
	_tt_help = S("Player start point of the level").."\n"..
		--~ The start block has a white dot at one of the sides, marking the initial player look direction
		S("Player will face towards the white dot").."\n"..
		--~ Only one start block allowed per level
		S("(only one per level allowed)"),
	tiles = {
		{ name = "lzr_teleporter_off_top.png", align_style = "world" },
		{ name = "lzr_teleporter_off_bottom.png", align_style = "world" },
		"lzr_teleporter_off_side.png",
		"lzr_teleporter_off_side.png",
		"lzr_teleporter_off_front.png",
		-- This texture shows a white dot to show the initial direction
		"lzr_teleporter_off_rear.png",
	},
	groups = { breakable = 1, rotatable = 3, teleporter = 1 },
	sounds = lzr_sounds.node_sound_stone_defaults(),
})


minetest.register_alias("lzr_teleporter:teleporter_on", "lzr_teleporter:teleporter_off")
