-- This mod adds a (slightly hacky) workaround function
-- to temporarily disable the player footstep sounds when teleporting.
-- It's a wrapper around player:set_pos.

-- IMPORTANT: This mod assumes no other mod manipulates
-- the 'makes_footstep_sound' property of players!

lzr_silent_set_pos = {}

local SILENT_SET_POS_TIME = 0.19

local silent_set_pos_job
-- Calls player:set_pos(pos) but briefly deactivates
-- the player footstep sounds. This is used as a workaround
-- for an issue that sometimes the client plays a water footstep
-- sound when teleporting into a level in the ocean,
-- or when teleporting to the ship from below the ocean height
-- (can happen if returning to the game when the player left
-- the game in a level below ocean height).
-- The workaround works, with the small price of no footstep sounds
-- for the fraction of a second after entering a level.
-- TODO: Find a better solution, if there is one.
lzr_silent_set_pos.silent_set_pos = function(player, pos)
	-- Deactivate footstep sounds right before set_pos.
	player:set_properties({makes_footstep_sound = false})

	player:set_pos(pos)

	-- We only want one minetest.after job at a time
	if silent_set_pos_job then
		silent_set_pos_job:cancel()
	end
	-- Re-activate footstep sound briefly afterwards
	silent_set_pos_job = minetest.after(SILENT_SET_POS_TIME, function(player)
		if player and player:is_player() then
			player:set_properties({makes_footstep_sound = true})
		end
		silent_set_pos_job = nil
	end, player)
end
