# Credits for Lazarr!

Lazarr! is a pirate-themed laser puzzle game designed by Wuzzy.

This game uses many artworks from other people, mostly from
the Luanti community and independent artwork sharing communities like
freesound.org and opengameart.org. Without these communities,
this game would not be possible.

This game is free software (including the artwork). See README.md
for the licensing of the game as a whole.

A list of all people who worked on this game, both directly and
indirectly, follows:

## Idea

- Wuzzy

## Lead Programming

- Wuzzy
	- License: GPLv3+

## Additional Programming

- Player model: Minetest Game developers
	- Origin: <https://github.com/minetest/minetest_game>
	- Modifications were made
	- License: LGPLv2.1+
- Stairs and slabs: Minetest Game developers
	- Origin: <https://github.com/minetest/minetest_game>
	- Modifications were made
	- License: LGPLv2.1+
- Decoration blocks from xdecor mod: Jean-Patrick Guerrero (alias jp)
	- Origin: <https://github.com/minetest-mods/xdecor>
	- Modifications were made
	- License: BSD 3-Clause
- Original screwdriver2 mod, used for the rotating hook: 12Me21
	- Origin: <https://github.com/12Me21/screwdriver2>
	- Modifications were made
	- License: MIT

## Level Design

- Wuzzy
	- License: CC BY-SA 4.0

## 2D Graphics

- Water, wood (normal), tree (normal), stone (normal, tile, mossy tile, brick, mossy brick, circular, mossy circular), sandstone brick, sandstone block, gold block, wooden chest, onyx chest, ship lightbox, wood lightbox, light crate, heavy crate, mossy heavy crate, bonfire, seaweed, purple coral, crab grass, fire, wool (cloth), bomb, bookshelf, start block, television, pickaxe, bucket, tables, wooden ladder: Jean-Patrick Guerrero (alias jp)
	- File names: `default_water.png`, `default_water_source_animated.png`, `default_wood.png`, `default_tree.png`, `default_tree_top.png`, `default_stone.png`, `lzr_core_stone_cracked.png`, `default_stone_block.png`, `lzr_stairs_stone_block_*.png`, `default_stone_block_mossy.png`, `default_stone_brick.png`, `default_stone_brick_mossy.png`, `default_stone_rune.png`, `default_stone_rune_mossy.png`, `default_sandstone_brick.png`, `default_sandstone_block.png`, `lzr_stairs_sandstone_block_*.png`, `lzr_treasure_gold_block.png`, `lzr_level_select_level_completed.png`, `lzr_level_select_level_uncompleted.png`, `lzr_treasure_gold_block_entity.png`, `lzr_treasure_gold_block_in_chest_*.png`, `lzr_treasure_chest_*.png`, `lzr_treasure_dark_chest_*.png`, `lzr_treasure_particle_lock.png`, `lzr_decor_ship_lightbox.png`, `lzr_laser_crate.png`, `lzr_laser_crate_fixed.png`, `lzr_laser_crate_fixed_mossy.png`, `lzr_decor_bonfire.png`, `lzr_plants_seaweed.png`, `lzr_plants_coral_purple.png`, `lzr_plants_crab_grass.png`, `fire_basic_flame*.png`, `wool_*.png`, `lzr_laser_bomb_*.png`, `lzr_decor_bookshelf.png`, `lzr_teleporter_*.png`, `lzr_tools_ultra_pickaxe.png`, `lzr_tools_ultra_bucket.png`, `lzr_decor_blanket_table*.png`, `lzr_decor_working_table*.png`, `lzr_menu_editor_starter_*.png`, `default_ladder_wood.png`
	- Origin: <https://content.luanti.org/packages/jp/pixelbox/>
	- Modifications were made
	- License: CC0
- Barrel (normal), cabinet, half cabinet, candle (floor, inventory, wall, wield), cauldron, cobweb, flower pot, empty shelf, iron lightbox, lantern, multishelf, wooden lightbox, woodframed glass, wood frame, chair/table wood, television, barricade, saw: Jean-Patrick Guerrero (alias jp)
	- File names: `xdecor_barrel_sides.png`, `xdecor_barrel_top.png`, `xdecor_cabinet_front.png`, `xdecor_cabinet_sides.png`, `xdecor_candle_floor.png`, `xdecor_candle_inv.png`, `xdecor_candle_wall.png`, `xdecor_candle_wield.png`, `xdecor_cauldron_bottom.png`, `xdecor_cauldron_side.png`, `xdecor_cauldron_top_empty.png`, `xdecor_cauldron_top_idle.png`, `xdecor_cobweb.png`, `xdecor_dandelion_white_pot.png`, `xdecor_dandelion_yellow_pot.png`, `xdecor_empty_shelf.png`, `xdecor_geranium_pot.png`, `xdecor_half_cabinet_front.png`, `xdecor_half_cabinet_sides.png`, `xdecor_iron_lightbox.png`, `xdecor_lantern_inv.png`, `lzr_gui_pirate_sense.png`, `xdecor_lantern.png`, `xdecor_multishelf.png`, `xdecor_rose_pot.png`, `xdecor_tulip_pot.png`, `xdecor_viola_pot.png`, `xdecor_wooden2_lightbox.png`, `xdecor_woodframed_glass_detail.png`, `xdecor_woodframed_glass.png`, `lzr_decor_woodframed_glass_pane.png`, `lzr_decor_woodframed_glass_pane_top.png`, `xdecor_wood_frame.png`, `xdecor_wood_frame_top.png`, `xdecor_television_*.png`, `xdecor_wood.png`, `xdecor_baricade.png`, `lzr_laser_baricade_burning*.png`, `lzr_menu_saw.png`
	- Origin: <https://github.com/minetest-mods/xdecor>
	- Modifications were made
	- License: CC0
- Base image of emitter, detector and lever: Jean-Patrick Guerrero (alias jp)
	- File names: `lzr_laser_emitter_on.png`, `lzr_laser_detector.png`, `lzr_levers_stone_lever_*.png`
	- Original file names: `xdecor_wooden_lightbox.png`, `xdecor_wood_tile.png`, `xdecor_lever_off.png`, `xdecor_lever_on.png`
	- Origin: <https://content.luanti.org/packages/jp/pixelbox/>
	- Modifications were made
	- License: CC0
- Advanced images for emitter, detector and chest: Wuzzy
	- File names: `lzr_laser_emitter_color_template_off.png`, `lzr_laser_emitter_color_template_on.png`, `lzr_laser_emitter_frame.png`, `lzr_laser_emitter_front_hole.png`, `lzr_laser_emitter_front.png`, `lzr_laser_emitter_on_front_hole_mask.png`, `lzr_laser_emitter_on_front_hole.png`, `lzr_laser_emitter_on_front.png`, `lzr_laser_emitter.png`, `lzr_laser_detector_colored_front.png`, `lzr_laser_detector_colored_mask.png`, `lzr_laser_detector_colored.png`, `lzr_laser_detector_front.png`, `lzr_laser_detector_on_colored_front.png`, `lzr_laser_detector_on_colored_hole.png`, `lzr_laser_detector_on_colored_mask.png`, `lzr_laser_detector_on_colored.png`, `lzr_laser_detector_on_front.png`, `lzr_laser_detector_on.png`, `lzr_treasure_mask_block_in_chest_*.png`
	- License: CC0
- Sandstone, palm wood, coconut wood, loose wood, mossy wood, wood tile, cave stone (normal, block, brick, pillar), stone pillar, circular stone, mossy circular stone, forge animation, cold forge, hanging candle, ship’s wheel, mirror, mixer, beam splitter, double mirror, crystal, pillar crystal, triangle crystal, ant grass (small and large), iron grate/bars, rusty iron grate/bars, old crate, old barrel, screws, wooden door, maps, paintings, inactive light boxes, hollow barrel, reset bomb, dense cobweb, plants on sand/seabed, bed, trapdoor: Wuzzy
	- File names: `default_sandstone.png`, `lzr_core_sandstone_cracked.png`, `lzr_core_palm_wood.png`, `lzr_core_coconut_wood.png`, `lzr_core_wood_loose.png`, `lzr_core_palm_wood_loose.png`, `lzr_core_coconut_wood_loose.png`, `lzr_core_wood_mossy.png`, `lzr_decor_wood_tile.png`, `lzr_decor_coconut_wood_tile.png`, `lzr_decor_palm_wood_tile.png`, `lzr_decor_walnut_wood_tile.png`, `lzr_stairs_*wood_tile_*.png`, `lzr_core_cave_stone*.png`, `lzr_stairs_cave_stone*.png`, `lzr_core_stone_pillar.png`, `lzr_core_stone_pillar_top.png`, `default_stone_rune.png`, `default_stone_rune_mossy.png`, `lzr_decor_forge_*.png`, `xdecor_candle_hanging.png`, `lzr_decor_ships_wheel_*.png`, `lzr_laser_mirror_*.png`, `lzr_laser_mixer_*.png`, `lzr_laser_transmissive_mirror_*.png`, `lzr_laser_double_mirror_*.png`, `lzr_laser_crystal*.png`, `lzr_laser_pillar_crystal_frame.png`, `lzr_laser_triangle_crystal*.png`, `lzr_plants_small_ant_grass.png`, `lzr_plants_large_ant_grass.png`, `lzr_decor_bar.png`, `lzr_decor_bar_top.png`, `lzr_decor_grate.png`, `lzr_decor_rusty_bar.png`, `lzr_decor_rusty_bar_top.png`, `lzr_decor_rusty_grate.png`, `lzr_laser_crate_old.png`, `lzr_decor_barrel_old*.png`, `lzr_laser_fixed.png`, `lzr_laser_fixed_soft.png`, `lzr_doors_*.png`, `lzr_menu_map*.png`, `lzr_menu_painting_*.png`, `lzr_decor_iron_lightbox_off.png`, `lzr_decor_wooden2_lightbox_off.png`, `lzr_decor_ship_lightbox_off.png`, `lzr_laser_hollow_barrel*.png`, `lzr_menu_reset_bomb_*.png`, `lzr_decor_dense_cobweb.png`, `lzr_plants_coral_purple_*.png`, `lzr_plants_seaweed_*.png`, `lzr_decor_bed_*.png`, `lzr_doors_trapdoor_*.png`
	- License: CC0
- Parrots: Wuzzy
	- File name: `lzr_parrot_npc_*.png`
	- License: CC0
- Player texture: Jean-Patrick Guerrero (alias jp)
	- File name: `character.png`
	- Original file name: `character.png`
	- Origin: <https://content.luanti.org/packages/jp/pixelbox/>
	- Modifications were made
	- License: CC0
- Scorched player texture: Wuzzy
	- File names: `character_scorched.png`, `lzr_hand_hand_scorched.png`
	- License: CC0
- Raindrop, crosshair, wieldhand, smoke puff, bomb smoke, book interface, damage screen, trigger icons, laser particles, level corner marker, menu item marker, laser patterns, trigger tool, forbidden icon, hook rotate particle, hook overlay, barrier icons, single level icon, pirate ship menu icons, editor icons, laser absorber, laser stepper, variant changer, water plant grower: Wuzzy
	- File names: `lzr_weather_rain.png`, `crosshair.png`, `object_crosshair.png`, `wieldhand.png`, `smoke_puff.png`, `lzr_laser_bomb_smoke_*.png`, `lzr_laser_overload_smoke.png`, `lzr_infobooks_*.png`, `lzr_damage_screen_*.png`, `lzr_triggers_icon_*.png`, `lzr_laser_particle*.png`, `lzr_laser_laser_end_debug.png`, `lzr_laser_laser_end_debug_extra.png`, `lzr_gui_level_corner.png`, `lzr_gui_menu_marker.png`, `lzr_laser_pattern*.png`, `lzr_laser_trigger_tool*.png`, `lzr_menu_tooltip_icon.png`, `lzr_protection_forbidden.png`, `lzr_hook_rotate_particle.png`, `lzr_hook_rotate_roll_particle.png`, `lzr_hook_overlay*.png`, `lzr_core_barrier.png`, `lzr_core_rain_membrane.png`, `lzr_core_water_source_barrier.png`, `lzr_laser_color_changer.png`, `lzr_laser_emitter_toggler.png`, `lzr_laser_screw_changer.png`, `lzr_level_select_level_singleton.png`, `lzr_menu_color_select_button_mask.png`, `lzr_menu_settings*.png`, `lzr_editor_flag_*.png`, `lzr_editor_flags_select.png`, `lzr_tools_laser_absorber.png`, `lzr_tools_laser_stepper.png`, `lzr_tools_variant_changer.png`, `lzr_tools_water_plant_grower.png`
	- License: CC0
- Main menu images: Wuzzy
	- File names: `background.png`, `header*.png`, `header*svg`, `icon.png`, `footer.png`
	- License: CC BY-SA 4.0
- Vessels shelf: Vanessa Ezekowitz (alias VanessaE)
	- File name: `lzr_decor_vessels_shelf.png`
	- Original file name: `vessels_shelf.png`
	- Origin: <https://github.com/minetest/minetest_game>
	- Modifications were made
	- License: CC BY-SA 3.0
- Ocean stone (all variants), ocean lantern: StarNinjas
	- File names: `xocean_*.png`, `lzr_decor_ocean_*.png`, `lzr_decor_dark_ocean_*.png`, `lzr_decor_circular_ocean_stone_block.png`, `lzr_stairs_ocean_*.png`, `lzr_stairs_dark_ocean_*.png`
	- Original file name: `xocean_*.png`
	- Origin: <https://github.com/starninjas/xocean>
	- Modifications were made
	- License: MIT
- Island-style blocks: Dirt, grass cover, island stone, island grass, sand, seabed, shrub leaves, palm tree, twigs: Termos
	- File names: `default_dirt.png`, `lzr_core_dirt_4x4.png`, `default_grass.png`, `lzr_core_grass_4x4.png`, `default_grass_side.png`, `lzr_stairs_grass_overlay_*.png`, `lzr_core_island_stone.png`, `lzr_core_island_stone_cracked.png`, `lzr_core_island_stone_4x4.png`, `islands_tall_grass.png`, `default_rainforest_litter.png`, `lzr_core_rainforest_litter_4x4.png`, `default_rainforest_litter_side.png`, `lzr_stairs_rainforest_litter_overlay_*.png`, `default_sand.png`, `lzr_core_sand_4x4.png`, `lzr_core_seabed.png`, `lzr_core_seabed_4x4.png`, `lzr_core_shrub_leaves.png`, `lzr_core_palm_leaves*.png`, `lzr_core_palm_tree.png`, `lzr_core_palm_tree_top.png`, `lzr_core_twigs.png`
	- Original file names: `default_dirt.png`, `default_dirt.png`, `default_grass.png`, `default_grass.png`, `default_grass_side.png`, `default_stone.png`, `islands_tall_grass.png`, `default_rainforest_litter.png`, `default_rainforest_litter.png`, `default_rainforest_litter_side.png`, `default_sand.png`, `default_sand.png`, `seabed.png`, `islands_leaves.png`, `palm_leaves*.png`, `palm_tree.png`, `palm_tree_top.png`, `twigs.png`
	- Origin: <https://content.luanti.org/packages/Termos/islands/>
	- Modifications were made
	- License: MIT
- Wild Cotton: Extex101
	- File name: `farming_cotton_wild.png`
	- Original file name: `farming_cotton_wild.png`
	- Origin: <https://github.com/minetest/minetest_game>
	- License: CC BY-SA 3.0
- Skulls: Mikita Wiśniewski (alias rudzik8)
	- File names: `lzr_laser_cskull_*.png`, `lzr_laser_sskull_*.png`
	- Original file names: `lzr_laser_cskull_*.png`, `lzr_laser_sskull_*.png`
	- License: CC BY-SA 3.0
- Coconut and coconut tree: Neuromancer
	- File name: `coconut*.png`
	- Original file name: `coconut*.png`
	- Origin: <https://github.com/Neuromancer56/coconut_tree>
	- License: CC BY-SA 4.0
- Thatch: Mossmanikin
	- File names: `dryplants_thatch.png`, `dryplants_thatch_wet.png`
	- Original file names: `dryplants_thatch.png`, `dryplants_thatch_wet.png`
	- Origin: <https://github.com/mt-mods/plantlife_modpack>
	- License: CC BY-SA 4.0
- Hotbar: Bonemouse
	- File name: `lzr_gui_hotbar_*.png`
	- Original file name: `gui.png`
	- Origin: <http://www.minecraftforum.net/topic/242175-Isabella/>
	- Modifications were made
	- License: CC BY 3.0
- Dialog window background: Q\_x
	- File name: `lzr_gui_bg.png`
	- Original file name: `sheet of old paper.tif`
	- Origin: <https://opengameart.org/content/sheet-of-old-paper>
	- Modifications were made
	- License: CC0
- Dialog window background: Lamoot
	- File name: `lzr_gui_bg.png`
	- Original file name: `paper_background.png`
	- Origin: <https://opengameart.org/content/rpg-gui-construction-kit-v10>
	- Modifications were made
	- License: CC BY 3.0
- Dialog window button: Lamoot
	- File names: `lzr_gui_button*.png`, `lzr_gui_mini_button*.png`
	- Original file name: `RPG_GUI_v1.png`
	- Origin: <https://opengameart.org/content/rpg-gui-construction-kit-v10>
	- Modifications were made
	- License: CC BY 3.0
- Hook: CraftPix.net
	- File name: `lzr_hook_hook.png`
	- Original file name: `Icon39.png`
	- Origin: <https://opengameart.org/content/48-pirate-stuff-icons>
	- Modifications were made
	- License: OGA-BY 3.0
- Speaker: MCL <temp1@cubesoftware.xyz>
	- File name: `lzr_menu_speaker_*.png`
	- Original file name: `xdecor_speaker_*.png`
	- License: CC BY 4.0
- Button arrows and “X” button: Anonymous
	- File names: `lzr_gui_arrow_left.png`, `lzr_gui_arrow_right.png`, `lzr_getitem_reset.png`, `lzr_editor_edit_npc_speech.png`
	- License: CC0
- Any texture not listed above: Wuzzy
	- License: CC BY-SA 4.0

## 3D Graphics

- Mirror, double mirror, beam splitter, crystal, pillar crystal, triangle crystal, hollow barrel, ship’s wheel, parrot, chest, palm leaves, half cabinet, laser, pane, slab, bed: Wuzzy
	- File names: `lzr_laser_mirror*.obj`, `lzr_laser_mirror*.blend`, `lzr_laser_dmirror*.obj`, `lzr_laser_dmirror*.blend`, `lzr_laser_tmirror*.obj`, `lzr_laser_tmirror*.blend`, `lzr_laser_crystal*.obj`, `lzr_laser_crystal*.blend`, `lzr_laser_pillar_crystal*.obj`, `lzr_laser_pillar_crystal*.blend`, `lzr_laser_triangle_crystal*.obj`, `lzr_laser_triangle_crystal_on.blend`, `lzr_laser_hollow_barrel*.obj`, `lzr_laser_hollow_barrel*.blend`, `lzr_laser_barrel_on.blend`, `lzr_decor_ships_wheel.obj`, `lzr_decor_ships_wheel.blender.blend`, `lzr_parrot_npc_cube.obj`, `lzr_parrot_npc_parrot.bbmodel`, `lzr_parrot_npc_parrot.gltf`, `lzr_treasure_chest*.obj`, `lzr_treasure_chest*.blend`, `lzr_core_palm_leaves_laser.obj`, `lzr_laser_burning.obj`, `lzr_laser_burning.blend`, `lzr_decor_cabinet_half.obj`, `lzr_decor_cabinet_half.blend`, `lzr_laser_laser_*.obj`, `lzr_laser_laser_111.blend`, `lzr_panes_pane_on.obj`, `lzr_panes_pane_on.blend`, `lzr_stairs_slab_*.obj`, `lzr_stairs_slab_*.blend`, `lzr_decor_bed.obj`
	- License: CC0
- Skull: Mikita Wiśniewski (alias rudzik8)
	- File names: `lzr_laser_skull.blend`, `lzr_laser_skull.obj`
	- Original file names: `lzr_laser_skull.blend`, `lzr_laser_skull.obj`
	- License: CC BY-SA 3.0
- Table, chair: Jean-Patrick Guerrero (alias jp)
	- Origin: <https://github.com/minetest-mods/xdecor>
	- License: CC0
- Player model: Minetest Game developers
	- File names: `character.b3d`, `character.blend`
	- Original file names: `character.b3d`, `character.blend`
	- Origin: <https://github.com/minetest/minetest_game>
	- License: CC BY-SA 3.0

## Font

- HaLaBuFo Regular: The Noto Project Authors & Wuzzy
	- File name: `regular.woff`
	- Original file name: `NotoSerif-Regular.ttf`
	- Origin: <https://fonts.google.com/noto/specimen/Noto+Serif>
	- License: OFL 1.1
- HaLaBuFo Bold: The Noto Project Authors & Wuzzy
	- File name: `bold.woff`
	- Original file name: `NotoSerif-Bold.ttf`
	- Origin: <https://fonts.google.com/noto/specimen/Noto+Serif>
	- License: OFL 1.1
- Noto Serif Italic: The Noto Project Authors
	- File name: `italic.woff`
	- Original file name: `NotoSerif-Italic.ttf`
	- Origin: <https://fonts.google.com/noto/specimen/Noto+Serif>
	- License: OFL 1.1
- Noto Serif Bold Italic: The Noto Project Authors
	- File name: `bold_italic.woff`
	- Original file name: `NotoSerif-BoldItalic.ttf`
	- Origin: <https://fonts.google.com/noto/specimen/Noto+Serif>
	- License: OFL 1.1

## Music

- pirates carol: Bobjt
	- File name: `lzr_ambience_bobjt_pirates_carol.ogg`
	- Original file name: `pirates_carol_-_original.ogg`
	- Origin: <https://opengameart.org/content/7-seas-under-the-moon>
	- Modifications were made
	- License: CC BY 3.0
- Exploring the Ocean: Leonardo Paz (alias leopaz)
	- File name: `lzr_ambience_leopaz_exploring_the_ocean.ogg`
	- Original file name: `01_exploring_the_ocean.wav`
	- Origin: <https://opengameart.org/content/ocean-music-pack>
	- License: CC BY 4.0
- Siren’s Call: Leonardo Paz (alias leopaz)
	- File name: `lzr_ambience_leopaz_sirens_call.ogg`
	- Original file name: `04_sirens_call.wav`
	- Origin: <https://opengameart.org/content/ocean-music-pack>
	- License: CC BY 4.0
- Stranded in the Ocean: Leonardo Paz (alias leopaz)
	- File name: `lzr_ambience_leopaz_stranded_in_the_ocean.ogg`
	- Original file name: `05_stranded_in_the_ocean.wav`
	- Origin: <https://opengameart.org/content/ocean-music-pack>
	- License: CC BY 4.0
- A Friendly Nautilus Shows us the Way: Vandalorum
	- File name: `lzr_ambience_vandalorum_a_friendly_nautilus_shows_us_the_way.ogg`
	- Original file name: `vandalorum_-_a_friendly_nautilus_shows_us_the_way.wav`
	- Origin: <https://opengameart.org/content/water-level-synth-music>
	- License: CC BY 4.0
- A Mist Hangs Over the Water: Vandalorum
	- File name: `lzr_ambience_vandalorum_a_mist_hangs_over_the_water.ogg`
	- Original file name: `vandalorum_-_a_mist_hangs_over_the_water.wav`
	- Origin: <https://opengameart.org/content/water-level-synth-music>
	- License: CC BY 4.0
- Ruins of the Ancient Atlantians: Vandalorum
	- File name: `lzr_ambience_vandalorum_ruins_of_the_ancient_atlantians.ogg`
	- Original file name: `vandalorum_-_ruins_of_the_ancient_atlantians.wav`
	- Origin: <https://opengameart.org/content/water-level-synth-music>
	- License: CC BY 4.0
- Swept Beneath the Tide: Vandalorum
	- File name: `lzr_ambience_vandalorum_swept_beneath_the_tide.ogg`
	- Original file name: `vandalorum_-_swept_beneath_the_tide.wav`
	- Origin: <https://opengameart.org/content/water-level-synth-music>
	- License: CC BY 4.0
- The Cold Wizard Summons a Storm: Vandalorum
	- File name: `lzr_ambience_vandalorum_the_cold_wizard_summons_a_storm.ogg`
	- Original file name: `vandalorum_-_the_cold_wizard_summons_a_storm.wav`
	- Origin: <https://opengameart.org/content/water-level-synth-music>
	- License: CC BY 4.0
- Ancient Mystery Waltz Allegro: Kevin MacLeod (incompetech.com)
	- File name: `lzr_ambience_kml_ancient_mystery_waltz_allegro.ogg`
	- Original file name: `Ancient Mystery Waltz Allegro.mp3`
	- License: CC BY 4.0
- Ave Marimba: Kevin MacLeod (incompetech.com)
	- File name: `lzr_ambience_kml_ave_marimba.ogg`
	- Original file name: `Ave Marimba.mp3`
	- License: CC BY 4.0
- Island Meet and Greet: Kevin MacLeod (incompetech.com)
	- File name: `lzr_ambience_kml_island_meet_and_greet.ogg`
	- Original file name: `Island Meet and Greet.mp3`
	- License: CC BY 4.0
- Moonlight Beach: Kevin MacLeod (incompetech.com)
	- File name: `lzr_ambience_kml_moonlight_beach.ogg`
	- Original file name: `Moonlight Beach.mp3`
	- License: CC BY 4.0
- Morgana Rides: Kevin MacLeod (incompetech.com)
	- File name: `lzr_ambience_kml_morgana_rides.ogg`
	- Original file name: `Morgana Rides.mp3`
	- License: CC BY 4.0
- River Fire: Kevin MacLeod (incompetech.com)
	- File name: `lzr_ambience_kml_river_fire.ogg`
	- Original file name: `River Fire.mp3`
	- License: CC BY 4.0
- Tiki Bar Mixer: Kevin MacLeod (incompetech.com)
	- File name: `lzr_ambience_kml_tiki_bar_mixer.ogg`
	- Original file name: `Tiki Bar Mixer.mp3`
	- License: CC BY 4.0

## Sound Effects

- Stone digging, dirt footstep/placement/digging, sand footstep/placement/digging, cloth footstep/placement/digging, leaves footstep, grass footstep/digging, jungle litter footstep, water footstep/placement/digging, sticks footstep/placement, forge footstep, inventory full warning: Wuzzy
	- File names: `lzr_sounds_dug_stone.*.ogg`, `default_dirt_footstep.*.ogg`, `lzr_sounds_place_dirt.*.ogg`, `lzr_sounds_dug_dirt*.ogg`, `default_sand_footstep.*.ogg`, `lzr_sounds_place_sand.*.ogg`, `lzr_sounds_dug_sand.*.ogg`, `lzr_sounds_footstep_cloth.*.ogg`, `lzr_sounds_place_cloth.*.ogg`, `lzr_sounds_dug_cloth.*.ogg`, `lzr_sounds_footstep_leaves.*.ogg`, `lzr_sounds_footstep_grass.*ogg`, `lzr_sounds_dug_grass.*.ogg`, `lzr_sounds_footstep_jungle_litter.*.ogg`, `lzr_sounds_footstep_water.*.ogg`, `lzr_sounds_place_water.*.ogg`, `lzr_sounds_dug_water.*.ogg`, `lzr_sounds_footstep_sticks.*.ogg`, `lzr_sounds_place_sticks.ogg`, `lzr_decor_footstep_forge.*.ogg`, `lzr_protection_inventory_full.ogg`
	- License: MIT
- Stone footstep: KiranKeegan
	- File name: `lzr_sounds_footstep_stone.*.ogg`
	- License: CC0
- Stone placement: StarNinjas
	- File name: `lzr_sounds_place_stone.*.ogg`
	- License: CC0
- Metal digging: Ivan Gabovitch (alias qubodup)
	- File name: `default_dug_metal.*.ogg`
	- License: CC0
- Metal digging: yadronoff
	- File name: `default_dig_metal.ogg`
	- Original file name: `Metal Rumble.wav`
	- Origin: <https://www.freesound.org/people/yadronoff/sounds/320397/>
	- License: CC BY 3.0
- Metal footstep: mypantsfelldown
	- File name: `default_metal_footstep.*.ogg`
	- Original file name: `Metal Footsteps`
	- Origin: <https://freesound.org/people/mypantsfelldown/sounds/398937/>
	- License: CC0
- Metal placement: Ogrebane
	- File name: `default_place_node_metal.*.ogg`
	- Original file name: `default_place_node_metal.*.ogg`
	- Origin: <http://opengameart.org/content/wood-and-metal-sound-effects-volume-2>
	- License: CC0
- Glass footstep: deleted\_user\_2194797
	- File name: `lzr_sounds_footstep_glass.*.ogg`
	- Original file name: `Ding 4`
	- Origin: <https://freesound.org/people/deleted_user_2104797/sounds/325252/>
	- Modifications were made
	- License: CC0
- Glass digging: kelsey\_w
	- File name: `lzr_sounds_dig_glass.ogg`
	- Original file name: `Glass Bump.wav`
	- Origin: <https://freesound.org/people/kelsey_w/sounds/467039/>
	- Modifications were made
	- License: CC BY 3.0
- Glass placement: kbnevel
	- File name: `lzr_sounds_place_glass.*.ogg`
	- Original file name: `Glass_Clink.aif`
	- Origin: <https://freesound.org/people/kbnevel/sounds/119839/>
	- Modifications were made
	- License: CC0
- Wood footstep: Cpfcfan10
	- File name: `lzr_sounds_footstep_wood.*.ogg`
	- Original file name: `Wooden Stairs`
	- Origin: <https://freesound.org/people/Cpfcfan10/sounds/522555/>
	- Modifications were made
	- License: CC BY 4.0
- Wood placement and digging: youandbiscuitme
	- File name: `lzr_sounds_place_wood.*.ogg`
	- Original file name: `wooden object set on table 1`
	- Origin: <https://freesound.org/people/youandbiscuitme/sounds/258244/>
	- Modifications were made
	- License: CC BY 3.0
- Normal rotation, wood rotation: el\_boss
	- File names: `lzr_hook_rotate.ogg`, `lzr_sounds_rotate_wood.ogg`
	- Original file name: `Puzzle piece rotation (clockwise)`
	- Origin: <https://freesound.org/people/el_boss/sounds/560700/>
	- License: CC0
- Glass/mirror rotation: killamn97
	- File name: `lzr_sounds_rotate_glass.ogg`
	- Original file name: `Rotate Mirror 3.wav`
	- Origin: <https://freesound.org/people/killianm97/sounds/554236/>
	- License: CC0
- Stone rotation: Ivan Gabovitch (alias qubodup)
	- File name: `lzr_sounds_rotate_stone.ogg`
	- Original file name: `Stone Touch`
	- Origin: <https://freesound.org/people/qubodup/sounds/743264/>
	- License: CC0
- Metal rotation: MultiMax2121
	- File name: `lzr_sounds_rotate_metal.ogg`
	- Original file name: `grenade sound effect.mp3`
	- Origin: <https://freesound.org/people/MultiMax2121/sounds/156896/>
	- Modifications were made
	- License: CC0
- Laser emitter activation: PhonosUPF
	- File name: `lzr_laser_emitter_activate.ogg`
	- Original file name: `accordion percussion 2a`
	- Origin: <https://freesound.org/people/PhonosUPF/sounds/501976/>
	- License: CC0
- Level entering and leaving: junggle
	- File names: `lzr_levels_level_enter.ogg`, `lzr_levels_level_leave.ogg`
	- Original file name: `accordeon_21.wav`
	- Origin: <https://freesound.org/people/junggle/sounds/27355/>
	- Modifications were made
	- License: CC BY 4.0
- Level completion jingle: Fupicat
	- File name: `lzr_levels_level_complete.ogg`
	- Original file name: `WinBandoneon.wav`
	- Origin: <https://freesound.org/people/Fupicat/sounds/521641/>
	- Modifications were made
	- License: CC0
- Game completion jingle: X3nus
	- File name: `lzr_levels_level_set_complete.ogg`
	- Original file name: `Pirate's Bounty.wav`
	- Origin: <https://freesound.org/s/449939/>
	- License: CC BY 3.0
- Button: Fourier
	- File name: `lzr_sounds_button.ogg`
	- Original file name: `button press 1.wav`
	- Origin: <https://opengameart.org/content/forward-button-press-ui-sound>
	- Modifications were made
	- License: CC BY 3.0
- Barricade burning: florianreichelt
	- File name: `lzr_laser_quickburn.*.ogg`
	- Original file name: `flames sizzling of a bonfire - FIRE`
	- Origin: <https://freesound.org/people/florianreichelt/sounds/563012>
	- Modifications were made
	- License: CC0
- Sticks digging / barricade breaking: kevinkace
	- File name: `lzr_sounds_dug_sticks.ogg`
	- Original file name: `Crate Break 4.wav`
	- Origin: <https://freesound.org/people/kevinkace/sounds/66780/>
	- License: CC0
- Skull footstep/placement/digging/rotation: The Battle for Wesnoth developers
	- File name: `lzr_laser_skull_*.ogg`
	- Original file names: `skeleton-die-1.ogg`, `skeleton-die-2.ogg`, `skeleton-hit-1.ogg`, `skeleton-hit-2.ogg`, `skeleton-hit-3.ogg`
	- Origin: <https://github.com/wesnoth/wesnoth/>
	- License: GPLv2+
- Squeaky wood: rubberduck
	- File name: `lzr_sounds_footstep_wood_squeak.*.ogg`
	- Origin: <https://opengameart.org/content/100-cc0-metal-and-wood-sfx>
	- License: CC0
- Chest opening: JUDITH136
	- File name: `lzr_treasure_chest_open.ogg`
	- Original file name: `20.wav`
	- Origin: <https://freesound.org/people/JUDITH136/sounds/408001/>
	- License: CC BY 3.0
- Chest opening fails: Dymewiz
	- File name: `lzr_treasure_chest_open_fail.ogg`
	- Original file name: `locking a door_02.wav`
	- Origin: <https://freesound.org/people/Dymewiz/sounds/131029/>
	- License: CC BY 3.0
- Chest lock breaks: MAJ061785
	- File name: `lzr_treasure_chest_lock_break.ogg`
	- Original file name: `Breaking lock.aif`
	- Origin: <https://freesound.org/people/MAJ061785/sounds/85533/>
	- License: CC BY 3.0
- Chest lock regenerates: MAJ061785
	- File name: `lzr_treasure_chest_lock_regen.ogg`
	- Original file name: `Breaking lock.aif`
	- Origin: <https://freesound.org/people/MAJ061785/sounds/85533/>
	- Modifications were made
	- License: CC BY 3.0
- Detector activates/deactivates: Artninja
	- File names: `lzr_laser_detector_activate.ogg`, `lzr_laser_detector_deactivate.ogg`
	- Original file name: `lock_mechanisms_from_van`
	- Origin: <https://freesound.org/people/Artninja/sounds/719255/>
	- Modifications were made
	- License: CC BY 4.0
- Lightbox activates/deactivates: Ryding
	- File names: `lzr_decor_lightbox_on.ogg`, `lzr_decor_lightbox_off.ogg`
	- Original file name: `Flourescent tube`
	- Origin: <https://freesound.org/people/Ryding/sounds/718460/>
	- Modifications were made
	- License: CC BY 4.0
- Speaker turns on/off: mincedbeats
	- File names: `lzr_menu_speaker_turn_on.ogg`, `lzr_menu_speaker_turn_off.ogg`
	- Original file name: `Yamaha HS80 Switch.wav`
	- Origin: <https://freesound.org/people/mincedbeats/sounds/593996/>
	- Modifications were made
	- License: CC0
- Player damage: newagesoup
	- File name: `lzr_damage_damage.ogg`
	- Original file name: `PUNCH-BOXING-03.wav`
	- Origin: <https://freesound.org/people/newagesoup/sounds/348242/>
	- License: CC0
- Skull laugh: klankbeeld
	- File name: `lzr_fallout_skull_laugh.ogg`
	- Original file name: `laugh.WAV`
	- Origin: <https://freesound.org/people/klankbeeld/sounds/126113/>
	- Modifications were made
	- License: CC BY 4.0
- Bomb fuse: maximumplay3r
	- File name: `lzr_laser_bomb_fuse.ogg`
	- Original file name: `Fuse Ignition`
	- Origin: <https://freesound.org/people/maximumplay3r/sounds/713344/>
	- License: CC0
- Bomb explosion: WaveAdventurer
	- File name: `lzr_laser_bomb_explode.ogg`
	- Original file name: `explosion1(crunchier)`
	- Origin: <https://freesound.org/people/WaveAdventurer/sounds/732252/>
	- Modifications were made
	- License: CC BY 4.0
- Change color, change screw, rotation denied: artisticdude
	- File names: `lzr_laser_change_color.ogg`, `lzr_laser_change_screw.ogg`, `lzr_hook_rotate_denied.ogg`
	- Origin: <https://opengameart.org/content/rpg-sound-pack>
	- License: CC0
- Old crate breaks: melle\_teich
	- File name: `lzr_laser_crate_old_break.*.ogg`
	- Original file name: `Tearing pieces of wood`
	- Origin: <https://freesound.org/people/melle_teich/sounds/628398/>
	- License: CC0
- Default block digging/placement: Mito551
	- File names: `default_dug_node.*.ogg`, `default_place_node_hard.*.ogg`, `default_place_node.*.ogg`
	- Original file names: `default_dug_node.*.ogg`, `default_place_node_hard.*.ogg`, `default_place_node.*.ogg`
	- Origin: <https://github.com/minetest/minetest_game>
	- License: CC BY-SA 3.0
- Parrot curr: Breviceps
	- File name: `lzr_parrot_npc_curr.ogg`
	- Original file name: `Animal / Cartoon - Cooing, Curr - Parrot`
	- Origin: <https://freesound.org/people/Breviceps/sounds/445119/>
	- License: CC0
- Door lock: saha213131
	- File name: `lzr_doors_door_locked.ogg`
	- Original file name: `doorlocked01`
	- Origin: <https://freesound.org/people/saha213131/sounds/730189/>
	- License: CC0
- Open book: mateusboga
	- File name: `lzr_infobooks_open_book.ogg`
	- Original file name: `Opening a book`
	- Origin: <https://freesound.org/people/mateusboga/sounds/614081/>
	- License: CC0
- Close book: Sabacky
	- File name: `lzr_infobooks_close_book.ogg`
	- Original file name: `Open and Close a Diary Book`
	- Origin: <https://freesound.org/people/Sabacky/sounds/774136/>
	- Modifications were made
	- License: CC BY 4.0
- Turn book page: StarNinjas
	- File name: `lzr_infobooks_turn_page.ogg`
	- Original file name: `book_flip.4.ogg`
	- License: CC0
- Pull lever: Olichite
	- File names: `lzr_levers_lever_activate.ogg`, `lzr_levers_lever_deactivate.ogg`
	- Original file name: `FX_NOISY_METAL_DOOR_OPEN.wav`
	- Origin: <https://freesound.org/people/Olichite/sounds/238891/>
	- Modifications were made
	- License: CC0
- Any sound not listed above: Wuzzy
	- License: CC BY-SA 4.0

## Translations

- German: Wuzzy
	- License: CC BY-SA 4.0
- Chinese (traditional): Emojigit
	- License: CC BY-SA 4.0
- Spanish: megustanlosfrijoles
	- License: CC BY-SA 4.0
- French: Nazalassa
	- License: CC BY-SA 4.0
- Russian: f1refa11
	- License: CC BY-SA 4.0
- Turkish: birdlover32767
	- License: CC BY-SA 4.0
- Swedish: Umeaman
	- License: CC BY-SA 4.0

## Other stuff

- See the licence files of the individual mods

## File licensing

Every file is (at least) dual-licensed. This means it is both licensed
under the terms of the game license (see README.md) as well as an individual
file license (shown in this list).

Only licenses compatible with free software are used in this game.

## License references

This is a reference of all license name abbreviations of the licenses listed above:

* GPLv3+: GNU General Public License version 3, or any later version <https://www.gnu.org/licenses/gpl-3.0.en.html>
* GPLv2+: GNU General Public License version 2, or any later version <https://www.gnu.org/licenses/old-licenses/gpl-2.0.en.html>
* LGPLv2.1+: GNU Lesser General Public License version 2.1, or any later version <https://www.gnu.org/licenses/old-licenses/lgpl-2.1>
* MIT: The MIT License <https://mit-license.org/>
* BSD 3-Clause: The BSD 3-Clause License <https://opensource.org/license/BSD-3-clause>
* CC0: Creative Commons Zero <https://creativecommons.org/publicdomain/zero/1.0/>
* CC BY 3.0: Creative Commons Attribution 3.0 Unported <https://creativecommons.org/licenses/by/3.0/>
* CC BY 4.0: Creative Commons Attribution 4.0 International <https://creativecommons.org/licenses/by/4.0/>
* CC BY-SA 3.0: Creative Commons Attribution-ShareAlike 3.0 Unported <https://creativecommons.org/licenses/by-sa/3.0/>
* CC BY-SA 4.0: Creative Commons Attribution-ShareAlike 4.0 International <https://creativecommons.org/licenses/by-sa/4.0/>
* OGA-BY 3.0: OpenGameArt.org Legal Code Attribution 3.0 Unported <https://static.opengameart.org/OGA-BY-3.0.txt>
* OFL-1.1: SIL Open Font License version 1.1 <https://openfontlicense.org/open-font-license-official-text/>
