# Lazarr!
Be a pirate and solve laser puzzles.

A pirate-themed 3D puzzle game by Wuzzy.

Current version: 2.1.3

Official website: https://wuzzy.codeberg.page/Lazarr/

## Playing

### Gameplay

You’re a pirate in the search of treasure.
Sail to different places of the world and find all shiny gold blocks
in treasure chests.

But there’s a catch! Most chests are locked by a mysterious mechanism
and the only way to unlock them is by solving puzzles with lasers.
Mirrors and various other things will help you.

### Getting started

Your adventure begins at an old shipwreck. Find your way to the
treasure chest and open it to get your first gold block.

The on-screen instructions and Goldie the Parrot will guide you
through the game.

Once you’ve completed the first level, you will enter the Old Shiny,
your pirate ship. This is the base of all your pirate operations.

In your pirate ship, you can:

* Continue with the main game
* Play a custom level or level pack
* View your treasure collection
* Change graphics and audio settings for this game
* Enter the level editor
* Talk to Goldie the Parrot
* Get help about the game (no hints)
* Look at the credits

A few advanced game settings are available in the Luanti main menu.

### Controls

This game uses the same controls as Luanti.
Set up your controls in the Luanti settings.
The first levels will also display the default controls as a reminder.

The **inventory key** is special, it gives you access to the **game menu**.
The inventory screen shows your inventory *and* buttons for:

* **While playing**: Restart level, return to ship
* **In the editor**: Get items, save, load, level settings, return to ship

In the pirate ship, the inventory key does nothing.

### Level packs

It’s possible to extend this game with custom level packs from the
community. These are collections of multiple levels.
Unlike for single levels from the level editor, Lazarr! keeps track of
your progress in level packs.

Level packs come in the form of Luanti mods.
Level pack mods have a name like `lzr_pack_<name>`, e.g. `lzr_pack_example`.
To use a level pack, enable the level pack mod in Luanti before starting
your Lazarr! world. It will then appear under the custom levels in your
pirate ship.

Levels created in the level editor end up in the special “Single levels”
level pack.

Gold blocks collected in custom levels do not count towards
your loot in your pirate ship.

## Technical information

### System requirements

This game needs Luanti (version 5.10.0 or later) to run.
Any system that can run Luanti is supported.
Download Luanti from <https://www.luanti.org>.

Desktop computers are recommended.

The game also supports mobile devices with small touchscreens,
but the usability and UI have not been fully optimized yet
(feedback welcome!)

### Download and Installation

You can download and install this game automatically by
clicking on the “Content” tab in Luanti (as of Luanti version 5.10.0).

Alternatively, you can download the latest version of the game
from here: https://content.luanti.org/packages/Wuzzy/lazarr/

You can also manually install this game; refer to the Luanti
documentation to learn how to do this.

### Starting the game

To start the game, start Luanti, select the game Lazarr!, create a world and start it.
This is a singleplayer game, so creating a server is not possible.

Refer to the Luanti documentation for details.

### Saving and loading

Saving and loading is done automatically. Your progress is
stored in the world, so each world acts is like a savegame file.

The world stores:

* Your game progress
* Custom levels created by the level editor (shown in the game as “Single levels”)

The world does **not** store custom level *packs*. Those are provided as mods.

## Extending the game

### Level Editor

In the level editor you can build your own levels.

Your pirate ship contains several books that explain how to use it.
You may also read the text file `LEVEL_EDITOR.md` for a more
technical explanation.

### Development

If you’re interested to learn how this game works under the hood,
or start messing with the code, read `CODE_DOCUMENTATION.md`
for a start.

## History

Originally, this game was hastily made for the Minetest Game Jam 2021 in the
final day of the competition.
Version 1.2 was the version that was rated by the jury and players.
This version only had 10 levels, and level 8 was broken.
There was no base ship or any in-game explanation of the game.
But the main laser game mechanic worked, something I was very proud of I actually
managed to hack this together in only in one day.
Unsurprisingly, the game ranked poorly, only at rank 13.

In the years after, this game has seen many improvements since then.
The current version is very different from the one submitted for
the game jam.

## Credits/License

Lazarr!, a pirate-themed laser puzzle game
Copyright (C) 2024-2025  Wuzzy

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.

The media files (except the font files) are released under a separate
free cultural works license:
Creative Commons Attribution-ShareAlike 4.0 International (CC BY-SA 4.0)

The font files are released under:
SIL Open Font License version 1.1 (OFL 1.1)

For more information about the font files, see
`mods/lzr_fonts/README.txt`.

You can find a copy of the aforementioned licenses here:

* GNU GPLv3: `LICENSE_GPLv3.txt`
* CC BY-SA 4.0: `LICENSE_CC_BY_SA_4_0.txt`
* OFL 1.1: `LICENSE_OFL_1_1.txt`

See CREDITS.md for credits and more details.
