local HTHICK = 1/16 -- half pane thickness

lzr_panes = {}
function lzr_panes.register_pane(basename, def)
	local groups
	if def.groups then
		groups = table.copy(def.groups)
	else
		groups = {}
	end
	groups.pane = 1
	groups.laser_block  = 1
	groups.rotatable = 3

	local front = def.textures[1]
	local leftright = def.textures[2]
	local topbottom = def.textures[3]
	local back = def.textures[4] or front

	local regdef = table.copy(def)

	local newdef = {
		drawtype = "mesh",
		paramtype = "light",
		is_ground_content = false,
		sunlight_propagates = true,
		paramtype2 = "facedir",

		__mesh_off = "lzr_panes_pane_on.obj",
		__mesh_on = "lzr_panes_pane_on.obj",
		__tiles_off = {
			{ name = topbottom, backface_culling = true },
			{ name = leftright, backface_culling = true },
			{ name = front, backface_culling = true },
			{ name = back, backface_culling = true },
			"blank.png", -- no laser
		},
		__tiles_on = {
			{ name = topbottom, backface_culling = true },
			{ name = leftright, backface_culling = true },
			{ name = front, backface_culling = true },
			{ name = back, backface_culling = true },
			lzr_laser.LASER_TILE,
		},
		__light_source_on = lzr_globals.LASER_GLOW,
		__use_texture_alpha_off = "clip",
		__use_texture_alpha_on = lzr_laser.ALPHA_LASER,

		groups = groups,
		selection_box = {
			type = "fixed",
			fixed = {{-1/2, -1/2, -HTHICK, 1/2, 1/2, HTHICK}},
		},
		collision_box = {
			type = "fixed",
			fixed = {{-1/2, -1/2, -HTHICK, 1/2, 1/2, HTHICK}},
		}
	}
	for k,v in pairs(newdef) do
		regdef[k] = v
	end

	lzr_laser.register_element(basename.."_flat", regdef, { group = def.element_group } )
end


