lzr_mapgen = {}

local S = minetest.get_translator("lzr_mapgen")

-- num_emerge_threads setting MUST be 1. Any other
-- value is NOT SUPPORTED because it can break
-- the mapgen and make the game unplayable.
-- See <https://codeberg.org/Wuzzy/Lazarr/issues/224>.
local num_emerge_threads = tonumber(minetest.settings:get("num_emerge_threads"))

if num_emerge_threads ~= 1 then
	minetest.log("error", "[lzr_mapgen] Luanti setting 'num_emerge_threads' was set to "..tostring(num_emerge_threads)..", which is not supported by Lazarr! Game will refuse to load.")
	error(S("The Luanti setting “num_emerge_threads” is set to @1, which is not supported. Please set this setting to 1 or the default value and try again.", tostring(num_emerge_threads)))
end

local backdrops = {
	"ocean", "islands", "underground", "sky"
}
local backdrop_descriptions = {
	["ocean"] = S("Ocean"),
	["islands"] = S("Islands"),
	["underground"] = S("Underground"),
	["sky"] = S("Sky"),
}

lzr_mapgen.get_backdrops = function()
	return backdrops
end

lzr_mapgen.get_backdrop_description = function(id)
	return backdrop_descriptions[id]
end

dofile(minetest.get_modpath("lzr_mapgen").."/settings.lua")
dofile(minetest.get_modpath("lzr_mapgen").."/aliases.lua")
dofile(minetest.get_modpath("lzr_mapgen").."/decorations.lua")

-- The mapgen script will both run in the global environment
-- and the mapgen environment. See mapgen.lua to learn why.
dofile(minetest.get_modpath("lzr_mapgen").."/mapgen.lua")
minetest.register_mapgen_script(minetest.get_modpath("lzr_mapgen").."/mapgen.lua")
