local S = minetest.get_translator("lzr_speech")
local F = minetest.formspec_escape
local FS = function(...) return F(S(...)) end
local NS = function(s) return s end

local mod_credits = minetest.get_modpath("lzr_credits")

lzr_speech = {}

local pending_speech_args

local speakers = {}

lzr_speech.register_speaker = function(id, name, portrait, sound)
	local speaker = { name = name, portrait = portrait, sound = sound }
	speakers[id] = speaker
end

lzr_speech.ask = function(player, message, message_yes, speaker_id, portrait_override, sound_pitch)
	minetest.log("verbose", "[lzr_speech] Asking question")
	pending_speech_args = { player = player, message_yes = message_yes, speaker_id = speaker_id, portrait_override = portrait_override, sound_pitch = sound_pitch }
	lzr_speech.speak(player, message, speaker_id, portrait_override, sound_pitch, "yes_no")
end

lzr_speech.speak = function(player, message, speaker_id, portrait_override, sound_pitch, answer_type)
	if not speakers[speaker_id] then
		minetest.log("error", "[lzr_speech] Tried to call speak for non-existant speaker: "..tostring(speaker_id))
		return
	end
	local portrait
	if portrait_override then
		portrait = portrait_override
	else
		portrait = speakers[speaker_id].portrait
	end
	local title
	if answer_type == "yes_no" then
		--~ @1 is a name
		title = FS("@1 asks:", speakers[speaker_id].name)
	else
		--~ @1 is a name
		title = FS("@1 says:", speakers[speaker_id].name)
	end
	local answers = ""
	if answer_type == "credits" then
		if mod_credits then
			answers = answers .. "button_exit[2.5,4.4;5,0.8;credits;"..FS("Show credits").."]"
		else
			answers = answers .. "button_exit[3.5,4.4;3,0.8;ok;"..FS("OK").."]"
		end
	elseif answer_type == "yes_no" then
		answers = answers .. "button[1.5,4.4;3,0.8;yes;"..FS("Yes").."]" ..
		"button_exit[5.5,4.4;3,0.8;no;"..FS("No").."]"
	else
		answers = "button_exit[3.5,4.4;3,0.8;ok;"..FS("OK").."]"
	end
	local form = "formspec_version[7]size[10,5.5]"..
		"box[0,0;10,0.8;#0000004f]"..
		"label[0.4,0.4;"..title.."]"..
		"box[0.5,1;2.0,3;#0000002f]"..
		"image[0.75,1;1.5,3;"..portrait.."]"..
		"box[3,1;6.5,3;#ffffff1f]"..
		"textarea[3,1;6.5,3;;;"..F(message).."]"..
		answers
	minetest.show_formspec(player:get_player_name(), "lzr_speech:speech", form)

	if speakers[speaker_id].sound then
		minetest.sound_play({name=speakers[speaker_id].sound}, {to_player=player:get_player_name(), pitch=sound_pitch})
	end
end

minetest.register_on_player_receive_fields(function(player, formname, fields)
	if formname ~= "lzr_speech:speech" then
		minetest.log("verbose", "[lzr_speech] Clearing pending_speech_args")
		pending_speech_args = nil
		return
	end
	if pending_speech_args and fields.yes then
		lzr_speech.speak(pending_speech_args.player, pending_speech_args.message_yes, pending_speech_args.speaker_id, pending_speech_args.portrait_override, pending_speech_args.sound_pitch)
	end
	minetest.log("verbose", "[lzr_speech] Clearing pending_speech_args")
	pending_speech_args = nil
	if fields.credits and mod_credits then
		minetest.log("action", "[lzr_speech] "..player:get_player_name().." wants to see the credits")
		lzr_credits.show_credits(player)
	end
end)
