local S = minetest.get_translator("lzr_reset")

lzr_reset = {}
lzr_reset.reset_progress = function()
	-- Reset level progress of all level packs
	local names = lzr_levels.get_level_pack_names()
	for n=1, #names do
		local level_pack = lzr_levels.get_level_pack(names[n])
		if level_pack then
			lzr_levels.clear_level_progress(level_pack)
		end
	end

	-- Reset hidden parrot progress
	lzr_parrot_npc.clear_hidden_parrot_progress()
	lzr_menu.remove_hidden_parrots()
	lzr_menu.remove_painting("parrot_finder")

	-- Reset "menu seen" status
	lzr_levels.set_menu_seen(false)

	local player = minetest.get_player_by_name("singleplayer")
	if player then
		lzr_messages.show_message(player, S("Game progress reset"), 5)
	end
end

minetest.register_chatcommand("reset_progress", {
	privs = {},
	params = "yes",
	description = S("Reset your progress in this game"),
	func = function(name, param)
		if param == "yes" then
			lzr_reset.reset_progress()

			-- Message
			return true, S("Game progress reset.")
		else
			return false, S("To reset the game progress, use “/reset_progress yes”")
		end
	end,
})

-- More detailed development reset commands
if minetest.settings:get_bool("lzr_debug", false) then
	minetest.register_chatcommand("reset_hidden_parrots", {
		privs = { server = true, debug = true },
		description = S("Reset “found” state of all hidden parrots"),
		params = "",
		func = function(name, param)
			lzr_parrot_npc.clear_hidden_parrot_progress()
			lzr_menu.remove_hidden_parrots()
			return true, S("All parrots hidden.")
		end,
	})
	minetest.register_chatcommand("reset_levels", {
		privs = { server = true },
		description = S("Reset progress of a level pack"),
		--~ Parameter of /reset_levels command. Translate the words, but keep the symbols intact
		params = S("[<level pack>]"),
		func = function(name, param)
			-- Use core levels are default
			if param == "" then
				param = "__core"
			end
			local level_pack = lzr_levels.get_level_pack(param)
			if level_pack then
				lzr_levels.clear_level_progress(level_pack)
				return true, S("Progress of level pack “@1” reset.", param)
			else
				return false, S("Level pack “@1” doesn’t exist.", param)
			end
		end,
	})

	minetest.register_chatcommand("get_progress", {
		privs = { debug = true },
		description = S("Summarize the game progress"),
		params = "",
		func = function(name, param)
			local report = ""

			-- Level pack progress
			report = report .. S("Level packs:").."\n"

			local names = lzr_levels.get_level_pack_names()
			table.sort(names)
			for n=1, #names do
				local level_pack = lzr_levels.get_level_pack(names[n])
				local levels_total = #level_pack
				local levels_completed = lzr_levels.count_completed_levels(level_pack)

				--~ @1: level pack name, @2: number of completed levels, @3: number of total levels
				report = report .. S("• @1: @2/@3", names[n], levels_completed, levels_total).."\n"
			end
			report = report .. "\n"

			-- Hidden parrot progress
			report = report .. S("Hidden parrots:").."\n"
			local parrot_names = lzr_parrot_npc.get_hidden_parrot_names()
			for n=1, #parrot_names do
				local found = lzr_parrot_npc.was_hidden_parrot_found(parrot_names[n])
				if found then
					--~ @1: name of a hidden parrot
					report = report .. S("• @1: found", parrot_names[n]).."\n"
				else
					--~ @1: name of a hidden parrot
					report = report .. S("• @1: not found", parrot_names[n]).."\n"
				end
			end
			report = report .. "\n"

			-- Other internal game state
			local menu_seen = lzr_levels.was_menu_seen()
			if menu_seen then
				report = report .. S("Menu seen: yes")
			else
				report = report .. S("Menu seen: no")
			end
			return true, report
		end,
	})
end
