---
--- Generated by EmmyLua(https://github.com/EmmyLua)
--- Created by michieal.
--- DateTime: 12/29/22 12:46 PM -- Restructure Date
--- These are all of the fuel recipes and all of the crafting recipes, consolidated into one place.
--- Copyright (C) 2022 - 2023, Michieal. See License.txt

-- Used everywhere. Often this is just the name, but it makes sense to me as BAMBOO, because that's how I think of it...
-- "BAMBOO" goes here.
local BAMBOO = "mcl_bamboo:bamboo"
local BAMBOO_PLANK = BAMBOO .. "_plank"
-- Craftings
-- Basic Bamboo craftings
minetest.register_craft({
	output = "mcl_core:stick",
	recipe = {
		{BAMBOO},
		{BAMBOO},
	}
})

minetest.register_craft({
	output = BAMBOO .. "_block",
	recipe = {
		{BAMBOO, BAMBOO, BAMBOO},
		{BAMBOO, BAMBOO, BAMBOO},
		{BAMBOO, BAMBOO, BAMBOO},
	}
})

minetest.register_craft({
	output = BAMBOO_PLANK .. " 2",
	recipe = {
		{BAMBOO .. "_block"},
	}
})

minetest.register_craft({
	output = BAMBOO_PLANK .. " 2",
	recipe = {
		{BAMBOO .. "_block_stripped"},
	}
})

minetest.register_craft({
	output = BAMBOO .. "_mosaic",
	recipe = {
		{"mcl_stairs:slab_bamboo_plank"},
		{"mcl_stairs:slab_bamboo_plank"},
	}
})

-- Bamboo specific items

if minetest.get_modpath("mcl_doors") and mcl_doors then
	minetest.register_craft({
		output = "mcl_bamboo:bamboo_door 3",
		recipe = {
			{BAMBOO_PLANK, BAMBOO_PLANK},
			{BAMBOO_PLANK, BAMBOO_PLANK},
			{BAMBOO_PLANK, BAMBOO_PLANK}
		}
	})
	minetest.register_craft({
		output = "mcl_bamboo:bamboo_trapdoor 2",
		recipe = {
			{BAMBOO_PLANK, BAMBOO_PLANK, BAMBOO_PLANK},
			{BAMBOO_PLANK, BAMBOO_PLANK, BAMBOO_PLANK},
		}
	})
end
if minetest.get_modpath("mcl_fences") then
	minetest.register_craft({
		output = "mcl_bamboo:bamboo_fence 3",
		recipe = {
			{BAMBOO_PLANK, "mcl_core:stick", BAMBOO_PLANK},
			{BAMBOO_PLANK, "mcl_core:stick", BAMBOO_PLANK},
		}
	})
	minetest.register_craft({
		output = "mcl_bamboo:bamboo_fence_gate",
		recipe = {
			{"mcl_core:stick", BAMBOO_PLANK, "mcl_core:stick"},
			{"mcl_core:stick", BAMBOO_PLANK, "mcl_core:stick"},
		}
	})
end

minetest.register_craft({
	output = "mcl_bamboo:scaffolding 6",
	recipe = {{BAMBOO, "mcl_mobitems:string", BAMBOO},
			  {BAMBOO, "", BAMBOO},
			  {BAMBOO, "", BAMBOO}}
})

-- Fuels
-- Basic Bamboo nodes
minetest.register_craft({
	type = "fuel",
	recipe = BAMBOO,
	burntime = 2.5, -- supposed to be 1/2 that of a stick, per minecraft wiki as of JE 1.19.3
})

minetest.register_craft({
	type = "fuel",
	recipe = BAMBOO .. "_block",
	burntime = 15,
})

minetest.register_craft({
	type = "fuel",
	recipe = BAMBOO .. "_block_stripped",
	burntime = 15,
})

minetest.register_craft({
	type = "fuel",
	recipe = BAMBOO_PLANK,
	burntime = 7.5,
})

minetest.register_craft({
	type = "fuel",
	recipe = BAMBOO .. "_mosaic",
	burntime = 7.5,
})

-- Bamboo Items
if minetest.get_modpath("mcl_doors") then
	if mcl_doors then
		minetest.register_craft({
			type = "fuel",
			recipe = "mcl_bamboo:bamboo_door",
			burntime = 10,
		})

		minetest.register_craft({
			type = "fuel",
			recipe = "mcl_bamboo:bamboo_trapdoor",
			burntime = 15,
		})
	end
end

if minetest.get_modpath("mcl_stairs") then
	if mcl_stairs ~= nil then
		minetest.register_craft({
			type = "fuel",
			recipe = "mcl_stairs:slab_bamboo_plank",
			burntime = 7.5,
		})
		minetest.register_craft({
			type = "fuel",
			recipe = "mcl_stairs:slab_bamboo_block",
			burntime = 7.5,
		})
		minetest.register_craft({
			type = "fuel",
			recipe = "mcl_stairs:slab_bamboo_stripped",
			burntime = 7.5,
		})
		minetest.register_craft({
			type = "fuel",
			recipe = "mcl_stairs:stair_bamboo_plank",
			burntime = 15,
		})
		minetest.register_craft({
			type = "fuel",
			recipe = "mcl_stairs:stair_bamboo_block",
			burntime = 15,
		})
		minetest.register_craft({
			type = "fuel",
			recipe = "mcl_stairs:stair_bamboo_stripped",
			burntime = 15,
		})
		minetest.register_craft({
			type = "fuel",
			recipe = "mcl_stairs:slab_bamboo_mosaic",
			burntime = 7.5,
		})
		minetest.register_craft({
			type = "fuel",
			recipe = "mcl_stairs:stair_bamboo_mosaic",
			burntime = 15,
		})
	end
end

minetest.register_craft({
	type = "fuel",
	recipe = "mesecons_button:button_bamboo_off",
	burntime = 5,
})

minetest.register_craft({
	type = "fuel",
	recipe = "mcl_bamboo:scaffolding",
	burntime = 20
})
