#Models in Minetest/Mineclone2

Models are an important part of all entities & unique nodes in Mineclone2. They provide a 3 dimensional map of an object for which textures are then applied to. This document is for modders, it quickly highlights some important information for the software needed to open models in Mineclone2.

## Minetest Wiki
For more detailed information on actually using blender to create and modify models for Minetest/Mineclone2, please visit the Minetest wiki's page on using Blender [Here](https://wiki.minetest.net/Using_Blender)

##Recommended software

###Blender

Blender is a very popular and free modeling software supported on Windows, MacOS, and most Linux distributions. It is recommended to use Blender to create and modify 3D models within the minetest engine. 

Download blender [Here](https://www.blender.org/download/)

### .b3d addon for blender

Blitz 3D (.b3d) Is one of the main animated model formats used for entities in the minetest engine. It cannot be imported to blender without a plugin called "Import-Export:Bitz 3D format (.b3d)".

The most up to date version of this Blender plugin can be downloaded [Here](https://github.com/GreenXenith/io_scene_b3d/releases/tag/f189786)

##Types of model formats

###Animated, skinned models
* Blitz 3D files (.b3d)

* Microsoft DirectX (.x) (binary & text, compression is not supported)

###Static meshes
* Wavefront OBJ (.obj)

Note: The sometimes accompanying .mtl files are not supported and can safely be deleted.

Note: Do not use .b3d and .x files for static meshes at the moment, Minetest currently spawns animated mesh scene nodes for these, which may result in reduced performance.

### Supported texture formats

* .png

* .jpg

* .bmp (depreciated, please use .png or .jpg)

* .tga (depreciated, please use .png or .jpg)

Note: Any formats not mentioned above but known to work in the past were removed in 5.5.0 and aren't supported anymore.

##Pros & Cons of .b3d vs .x

###B3D
* [+] Binary format means a small size

* [-] Difficult to postprocess after exporting

* [-] Difficult to debug problems

###X (text version)
* [+] Can be parsed easily with lua scripts

* [+] Can be easily generated by scripts

* [+] Easy to debug issues (you can just read it)

* [+] Can be optimized by quantizing some data

* [-] Blender exporter is kinda buggy and inefficient

* [-] Probably still bigger than an equivalent .b3d

Note: Avoid using the binary X format! It's actually just a tokenized version of the ASCII representation, and may actually be less efficient than a sufficiently optimized text .x file!
