# Credits licensing for media files in `mobs_mc`

## Licenses used

The following media licenses are used:

* [CC0](https://creativecommons.org/choose/zero/)
* [CC BY 3.0](https://creativecommons.org/licenses/by/3.0/)
* [CC BY-SA 4.0](https://creativecommons.org/licenses/by-sa/4.0/)
* [GPL v3](https://www.gnu.org/licenses/gpl-3.0.html])
* [MIT License](https://opensource.org/licenses/MIT)
* [LGPL v2.1](https://www.gnu.org/licenses/lgpl-2.1.html)

Note: A “`*`” in a file name below is a placeholder which can stand for any text.

## Models
All models were done by [22i](https://github.com/22i) and are licensed under GPLv3.

Origin of those models:

* [Mod “amc”](https://github.com/22i/amc/)
* [Repository with Blender source files for models](https://github.com/22i/minecraft-voxel-blender-models)

## Textures

* Mob and item textures are heavily based on [Pixel Perfection](https://www.planetminecraft.com/texture_pack/131pixel-perfection/), a texture pack for Minecraft.
    * Original author: [XSSheep](https://www.planetminecraft.com/member/xssheep/)
    * License (if not mentioned otherwise): CC BY-SA 4.0
    * Some textures have been modified or added
    * Modifications and additions by MysticTempest:
        * `mobs_mc_cave_spider.png`
        * `mobs_mc_enderman_eyes.png`
        * `mobs_mc_enderman.png`
        * `mobs_mc_ghast.png`
        * `mobs_mc_skeleton.png`
        * `mobs_mc_slime.png`
        * `mobs_mc_spider_eyes.png`
        * `mobs_mc_spider.png`
        * `mobs_mc_squid.png`
        * `mobs_mc_zombie.png`
        * `mobs_mc_villager_butcher.png`
        * `mobs_mc_villager_farmer.png`
        * `mobs_mc_villager_librarian.png`
        * `mobs_mc_villager.png`
        * `mobs_mc_villager_priest.png`
        * `mobs_mc_villager_smith.png`
        * `mobs_mc_parrot_blue.png`
        * `mobs_mc_parrot_green.png`
        * `mobs_mc_parrot_grey.png`
        * `mobs_mc_parrot_red_blue.png`
        * `mobs_mc_parrot_yellow_blue.png`
        * `mobs_mc_evoker_base.png` (modified by kingoscargames)
        * `mobs_mc_illusionist_bow.png`
        * `mobs_mc_illusionist.png`
        * `mobs_mc_vindicator_axe.png`
        * `mobs_mc_vindicator_base.png`
        * `mobs_mc_horse_skeleton.png`
    * Additions by kingoscargames:
        * `mobs_mc_vex.png`
        * `mobs_mc_vex_charging.png`
        * `mobs_mc_llama.png`
        * `mobs_mc_llama_creamy.png`
        * `mobs_mc_llama_brown.png`
        * `mobs_mc_llama_white.png`
        * `mobs_mc_llama_gray.png`
        * `mobs_mc_llama_chest.png`
        * `mobs_mc_endermite.png`
        * `mobs_mc_magmacube.png`
        * `mobs_mc_chicken.png`
        * `mobs_mc_wither.png`
        * `mobs_mc_wither_skeleton.png`
        * `mobs_mc_TEMP_wither_projectile.png`	
    * Gerold55
        * `mobs_mc_mooshroom_brown.png` (CC0)
        * `mobs_mc_mushroom_brown.png` (CC0)

* “Spawn egg” textures (`mobs_mc_spawn_icon_*`) by 22i
* Llama decor (carpet) textures (`mobs_mc_llama_decor_*`) by erlehmann and rudzik8
* Any other texture not mentioned here are licensed under the MIT License

## Sounds

* PilzAdam and Wuzzy (CC0)
    * `mobs_mc_chicken_lay_egg.ogg`
* [AGFX](http://www.freesound.org/people/DrMinky/sounds/) (CC0)
    * `mobs_mc_chicken_child.ogg`
        * Source: <https://freesound.org/people/AGFX/sounds/43380/>
* [evsecrets](https://freesound.org/people/evsecrets/sounds/) (CC0)
    * `mobs_mc_chicken_*.ogg`
        * Source: <https://freesound.org/people/evsecrets/sounds/346961/>
* [contramundum](https://freesound.org/people/contramundum/sounds/)
    * `mobs_mc_parrot_*.ogg`
        * Source: <https://freesound.org/people/contramundum/sounds/388417/>
* Randomation (CC0)
    * `green_slime_damage.ogg`
    * `green_slime_attack.ogg`
        * Source: <http://www.freesound.org/people/RandomationPictures/sounds/138481/>
* [Dr. Minky](http://www.freesound.org/people/DrMinky/sounds/) (CC BY 3.0)
    * `green_slime_jump.ogg`
    * `green_slime_land.ogg`
    * `green_slime_death.ogg`
* Zozzy from Freesound.org (CC0)
    * `mobs_mc_cow.ogg`
        * Source: <https://www.freesound.org/people/Zozzy/sounds/59245/>
* [Bird\_man](https://freesound.org/people/Bird_man/packs/16972/)
    * `mobs_mc_cow_hurt.ogg` (CC0)
        * Heavily modified
        * Source: <https://freesound.org/people/Bird_man/packs/16972/>
* [Klaraschick](https://freesound.org/people/Klaraschick/)
    * `mobs_mc_cow_milk.ogg` (CC0)
        * shortened
        * Source: <https://freesound.org/people/Klaraschick/sounds/415312/>
* [Hitrison](https://freesound.org/people/Hitrison/)
    * `mobs_mc_cow_mushroom_stew.ogg` (CC BY 3.0)
        * sound was modified
        * Source: <https://freesound.org/people/Hitrison/sounds/251411/>
* [NPXcoot](https://github.com/NPXcoot1) (CC BY-SA 4.0)
    * `mobs_mc_ender_dragon_*`
* [bevibeldesign](https://freesound.org/people/bevibeldesign/)
    * `mobs_mc_wither_spawn.ogg` (CC0)
        * Source: <https://freesound.org/people/bevibeldesign/sounds/366095/>
* [rubberduck](https://opengameart.org/users/rubberduck)
    * `mobs_mc_endermite_*.ogg` (CC0)
    * `mobs_mc_zombiepig_*.ogg` (CC0)
    * `mobs_mc_enderman_teleport_*.ogg` (CC0)
        * Source 1: <https://opengameart.org/content/80-cc0-creature-sfx>
        * Source 2: <https://opengameart.org/content/80-cc0-creture-sfx-2>
* [Soundscapes55](https://freesound.org/people/Soundscapes55/)
    * `mobs_mc_enderman_random.1.ogg` (CC0)
        * Source: <https://freesound.org/people/Soundscapes55/sounds/434973/>
* [griffinjennings](https://freesound.org/people/griffinjennings/)
    * `mobs_mc_enderman_death.*.ogg` (CC BY 3.0)
    * `mobs_mc_enderman_hurt.*.ogg` (CC BY 3.0)
        * Sounds were heavily modified
        * Source: <https://freesound.org/people/griffinjennings/sounds/463972/>
* [pointparkcinema](https://freesound.org/people/pointparkcinema/)
    * `mobs_mc_guardian_random.1.ogg` (CC0)
        * Source: <https://freesound.org/people/pointparkcinema/sounds/407252/>
* [nornalbion](https://freesound.org/people/nornalbion/)
    * `mobs_mc_guardian_random.2.ogg` (CC BY 3.0)
    * `mobs_mc_guardian_random.3.ogg` (CC BY 3.0)
    * `mobs_mc_guardian_hurt.*.ogg` (CC BY 3.0)
        * Sounds were modified
        * Source: <https://freesound.org/people/nornalbion/sounds/195733/>
* [TheBuilder15](https://freesound.org/people/TheBuilder15/)
    * `mobs_mc_guardian_death.ogg` (CC0)
        * Source: <https://freesound.org/people/pointparkcinema/sounds/407252/>
* Blender Foundation (CC BY 3.0)
    * `mobs_sheep.ogg`,
* daufinsyd (MIT License)
    * `mobs_mc_blaze_breath.ogg`
    * `mobs_mc_blaze_died.ogg`
* [qubodup](https://opengameart.org/content/slime-monster)
    * `mobs_mc_squid_hurt.*.ogg` (CC BY 3.0)
    * `mobs_mc_squid_death.*.ogg` (CC BY 3.0)
        * Changes were made
        * Source: <https://opengameart.org/content/slime-monster>
* [kyles](https://freesound.org/people/kyles/)
    * `mobs_mc_squid_flop.*.ogg` (CC0)
        * Source: <https://freesound.org/people/kyles/sounds/450830/>
    * `mobs_mc_snowman_hurt.1.ogg` (CC0)
        * Source: <https://freesound.org/people/kyles/sounds/450848/>
* [thefilmbakery](https://freesound.org/people/thefilmbakery/) (CC0)
    * `mobs_mc_blaze_hurt.ogg`
	* Source: <https://freesound.org/people/thefilmbakery/sounds/137836/>
* TenPlus1, from `mobs_monster` or `mobs_animal` mod (MIT License)
    * `mobs_fireball.ogg`
    * `mobs_mc_cat_idle.1.ogg`
    * `mobs_mc_llama.ogg`
    * `mobs_pig.ogg`
    * `mobs_pig_angry.ogg`
    * `mobs_sandmonster.ogg`
* [Daysycho](https://freesound.org/people/Darsycho/)
    * `mobs_mc_spider_hurt.*.ogg` (CC0)
        * Source: <https://freesound.org/people/Darsycho/sounds/505185/>
* [columbia23](https://freesound.org/people/columbia23/)
    * `mobs_mc_spider_death.ogg` (CC BY 3.0)
    * `mobs_mc_spider_random.*.ogg` (CC BY 3.0)
    * `mobs_mc_spider_attack.*.ogg` (CC BY 3.0)
        * Source: <https://freesound.org/people/columbia23/sounds/395395/>
* BrandonReese (LGPL v2.1)
    * `mobs_eerie.ogg`
* [Under7dude](https://freesound.org/people/Under7dude/) (CC0)
    * `mobs_mc_zombie_growl.ogg`
        * Source: <https://freesound.org/people/Under7dude/sounds/163445/>
* [haratman](https://freesound.org/people/haratman/) (CC0)
    * `mobs_mc_zombie_death.ogg`
        * Source: <https://freesound.org/people/haratman/sounds/393749/>
    * `mobs_mc_zombie_hurt.ogg`
        * Source: <https://freesound.org/people/haratman/sounds/393749/>
* [Spennnyyy](https://freesound.org/people/Spennnyyy/) (CC0)
    * `mcl_totems_totem.ogg`
        * Source: <https://freesound.org/people/Spennnyyy/sounds/323502/>
* [Baŝto](https://opengameart.org/users/ba%C5%9Dto)
    * `mobs_mc_skeleton_random.*.ogg` (CC BY 3.0)
        * Source: <https://opengameart.org/content/walking-skeleton>
* [spookymodem](https://freesound.org/people/spookymodem/)
    * `mobs_mc_skeleton_death.ogg` (CC0)
        * <https://freesound.org/people/spookymodem/sounds/202091/>
* [Cribbler](https://freesound.org/people/Cribbler/)
    * `mobs_mc_skeleton_hurt.ogg` (CC0)
        * Source: <https://freesound.org/people/Cribbler/sounds/381859/>
* [GoodListener](https://freesound.org/people/GoodListener/)
    * `mobs_mc_horse_random.1.ogg` (CC BY 3.0)
        * Source: <https://freesound.org/people/GoodListener/sounds/322454/>
    * `mobs_mc_horse_death.ogg` (CC BY 3.0)
        * Source: <https://freesound.org/people/GoodListener/sounds/322445/>
* [Garuda1982](https://freesound.org/people/Garuda1982/)
    * `mobs_mc_donkey_random.1.ogg` (CC BY 3.0)
    * `mobs_mc_donkey_hurt.ogg` (CC BY 3.0)
    * `mobs_mc_donkey_death.ogg` (CC BY 3.0)
        * Source: <https://freesound.org/people/Garuda1982/sounds/539505/>
* [JarredGibb](https://freesound.org/people/JarredGibb/sounds/233131/)
    * `mobs_mc_donkey_random.2.ogg` (CC0)
* [ERH](https://freesound.org/people/ERH/)
    * `mobs_mc_horse_random.2.ogg` (CC BY 3.0)
        * Source: <https://freesound.org/people/ERH/sounds/32043/>
* [j1987](https://freesound.org/people/j1987/)
    * `mobs_mc_creeper_death.ogg` (CC0)
        * Source: <https://freesound.org/people/j1987/sounds/111325>
* [themightyglider](https://opengameart.org/users/themightyglider)
    * `mobs_mc_creeper_hurt.ogg` (CC0)
        * Source: <https://opengameart.org/content/simple-fuse-sound>
* [pauliw](https://opengameart.org/users/pauliw)
    * `mobs_mc_vex_hurt.ogg` (CC0)
        * Source: <https://opengameart.org/content/some-kind-of-beings-soundsx>
    * `mobs_mc_vex_death.ogg` (CC0)
        * Source: <https://opengameart.org/content/some-kind-of-beings-sounds7>
* [suonho](https://freesound.org/people/suonho/)
    * `mobs_mc_bat_idle.ogg` (CC BY 3.0)
        * Source: <https://freesound.org/people/suonho/sounds/59344/>
* [toefur](https://freesound.org/people/toefur/)
    * `mobs_mc_bat_hurt.*.ogg` (CC0)
    * `mobs_mc_bat_death.ogg` (CC0)
        * Source: <https://freesound.org/people/toefur/sounds/288941/>
* [cmusounddesign](https://freesound.org/people/cmusounddesign/)
    * `mobs_mc_cat_hiss.ogg` (CC BY 3.0)
        * Source: <https://freesound.org/people/cmusounddesign/sounds/71899/>
* [SelsRoyalNavy](https://freesound.org/people/SelsRoyalNavy/)
    * `mobs_mc_cat_idle.2.ogg` (CC0)
        * Source: <https://freesound.org/people/SelsRoyalNavy/sounds/427081/>
* [ebcrosby](https://freesound.org/people/ebcrosby/)
    * `mobs_mc_ocelot_hurt.ogg` (CC BY 3.0)
        * Source: <https://freesound.org/people/ebcrosby/sounds/332979/>
* Hybrid Dog (forum.minetest.net)
    * `mobs_mc_wolf_hurt.*.ogg` (CC0)
    * `mobs_mc_wolf_bark.*.ogg` (CC0)
    * `mobs_mc_wolf_death.*.ogg` (CC0)
    * `mobs_mc_wolf_growl.*.ogg` (CC0)
        * Sounds modified and simplified
        * Source: "dogblocks" mod by Hybrid Dog <https://github.com/HybridDog/dogblocks/>
* [cliftoncarlson](https://freesound.org/people/cliftonmcarlson/)
    * `mobs_mc_wolf_take_bone.ogg` (CC0)
        * Source: <https://freesound.org/people/cliftonmcarlson/sounds/392883/>
* [Inocodum](https://forum.minetest.net/memberlist.php?mode=viewprofile&u=3115)
    * `mobs_mc_silverfish_hurt.ogg` (CC BY-SA 4.0)
    * `mobs_mc_silverfish_death.ogg` (CC BY-SA 4.0)
    * `mobs_mc_silverfish_idle.ogg` (CC BY-SA 4.0)
        * Source: <https://forum.minetest.net/viewtopic.php?f=17&t=10013>
* [LukeIRL](https://freesound.org/people/LukeIRL/)
    * `mobs_mc_magma_cube_small.ogg` (CC BY 4.0)
        * Derived from: <https://freesound.org/people/LukeIRL/sounds/176123/>
    * `mobs_mc_magma_cube_big.ogg` (CC BY 4.0)
        * Derived from: <https://freesound.org/people/LukeIRL/sounds/176123/>
* [kbnevel](https://freesound.org/people/kbnevel/)
    * `mobs_mc_magma_cube_attack.ogg` (CC0)
        * Derived from: <https://freesound.org/people/kbnevel/sounds/119863/>
* [InspectorJ](https://freesound.org/people/InspectorJ/sounds/429591/)
    * `mobs_mc_animal_eat_generic.ogg` (CC BY 3.0)
        * Source: <https://freesound.org/people/InspectorJ/>
* [tbsounddesigns](https://freesound.org/people/tbsounddesigns/)
    * `mobs_mc_bear_random.*.ogg` (CC BY 3.0)
        * Source 1: <https://freesound.org/people/tbsounddesigns/sounds/416853/>
        * Source 2: <https://freesound.org/people/tbsounddesigns/sounds/416857/>
        * Source 3: <https://freesound.org/people/tbsounddesigns/sounds/416855/>
    * `mobs_mc_bear_growl.*.ogg` (CC BY 3.0)
        * Source 1: <https://freesound.org/people/tbsounddesigns/sounds/416861/>
        * Source 2: <https://freesound.org/people/tbsounddesigns/sounds/416859/>
        * Source 3: <https://freesound.org/people/tbsounddesigns/sounds/416862/>
* [YleArkisto](https://freesound.org/people/YleArkisto/)
    * `mobs_mc_bear_attack.*.ogg` (CC BY 3.0)
    * `mobs_mc_bear_death.*.ogg` (CC BY 3.0)
    * `mobs_mc_bear_hurt.1.ogg` (CC BY 3.0)
        * Changes were made
        * Source: <https://freesound.org/people/YleArkisto/sounds/249441/>
* [alexo400](https://freesound.org/people/alexo400/)
    * `mobs_mc_snowman_death.*.ogg` (CC0)
        * Source: <https://freesound.org/people/alexo400/sounds/543385/>
* [cabled\_mess](https://freesound.org/people/cabled_mess/)
    * `mobs_mc_snowman_hurt.2.ogg` (CC0)
        * Source: <https://freesound.org/people/cabled_mess/sounds/384424/>
    * `mobs_mc_snowman_hurt.3.ogg` (CC0)
        * Source: <https://freesound.org/people/cabled_mess/sounds/384421/>
* [kessir](https://freesound.org/people/kessir/sounds/)
    * `mobs_mc_rabbit_hurt.*.ogg` (CC0)
    * `mobs_mc_rabbit_death.2.ogg` (CC0)
    * `mobs_mc_rabbit_death.3.ogg` (CC0)
        * Source: <https://freesound.org/people/kessir/sounds/372075/>
    * `mobs_mc_rabbit_attack.*.ogg` (CC0)
        * Source: <https://freesound.org/people/kessir/sounds/372076/>
    * `mobs_mc_rabbit_death.1.ogg` (CC0)
        * Source: <https://freesound.org/people/kessir/sounds/385850/>
* [Alshred](https://freesound.org/people/Alshred/sounds/403773/)
    * `mobs_mc_rabbit_random.*.ogg` (CC0)
        * Changes were made.
        * Source: <https://freesound.org/people/Alshred/>

Note: Many of these sounds have been more or less modified to fit the game.

Sounds not mentioned hre are licensed under CC0.
