# VoxeLibre
Неофициальная игра в стиле Minecraft для Minetest. Форк MineClone от davedevils.
Разработана многими людьми. Не разработана и не одобрена Mojang AB.

### Игровой процесс
Вы начинаете в случайно сгенерированном мире созданном целиком из кубов. Вы можете
исследовать мир, выкопать и поставить почти каждый блок в мире, чтобы создавать новые
структуры. Вы можете играть в “режиме выживания” в котором вам придется бороться с
монстрами и голодом за выживание и медленно проходить через различные аспекты игры,
такие как копание, фермерство, постройка механизмов и так далее. Или вы можете играть
в “творческом режиме” в котором вы сразу можете строить что угодно.

#### Итоги геймплея

* Геймплей в стиле песочницы, без целей
* Выживайте: сражайтесь с враждебными монстрами и голодом
* Добывайте руды и прочие ценные предметы
* Магия: получайте опыт и зачаруйте ваше снаряжение
* Создавайте из собранных блоков величественные постройки ограниченные только воображением
* Собирайте цветы и другие красители, чтобы раскрасить ваш мир
* Найдите семена и заведите ферму
* Найдите или создайте один из сотен предметов
* Проложите рельсы и повеселитесь с вагонетками
* Постройте сложные механизмы со схемами из редстоуна
* В творческом режиме вы можете свободно строить всё без лимитов

## Как играть (быстрый старт)
### Начнем

* **Бейте по стволу дерева** пока оно не сломается и соберите древесину
* Поставьте **древесину в сетку 2×2** (“сетка крафта” в вашем инвентаре) и скрафтите 4 доски
* Разложите 4 доски в форме 2×2 в сетке крафта, чтобы **сделать верстак**
* **Правым кликом по верстаку**, чтобы открыть сетку крафта 3×3 для более сложных предметов
* Используйте **книгу рецептов** (иконка книги), чтобы узнать все возможные рецепты крафтов
* **Скрафтите деревянную кирку**, чтобы вы могли копать камень
* Разные инструменты добывают разные виды блоков. Опробуйте их все!
* Продолжайте играть как пожелаете. Повеселитесь!

### Фермерство
* Найдите семена
* Скрафтите мотыгу
* Правой кнопкой мотыгой по земле или похожему блоку, чтобы создать грядку
* Посадите семена на грядку и ждите пока они вырастут
* Соберите растение когда оно полностью созреет
* Рядом с водой грядка становится влажной и растения растут быстрее

### Переплавка
* Скрафтите печь
* Печь позволит вам получить больше предметов
* Верхний слот должен содержать переплавляемый предмет (например: железную руду)
* Нижний слот должен содержать топливо (например: уголь)
* Смотрите книгу рецептов, чтобы узнать о других переплавляемых предметах и топливе

### Дополнительная помощь
Больше информации о геймплее, блоках, предметах и многое другое можно найти во
внутриигровой справке. Вы можете перейти в неё через ваш инвентарь.

### Особые предметы
Следующие предметы интересны для творческого режима и для строителей приключенческих
карт. Их нельзя получить в игре или через творческий инвентарь.

* Барьер: `mcl_core:barrier`

Используйте чат-команду `/giveme`, чтобы получить их.
Смотрите справку для дальнейшей информации.

## Установка
Эта игра требует [Minetest](http://minetest.net) для запуска (версия 5.4.1 или
выше). Вам нужно сперва установить Minetest. Только стабильные версии поддерживаются
официально. Не поддерживается запуск VoxeLibre на разрабатываемых версиях Minetest.

Чтобы установить VoxeLibre (если вы этого еще не сделали), переместите эту папку в
“games” в папке данных Minetest. Смотрите справку Minetest, чтобы узнать больше.

## Полезные ссылки
Репозиторий VoxeLibre хранится на Mesehub. Зайдите туда, чтобы оставить запрос или
поучаствовать в разработке.

* Mesehub: <https://git.minetest.land/MineClone2/MineClone2>
* Discord: <https://discord.gg/xE4z8EEpDC>
* YouTube: <https://www.youtube.com/channel/UClI_YcsXMF3KNeJtoBfnk9A>
* ContentDB: <https://content.minetest.net/packages/wuzzy/mineclone2/>
* OpenCollective: <https://opencollective.com/mineclone2>
* Mastodon: <https://fosstodon.org/@MineClone2>
* Lemmy: <https://lemmy.world/c/mineclone2>
* Matrix space: <https://app.element.io/#/room/#mcl2:matrix.org>
* Форум Minetest: <https://forum.minetest.net/viewtopic.php?f=50&t=16407>
* Reddit: <https://www.reddit.com/r/MineClone2/>
* IRC (едва используется): <https://web.libera.chat/#mineclone2>

## Цели
- Создать стабильную, модифицируемую, бесплатную и свободную игру основанную на
Minecraft на движке Minetest с проработанными возможностями для одиночной игры и
для мультиплеера. На данный момент множество возможностей **Minecraft Java
Edition** уже реализовано и доработка имеющегося контента в приоритете над
добавлением нового.
- Реализовать возможности на уровне **текущей версии Minecraft + OptiFine** (OptiFine
настолько, насколько это поддерживается движком Minetest).
- Добиться производительности для запуска на действительно слабых компьютерах.

## Готовность
Игра сейчас на стадии **бета**.  Она играбельна, но еще не имеет всех возможностей.
Обратная совместимость целиком не гарантируется, обновление вашего мира может повлечь
за собой небольшие ошибки.  Если вы хотите использовать разрабатываемую версию
VoxeLibre, то ветка master обычно относительно стабильна.

Следущие возможности уже доступны:

* Инструменты, оружие, броня
* Система крафта: сетка 2×2, верстак (сетка 3×3) и книга рецептов
* Сундуки, большие сундуки, эндер-сундуки, ящики шалкера
* Печи и воронки
* Система голода
* Большинство монстров и животных
* Все руды из Minecraft
* Большинство блоков из Верхнего мира
* Вода и лава
* Погода
* 28 биомов + 5 биомов в Незере
* Незер, пылающий подземный мир в другом измерении
* Схемы из редстоуна (частично)
* Вагонетки (частично)
* Статусные эффекты (частично)
* Опыт
* Зачарование
* Зельеварение, зелья, смоченные стрелы (частично)
* Лодки
* Огонь
* Строительные блоки: ступени, плиты, двери, люки, заборы, калитки, стены
* Часы
* Компас
* Губки
* Блоки слизи
* Растения и саженцы
* Красители
* Флаги
* Декоративные блоки: стекло, окрашенное стекло, стеклянные панели, железные решетки, цветная керамика, головы и многое другое
* Рамки для предметов
* Прогрыватели
* Кровати
* Меню инвентаря
* Творческий инвентарь
* Фермерство
* Книги с пером
* Команды
* Деревни
* Измерение Края
* И многое другое!

Следующие возможности еще не завершены:

* Некоторые монстры и животные
* Предметы связанные с редстоуном
* Некоторые вагонетки (с сундуком и с воронкой уже работают)
* Пара нетривиальных блоков и предметов

Бонусные возможности (нет в Minecraft-е):

* Встроенный гайд для крафта покажет вам рецепты крафта и переплавки
* Внутриигровая справка содержит всестороннюю информацию об основах игры, блоках, предметах и прочее
* Временные рецепты крафта. Они существуют, чтобы получить доступ к ранее недоступным предметам вне творческого режима. Они будут удалены как только разработка позволит им стать доступными
* Саженцы в сундуках в [mapgen v6](https://wiki.minetest.net/Map_generator#v6)
* Полностью модифицируема (благодаря мощному Lua API в Minetest)
* Новые блоки и предметы:
    * Инструмент просмотра покажет справку о том чего коснется
    * Больше ступеней и плит
    * Калитки и заборы из адских кирпичей
* Замены структур - малые верии структур из Minecraft пока большие структуры не будут сделаны:
    * Лесная хижина (Особняк)
    * Форт Незера (Крепости)

Технические отличия от Minecraft:

* Лимит высоты - 31000 блоков (намного больше чем в Minecraft)
* Горизонтальный размер мира - 62000×62000 блоков (намного меньше чем в Minecraft, но всё еще очень большой)
* Всё еще не завершен и содержит много багов
* Недостающие блоки, предметы, мобы
* Некоторые предметы с другими названиями, чтобы лучше их различать
* Другая музыка для проигрывателей
* Другие текстуры (Pixel Perfection)
* Другие звуки (разные источники)
* Другой движок (Minetest)
* Другие пасхалки

… и наконец, VoxeLibre это свободное программное обеспечение!

## Другие readme файлы

* `LICENSE.txt`: текст лицензии GPLv3
* `CONTRIBUTING.md`: информация для тех кто хочет поучаствовать в разработке
* `API.md`: для моддеров Minetest кто хочет изменить эту игру
* `LEGAL.md`: юридическая информация
* `CREDITS.md`: список участников проекта
