# VoxeLibre
一款受 Minecraft 启发的 Luanti 游戏。由 davedevils 从 MineClone 分叉。由许多人开发，请参阅 CREDITS.md 以获取完整列表。

### 游戏玩法
你从一个完全由方块组成的随机生成的世界开始。您可以探索世界，挖掘和建造世界上几乎所有的方块，以创建新的结构。您可以选择 “生存模式”，在这种模式下，您必须与怪物搏斗，为生存而忍饥挨饿，并在游戏的其他各方面慢慢取得进展。如采矿、耕作、建造机器等。或者你也可以选择 “创意模式”，在这种模式下，你几乎可以立即建造任何东西。

#### 游戏概述

* 沙盒式游戏，无目标
* 生存：与敌对怪物和饥饿作斗争
* 开采矿石和其他宝藏
* 魔法：获得经验并对工具施魔法
* 用收集到的方块来建造伟大的建筑，你的想象力是有限的
* 收集鲜花（和其他染料来源），为你的世界着色
* 找到一些种子，开始耕种
* 找到或制作数百件物品中的一件
* 建设铁路系统，享受矿车的乐趣
* 用红石电路建造复杂的机器
* 在创意模式下，你几乎可以自由、无限制地构建任何东西

## 如何游玩（快速入门）
### 开始
* **砍树** 直到它折断，然后收集木头
* 将 **木材放入2×2网格** （库存菜单中的“制作网格”）中，制作4块木板
* 将4块木板以2×2的形状放置在制作网格中，以 **制作一个工作台**
* **右键单击工作台** 获得3×3的制作网格，以制作更复杂的东西
* 使用 **制作指南** （书籍图标）学习所有可能的制作方法
* **制作一把木镐** 这样你就可以挖石头了
* 不同的工具会打破不同种类的方块。试试看！
* 按照你的意愿继续玩。玩得高兴！

### 耕种
* 寻找种子
* 制作一把锄头
* 用锄头右键点击泥土或类似的块，创建农田
* 把种子放在农田里，观察它们生长
* 植物长成后收集起来
* 如果靠近水源，农田会变得潮湿并加速生长

### 熔炉
* 制作一个熔炉
* 熔炉可让你获取更多物品
* 上方的格子必须放置可熔炼的物品（例如：铁矿石）
* 下方的格子必须放置燃料物品（例如：煤炭）
* 查看制作指南中的提示信息以了解燃料及可熔炼物品的相关情况。

### 额外帮助
有关游戏玩法、方块、物品等更多帮助内容可在游戏内查看。你可以从你的物品栏菜单中进入帮助界面。

### 特殊物品
以下物品对于创造模式以及冒险地图制作者来说很有意思。它们无法在游戏内或创造模式物品栏中获取。
* 屏障：`mcl_core:barrier`
使用`/giveme`聊天命令来获取它们。查看游戏内的帮助以获取相关说明。

## 安装
为了能以最佳性能运行游戏并获得支持，我们推荐使用[Luanti](https://www.luanti.org/)的最新稳定版本，不过我们也一直尽力对次新版本提供支持。在某些情况下，旧版本或许也够用，但你会错过Luanti的一些重要功能，而这些功能对我们这款游戏的重要特性起着关键作用。
VoxeLibre不支持在Luanti的开发版本中运行。
要安装VoxeLibre（如果你还未安装的话），将此目录移至你的Luanti数据目录下的“games”目录中。查阅Luanti的帮助文档以了解更多信息。

## 有用链接
VoxeLibre的代码仓库托管在Mesehub上。如需贡献代码或报告问题，请前往此处。
* Mesehub：<https://git.minetest.land/VoxeLibre/VoxeLibre>
* Discord：<https://discord.gg/xE4z8EEpDC>
* YouTube：<https://www.youtube.com/channel/UClI_YcsXMF3KNeJtoBfnk9A>
* ContentDB：<https://content.minetest.net/packages/wuzzy/mineclone2/>
* OpenCollective：<https://opencollective.com/mineclone2>
* Mastodon：<https://fosstodon.org/@VoxeLibre>
* Lemmy：<https://lemm.ee/c/voxelibre>
* Matrix空间：<https://app.element.io/#/room/#voxelibre:matrix.org>
* Minetest论坛：<https://forum.minetest.net/viewtopic.php?f=50&t=16407>
* Reddit：<https://www.reddit.com/r/VoxeLibre/>
* IRC（很少使用）：<https://web.libera.chat/#mineclone2>

## 目标
- 利用Luanti引擎打造一款稳定、性能良好、可模组化、自由开源且受《我的世界》启发的游戏，该游戏可用于单人及多人模式。
- 目前，很多功能已经实现。对现有功能进行完善总是受欢迎的。

## 完成状态
这款游戏目前处于**测试版**阶段。
它可以玩，但功能尚未完备。
并不完全保证向后兼容性，更新你的世界可能会导致一些小的漏洞出现。
如果你想在正式环境中使用VoxeLibre的开发版本，主分支通常相对稳定。

以下是已有的主要功能：
* 工具、武器
* 盔甲
* 制作系统：2×2制作格、工作台（3×3制作格）、熔炉，包括制作指南
* 箱子、大箱子、末影箱、潜影盒
* 熔炉、漏斗
* 饥饿值系统
* 大多数怪物和动物
* 《我的世界》中的所有矿石
* 主世界中的大多数方块
* 水和岩浆
* 天气系统
* 28种生物群系 + 5种下界生物群系
* 下界，另一个维度中的炽热地下世界
* 红石电路（部分功能）
* 矿车（部分功能）
* 状态效果（部分功能）
* 经验系统
* 附魔系统
* 酿造、药水、药箭（部分功能）
* 船
* 火
* 建筑方块：楼梯、台阶、门、活板门、栅栏、栅栏门、围墙
* 时钟
* 指南针
* 海绵
* 黏液块
* 小型植物和树苗
* 染料
* 旗帜
* 装饰方块：玻璃、染色玻璃、玻璃板、铁栏杆、硬化黏土（及各种颜色）、头颅等等
* 物品展示框
* 唱片机
* 床
* 物品栏菜单
* 创造模式物品栏
* 农耕系统
* 可书写的书籍
* 指令系统
* 村庄
* 末地
* 以及更多功能！

以下是尚未完成的功能：
* 部分怪物和动物
* 与红石相关的内容
* 部分特殊矿车（漏斗矿车和箱子矿车可用）
* 一些较复杂的方块和物品

额外特色功能（《我的世界》中没有的）：
* 内置制作指南，可向你展示制作和熔炼配方
* 游戏内帮助系统，包含有关游戏玩法基础、方块、物品等的详尽帮助内容
* 临时制作配方。它们的存在只是为了让你在非创造模式下能获取一些原本无法获取的物品。随着开发推进以及更多功能上线，这些配方将会被移除。
* 在[地图生成器v6](https://wiki.minetest.net/Map_generator#v6)中箱子里的树苗
* 完全可模组化（得益于Minetest强大的Lua应用程序编程接口）
* 新的方块和物品：
    * 查找工具，触碰任何东西都会显示其相关帮助信息
    * 更多的台阶和楼梯
    * 下界砖栅栏门
    * 红色下界砖栅栏
    * 红色下界砖栅栏门
* 结构替换——这些《我的世界》结构的小型变体可作为替代品，直至我们能让大型结构正常运作：
    * 林地小屋（代替府邸）
    * 下界前哨站（代替要塞）

与《我的世界》的技术差异：
* 高度限制约为31000格（比《我的世界》中的高很多）
* 水平世界大小约为62000×62000格（比《我的世界》中的小很多，但仍然非常大）
* 仍然很不完善且存在漏洞
* 方块、物品、敌人及其他功能有所缺失
* 一些物品的名称稍有不同，以便于区分
* 唱片机的音乐不同
* 纹理不同（像素完美风格）
* 声音不同（来源多样）
* 引擎不同（Luanti）
* 彩蛋不同

……最后，VoxeLibre是自由软件（“自由”意为“自由权”）！

## 其他自述文件
* `LICENSE.txt`：GPLv3许可协议文本
* `CONTRIBUTING.md`：面向想要做出贡献的人员的相关信息
* `API.md`：供想要为此游戏制作模组的Minetest模组制作者使用的文档
* `LEGAL.md`：法律相关信息
* `CREDITS.md`：所有贡献者名单 