<div align="center">
<img src="/VoxeLibre/VoxeLibre/raw/branch/master/menu/icon.png">
<h1>VoxeLibre</h1>
<a href="https://content.luanti.org/packages/Wuzzy/mineclone2/">
	<img src="https://content.luanti.org/packages/Wuzzy/mineclone2/shields/downloads/" alt="ContentDB">
</a>
<a href="https://www.gnu.org/copyleft/gpl.html">
	<img src="https://img.shields.io/badge/License-GPLv3+-blue.svg" alt="GPLv3+ License">
</a>
</div>

VoxeLibre is a survival sandbox game for Luanti. Survive, gather, hunt, mine for ores,
build, explore, and do much more. Inspired by Minecraft, pushing beyond.

Originally forked from MineClone (by davedevils) as MineClone 2, then renamed
and heavily improved. Developed by many people, see
[`CREDITS.md`](CREDITS.md) for a complete list.


## About

You start in a randomly generated world made entirely of cubes. You can explore
the world, dig, and build using almost every available block to create new
structures. You can choose to play in **survival mode**, in which you must fight
monsters and stave off hunger while slowly progressing through various aspects
of the game—such as mining, farming, and building machines. Alternatively, you
can opt for **creative mode**, where you can do anything you can imagine with a
snap of your fingers.

See [`GETTING_STARTED.md`](GETTING_STARTED.md) for a quick guide on how to start
playing VoxeLibre.

### Gameplay summary

* **Sandbox-style gameplay with no set goals**
* Survive by fighting hostile monsters and combating hunger
* Mine for ores and hunt for underground treasures
* Master magic by gaining experience and enchanting your tools
* Gather blocks to build and unleash your imagination
* Collect flowers and other dye sources to colorize your world
* Find seeds and start farming for food and resources
* Discover or craft hundreds of items
* Have fun with minecarts by building a railroad or a rollercoaster
* Construct complex machines using redstone circuits
* Play in creative mode to create without limits

### Notable features

A lot of the gameplay and features will be instantly familiar to the Minecraft
players. VoxeLibre expands on top of those with lots of nice additions made by
our many developers and contributors. Here are some highlights:

* Awesome in-game and main menu music, toggleable using `/music`
* Many additional decoration blocks, as well as stair and slab variants
* Original tools and weapons, such as hammers and throwable spears
* Consistent nice-looking artwork
* Unique items, including the Hamburger to lure villagers
* One-of-a-kind structures to explore
* Nether portals of any enclosed shape (hearts, donuts, etc)
* Signs with support for many languages
* Advanced minecart physics with derailing and more
* Great modding support making use of Luanti's powerful Lua scripting
* Fun easter eggs to discover
* **...and so much more!**


## Useful links

The VoxeLibre Git repository is hosted at Mesehub. To contribute or report
issues, head over there.

* Mesehub: <https://git.minetest.land/VoxeLibre/VoxeLibre>
* ContentDB: <https://content.luanti.org/packages/wuzzy/mineclone2/>
* Luanti Forums: <https://forum.luanti.org/viewtopic.php?f=50&t=16407>
* Discord: <https://discord.gg/xE4z8EEpDC>
* Matrix space: <https://app.element.io/#/room/#voxelibre:matrix.org>
* Mastodon: <https://fosstodon.org/@VoxeLibre>
* Lemmy: <https://lemm.ee/c/voxelibre>
* Reddit: <https://www.reddit.com/r/VoxeLibre/>
* YouTube: <https://www.youtube.com/channel/UClI_YcsXMF3KNeJtoBfnk9A>
* OpenCollective: <https://opencollective.com/voxelibre>


## Status

VoxeLibre is currently in the **beta** stage. It is fully playable, but not yet
feature-complete, and you may encounter bugs while playing. Backwards
compatibility is not entirely guaranteed, and upgrading your world might cause
small bugs. If you want to, you can use the development version (the `master`
Git branch) to get the newest content and help us catch bugs before release.

### Goals

* Create a stable, peformant, moddable and fun free & open-source game, making
  the most out of the Luanti engine, playable both in single- and multiplayer
* Expand and improve upon the gameplay that many players are familiar with,
  adding unique features and polishing the existing ones along the way
* Work on the tasks outlined in the [Milestones](/VoxeLibre/VoxeLibre/milestones)
  and themed [Projects](/VoxeLibre/VoxeLibre/projects) to make the game better
* Ensure proper localization support, enabling translations in as many languages
  as possible
* [Maintain a friendly and inclusive community of players and developers](CODE_OF_CONDUCT.md)


## See also

* [`GETTING_STARTED.md`](GETTING_STARTED.md): Quick guide on how to start
  playing
* [`CONTRIBUTING.md`](CONTRIBUTING.md): Information for those who want to contribute
* [`API.md`](API.md): For people who want to mod VoxeLibre
* [`LICENSE.txt`](LICENSE.txt): Full text of the GNU GPLv3 license
* [`LEGAL.md`](LEGAL.md): Legal information
* [`CREDITS.md`](CREDITS.md): List of all developers and contributors
