# Getting Started

## Installation

To play VoxeLibre with the best possible performance and support, we recommend
using the latest stable version of [Luanti](https://www.luanti.org/). However,
we always make an effort to support at least two earlier versions to keep the
game playable for everyone. The development versions of Luanti are not supported
for gameplay due to their instability, but we encourage developers to run them
to ensure faster support for upcoming engine versions.

To install VoxeLibre (if you haven't already), open your Luanti client, go to
the **Content** tab, press **Browse online content** and switch to the **Games**
tab located at the top-left corner. From there, find VoxeLibre, open its package
page and press **Install**. It's that easy!


## How to play

### Basic controls

VoxeLibre makes use of the control scheme provided by Luanti. Depending on your
platform (PC, Mobile, or other), the specific keys or buttons corresponding to
in-game actions may vary a lot. Open the **Settings** menu, navigate to the
**Controls** category and inspect the control scheme from there, tweaking it as
you see fit.

The **Aux1** or **Special** action is assigned to sprinting.

### Starting out

* Punch a tree until it breaks and collect its trunk as blocks
* Place the tree trunks into the 2×2 grid (the **crafting grid** in your
  inventory menu) and craft wood planks out of them, 4 blocks per trunk
* Place 4 wood planks in a 2×2 shape in the crafting grid to make a **crafting
  table**
* Press <kbd>Place</kbd> (right-click) on the crafting table to access a 3×3
  crafting grid for more complex recipes
* Use the **crafting guide** (book icon) to learn all possible crafting recipes
* Craft a **wooden pickaxe** to dig stone and collect cobblestone, essential for
  many recipes
* All tools differ by type and tier. Try out axes, hoes, shovels and swords,
  crafted by putting different materials in familiar shapes
* Continue playing as you wish. Have fun!

### Farming

* Find some seeds
* Craft a hoe
* <kbd>Place</kbd> (right-click) on dirt or a similar block to cultivate it
  to **farmland**
* Place seeds on farmland and watch them grow under light
* If near water, farmland becomes wet and speeds up growth
* Harvest mature plants for food and replanting

### Cooking and smelting

* Craft a **furnace** with 8 blocks of cobblestone
* Upper slot must contain a cookable/smeltable item (e.g. potato or raw iron)
* Lower slot must contain a fuel item (e.g. coal)
* See tooltips in crafting guide to learn about fuels and cookable/smeltable
  items
* Upgrade to specialized blocks to speed it up: a **blast furnace** to smelt
  metal or a **smoker** to cook food

### Additional help

More information about the gameplay, blocks, items and much more can easily be
accessed from inside the game. Navigate to the **Help** menu from the inventory
and explore VoxeLibre's massive knowledge base.

### Special items

The following items are interesting for use in creative mode and for adventure
map builders in particular. They cannot be obtained in-game or from the creative
inventory.

* Barrier: `mcl_core:barrier`

Use the `/giveme` chat command to obtain them. See the in-game help for an
explanation.
