---
--- Generated by EmmyLua(https://github.com/EmmyLua)
--- Created by Michieal.
--- DateTime: 5/11/25 7:13 PM
---
local modname = minetest.get_current_modname()
local modpath = minetest.get_modpath(modname)
local S = minetest.get_translator(modname)
--
-- Tool definition
--

--[[
dig_speed_class group:
- 1: Painfully slow
- 2: Very slow
- 3: Slow
- 4: Fast
- 5: Very fast
- 6: Extremely fast
- 7: Instantaneous
]]


-- Help texts
local hoe_tt = S("Turns block into farmland")
local hoe_longdesc = S("Hoes are essential tools for growing crops. They are used to create farmland in order to plant seeds on it. Hoes can also be used as very weak weapons in a pinch.")
local hoe_usagehelp = S("Use the hoe on a cultivatable block (by rightclicking it) to turn it into farmland. Dirt, grass blocks and grass paths are cultivatable blocks. Using a hoe on coarse dirt turns it into dirt.")

local pickaxe_longdesc = S("Pickaxes are mining tools to mine hard blocks, such as stone. A pickaxe can also be used as weapon, but it is rather inefficient.")
local axe_longdesc = S("An axe is your tool of choice to cut down trees, wood-based blocks and other blocks. Axes deal a lot of damage as well, but they are rather slow.")

local sword_longdesc = S("Swords are great in melee combat, as they are fast, deal high damage and can endure countless battles. Swords can also be used to cut down a few particular blocks, such as cobwebs.")
-- local sword_use = S("To slash multiple enemies, hold the sword in your hand, then use (rightclick) an enemy.")
-- TODO slash attack not implemented yet

local shovel_longdesc = S("Shovels are tools for digging coarse blocks, such as dirt, sand and gravel. They can also be used to turn grass blocks to grass paths. Shovels can be used as weapons, but they are very weak.")
local shovel_use = S("To turn a grass block into a grass path, hold the shovel in your hand, then use (rightclick) the top or side of a grass block. This only works when there's air above the grass block.")

local hammer_tt = S("Can crush blocks") .. "\n" .. S("Increased knockback")
local hammer_longdesc = S("Hammers are great in melee combat, as they deal high damage with increased knockback and can endure countless battles. Hammers can also be used to crush things.")
local hammer_use = S("To crush a block, dig the block with the hammer. This only works with some blocks.")

local spear_tt = S("Reaches farther") .. "\n" .. S("Can be thrown")
local spear_longdesc = S("Spears are great in melee combat, as they have an increased reach. They can also be thrown.")
local spear_use = S("To throw a spear, hold it in your hand, then hold use (rightclick) in the air.")

local wield_scale = mcl_vars.tool_wield_scale

---- variable values... (partial list.)
local deepslate = {
	uses = 150,
	speed = 4.25,
	level = 3,
	hammerspeed = 2.25,
	spearspeed = 2,
	spearlevel = 1,
	stone = 150
}

local SPEAR_RANGE = 4.5

local function spear_on_place(itemstack, user, pointed_thing)
	if pointed_thing.type == "node" then
		-- Call on_rightclick if the pointed node defines it
		local node = core.get_node(pointed_thing.under)
		if user and not user:get_player_control().sneak then
			if core.registered_nodes[node.name] and core.registered_nodes[node.name].on_rightclick then
				return core.registered_nodes[node.name].on_rightclick(pointed_thing.under, node, user, itemstack) or itemstack
			end
		end
	end

	itemstack:get_meta():set_int("active", 1)
	return itemstack
end

local function create_soil(pos, inv)
	if pos == nil then
		return false
	end
	local node = minetest.get_node(pos)
	local name = node.name
	local above = minetest.get_node({x=pos.x, y=pos.y+1, z=pos.z})
	if minetest.get_item_group(name, "cultivatable") == 2 then
		if above.name == "air" then
			node.name = "mcl_farming:soil"
			minetest.set_node(pos, node)
			minetest.sound_play("default_dig_crumbly", { pos = pos, gain = 0.5 }, true)
			return true
		end
	elseif minetest.get_item_group(name, "cultivatable") == 1 then
		if above.name == "air" then
			node.name = "mcl_core:dirt"
			minetest.set_node(pos, node)
			minetest.sound_play("default_dig_crumbly", { pos = pos, gain = 0.6 }, true)
			return true
		end
	end
	return false
end

local hoe_on_place_function = function(wear_divisor)
	return function(itemstack, user, pointed_thing)
		-- Call on_rightclick if the pointed node defines it
		local node = minetest.get_node(pointed_thing.under)
		if user and not user:get_player_control().sneak then
			if minetest.registered_nodes[node.name] and minetest.registered_nodes[node.name].on_rightclick then
				return minetest.registered_nodes[node.name].on_rightclick(pointed_thing.under, node, user, itemstack) or itemstack
			end
		end

		if minetest.is_protected(pointed_thing.under, user:get_player_name()) then
			minetest.record_protection_violation(pointed_thing.under, user:get_player_name())
			return itemstack
		end

		if create_soil(pointed_thing.under, user:get_inventory()) then
			if not minetest.is_creative_enabled(user:get_player_name()) then
				itemstack:add_wear(65535/wear_divisor)
				tt.reload_itemstack_description(itemstack) -- update tooltip
			end
			return itemstack
		end
	end
end

local make_grass_path = function(itemstack, placer, pointed_thing)
	-- Use pointed node's on_rightclick function first, if present
	local node = minetest.get_node(pointed_thing.under)
	if placer and not placer:get_player_control().sneak then
		if minetest.registered_nodes[node.name] and minetest.registered_nodes[node.name].on_rightclick then
			return minetest.registered_nodes[node.name].on_rightclick(pointed_thing.under, node, placer, itemstack) or itemstack
		end
	end

	-- Only make or remove grass path if tool used on side or top of target node
	if pointed_thing.above.y < pointed_thing.under.y then
		return itemstack
	end

	-- Remove grass paths
	if (minetest.get_item_group(node.name, "path_remove_possible") == 1) and placer:get_player_control().sneak then
		local above = table.copy(pointed_thing.under)
		above.y = above.y + 1
		if minetest.get_node(above).name == "air" then
			if minetest.is_protected(pointed_thing.under, placer:get_player_name()) then
				minetest.record_protection_violation(pointed_thing.under, placer:get_player_name())
				return itemstack
			end

			if not minetest.is_creative_enabled(placer:get_player_name()) then
				-- Add wear (as if digging a shovely node)
				local toolname = itemstack:get_name()
				local wear = mcl_autogroup.get_wear(toolname, "shovely")
				if wear then
					itemstack:add_wear(wear)
					tt.reload_itemstack_description(itemstack) -- update tooltip
				end
			end
			minetest.sound_play({name="default_grass_footstep", gain=1}, {pos = above, max_hear_distance = 16}, true)
			minetest.swap_node(pointed_thing.under, {name="mcl_core:dirt"})
		end
	end

	-- Make grass paths
	if (minetest.get_item_group(node.name, "path_creation_possible") == 1) and not placer:get_player_control().sneak then
		local above = table.copy(pointed_thing.under)
		above.y = above.y + 1
		if minetest.get_node(above).name == "air" then
			if minetest.is_protected(pointed_thing.under, placer:get_player_name()) then
				minetest.record_protection_violation(pointed_thing.under, placer:get_player_name())
				return itemstack
			end

			if not minetest.is_creative_enabled(placer:get_player_name()) then
				-- Add wear (as if digging a shovely node)
				local toolname = itemstack:get_name()
				local wear = mcl_autogroup.get_wear(toolname, "shovely")
				if wear then
					itemstack:add_wear(wear)
					tt.reload_itemstack_description(itemstack) -- update tooltip
				end
			end
			minetest.sound_play({name="default_grass_footstep", gain=1}, {pos = above, max_hear_distance = 16}, true)
			minetest.swap_node(pointed_thing.under, {name="mcl_core:grass_path"})
		end
	end
	return itemstack
end

local function make_stripped_trunk(itemstack, placer, pointed_thing)
	if pointed_thing.type ~= "node" then return end

	local node = minetest.get_node(pointed_thing.under)
	local node_name = minetest.get_node(pointed_thing.under).name

	local noddef = minetest.registered_nodes[node_name]

	if not noddef then
		minetest.log("warning", "Trying to right click with an axe the unregistered node: " .. tostring(node_name))
		return
	end

	if not placer:get_player_control().sneak and noddef.on_rightclick then
		return minetest.item_place(itemstack, placer, pointed_thing)
	end
	if minetest.is_protected(pointed_thing.under, placer:get_player_name()) then
		minetest.record_protection_violation(pointed_thing.under, placer:get_player_name())
		return itemstack
	end

	if noddef._mcl_stripped_variant == nil then
		return itemstack
	else
		minetest.swap_node(pointed_thing.under, {name=noddef._mcl_stripped_variant, param2=node.param2})
		if minetest.get_item_group(node_name, "waxed") ~= 0 then
			awards.unlock(placer:get_player_name(), "mcl:wax_off")
		end
		if not minetest.is_creative_enabled(placer:get_player_name()) then
			-- Add wear (as if digging a axey node)
			local toolname = itemstack:get_name()
			local wear = mcl_autogroup.get_wear(toolname, "axey")
			if wear then
				itemstack:add_wear(wear)
				tt.reload_itemstack_description(itemstack) -- update tooltip
			end
		end
	end
	return itemstack
end

-- include crafting recipes
dofile(modpath .. "/crafting.lua")

-- Register tools.

minetest.register_tool("vl_deepslate_tools:pick_deepslate", {
	description = S("Deepslate Pickaxe"),
	_doc_items_longdesc = pickaxe_longdesc,
	inventory_image = "vl_deepslate_tools_deepslatepick.png",
	wield_scale = wield_scale,
	groups = { tool = 1, pickaxe = 1, dig_speed_class = 3, enchantability = 5 },
	tool_capabilities = {
		-- 1/1.2
		full_punch_interval = 0.83333333,
		max_drop_level = 3,
		damage_groups = { fleshy = 3 },
		punch_attack_uses = 66,
	},
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_deepslate:deepslate_cobbled",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		pickaxey = { speed = deepslate.speed, level = deepslate.level, uses = deepslate.uses }
	},
	vl_max_ench_lvl = 2,
})

minetest.register_tool("vl_deepslate_tools:shovel_deepslate", {
	description = S("Deepslate Shovel"),
	_doc_items_longdesc = shovel_longdesc,
	_doc_items_usagehelp = shovel_use,
	inventory_image = "vl_deepslate_tools_deepslateshovel.png",
	wield_scale = wield_scale,
	groups = { tool = 1, shovel = 1, dig_speed_class = 3, enchantability = 5 },
	tool_capabilities = {
		full_punch_interval = 1,
		max_drop_level = 3,
		damage_groups = { fleshy = 3 },
		punch_attack_uses = 66,
	},
	on_place = make_grass_path,
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_deepslate:deepslate_cobbled",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		shovely = { speed = deepslate.speed, level = deepslate.level, uses = deepslate.uses }
	},
	vl_max_ench_lvl = 2,
})

minetest.register_tool("vl_deepslate_tools:hoe_deepslate", {
	description = S("Deepslate Hoe"),
	_tt_help = hoe_tt,
	_doc_items_longdesc = hoe_longdesc,
	_doc_items_usagehelp = hoe_usagehelp,
	inventory_image = "vl_deepslate_tools_deepslatehoe.png",
	wield_scale = mcl_vars.tool_wield_scale,
	on_place = hoe_on_place_function(deepslate.stone),
	groups = { tool = 1, hoe = 1, enchantability = 5 },
	tool_capabilities = {
		full_punch_interval = 0.5,
		damage_groups = { fleshy = 1, },
		punch_attack_uses = deepslate.stone,
	},
	_repair_material = "mcl_deepslate:deepslate_cobbled",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		hoey = { speed = deepslate.speed, level = deepslate.level, uses = deepslate.uses }
	},
	vl_max_ench_lvl = 2,
})

minetest.register_tool("vl_deepslate_tools:axe_deepslate", {
	description = S("Deepslate Axe"),
	_doc_items_longdesc = axe_longdesc,
	inventory_image = "vl_deepslate_tools_deepslateaxe.png",
	wield_scale = wield_scale,
	groups = { tool = 1, axe = 1, dig_speed_class = 3, enchantability = 5 },
	tool_capabilities = {
		full_punch_interval = 1.25,
		max_drop_level = 3,
		damage_groups = { fleshy = 9 },
		punch_attack_uses = 66,
	},
	on_place = make_stripped_trunk,
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_deepslate:deepslate_cobbled",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		axey = { speed = deepslate.speed, level = deepslate.level, uses = deepslate.uses }
	},
	vl_max_ench_lvl = 2,
})

------------------ weapons

minetest.register_tool("vl_deepslate_tools:sword_deepslate", {
	description = S("Deepslate Sword"),
	_doc_items_longdesc = sword_longdesc,
	inventory_image = "vl_deepslate_tools_deepslatesword.png",
	wield_scale = wield_scale,
	groups = { weapon = 1, sword = 1, dig_speed_class = 3, enchantability = 5 },
	tool_capabilities = {
		full_punch_interval = 0.625,
		max_drop_level = 3,
		damage_groups = { fleshy = 5 },
		punch_attack_uses = 132,
	},
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_deepslate:deepslate_cobbled",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		swordy = { speed = deepslate.speed, level = deepslate.level, uses = deepslate.uses },
		swordy_cobweb = { speed = deepslate.speed, level = deepslate.level, uses = deepslate.uses }
	},
	vl_max_ench_lvl = 2,
})

core.register_tool("vl_deepslate_tools:hammer_deepslate", {
	description = S("Deepslate Hammer"),
	_tt_help = hammer_tt,
	_doc_items_longdesc = hammer_longdesc,
	_doc_items_usagehelp = hammer_use,
	inventory_image = "vl_deepslate_tools_deepslatehammer.png",
	wield_scale = wield_scale,
	groups = { weapon = 1, hammer = 1, dig_speed_class = 2, enchantability = 5 },
	tool_capabilities = {
		full_punch_interval = 1.3,
		max_drop_level = 3,
		damage_groups = { fleshy = 5.25 },
		punch_attack_uses = deepslate.uses,
	},
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_deepslate:deepslate_cobbled",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		pickaxey = { speed = deepslate.hammerspeed, level = deepslate.level, uses = deepslate.uses },
		shovely = { speed = deepslate.hammerspeed, level = deepslate.level, uses = deepslate.uses }
	},
	vl_max_ench_lvl = 2,
})

core.register_tool("vl_deepslate_tools:spear_deepslate", {
	description = S("Deepslate Spear"),
	_tt_help = spear_tt,
	_doc_items_longdesc = spear_longdesc,
	_doc_items_usagehelp = spear_use,
	inventory_image = "vl_deepslate_tools_deepslatespear.png",
	wield_scale = wield_scale,
	on_place = spear_on_place,
	on_secondary_use = spear_on_place,
	groups = { weapon = 1, weapon_ranged = 1, spear = 1, dig_speed_class = 2, enchantability = 5 },
	range = SPEAR_RANGE,
	tool_capabilities = {
		full_punch_interval = 0.75,
		max_drop_level = 3,
		damage_groups = { fleshy = 4.25 },
		punch_attack_uses = deepslate.uses,
	},
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_deepslate:deepslate_cobbled",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		swordy = { speed = deepslate.spearspeed, level = deepslate.spearlevel, uses = deepslate.uses },
		swordy_cobweb = { speed = deepslate.spearspeed, level = deepslate.spearlevel, uses = deepslate.uses }
	},
	touch_interaction = "short_dig_long_place",
	_mcl_spear_thrown_damage = 6,
	vl_max_ench_lvl = 2,
})


local pr = PcgRandom(1234)
core.register_on_craft(function(itemstack, player, old_craft_grid, craft_inv)
	if string.sub(itemstack:get_name(), 1, 18) ~= "vl_deepslate_tools"
			or mcl_enchanting.is_enchanted(itemstack:get_name())
			or math.random(1, 2) == 1 then
		return
	end
	local enchantment = mcl_enchanting.get_random_enchantment(itemstack, false, true, {}, pr)
	mcl_enchanting.enchant(itemstack, enchantment, 1)
	tt.reload_itemstack_description(itemstack)
end)
