# VoxeLibre
Um jogo não oficial no estilo de Minecraft para o Luanti. Derivado de MineClone, criado por davedevilis. Desenvolvido por diversas pessoas. Não desenvolvido ou patrocinado pela Mojang AB.

### Jogabilidade
Você começa em um mundo gerado aleatoriamente, feito inteiramente de cubos. Você pode explorar o mundo, minerar e construir praticamente qualquer bloco para criar novas estruturas. Você pode escolher jogar no "modo sobrevivência", onde precisa lutar contra monstros e a fome para sobreviver e progredir lentamente em vários aspectos do jogo, como mineração, agricultura, construção de mecanismos e assim por diante. Ou pode jogar no "modo criativo", onde você pode construir quase tudo instantaneamente.

### Resumo da Jogabilidade
* Jogabilidade sandbox, sem objetivo
* Sobrevivência: Lute contra monstros hostis e a fome
* Minere materiais e outros tesouros
* Magia: Ganhe experiência e encante suas ferramentas
* Use os blocos que você coletou para criar construções grandiosas, o único limite sendo sua imaginação
* Colete flores (e outros recursos de coloração) e dê cor ao seu mundo
* Encontre sementes e comece a plantar
* Encontre ou crie um dos centenas de itens
* Construa máquinas complexas com circuitos de redstone
* No modo criativo, você pode construir quase tudo de graça e sem limites.

## Como Jogar (Início Rápido)
### Primeiros Passos
* Bata em um tronco de árvore para o quebrar e coletar a madeira.
* Coloque a madeira na grade 2x2 (sua "grade de criação" no seu inventário) e crie 4 tábuas de madeira.
* Coloque as 4 tábuas de madeira em um formato 2x2 na grade de criação para construir uma bancada de trabalho.
* Clique com o botão direito na bancada para usar uma grade 3x3 e construir itens mais complexos.
* Use o guia de criação (ícone de livro) para aprender todas as receitas possíveis.
* Crie uma picareta de madeira para minerar pedra.
* Ferramentas diferentes quebram diferentes tipos de blocos. Experimente todas!

Continue jogando como quiser. Se divirta!

### Cultivo
* Encontre sementes
* Construa uma enxada
* Clique com o botão direito do mouse na terra ou em um bloco similar com a enxada para a tornar cultivável
* Coloque as sementes no solo arado e observe-as crescer
* Colha as plantas quando estiverem totalmente maduras
* Se estiver perto de água, o solo arado fica úmido e acelera a maturação

### Fornalha
* Construa uma fornalha
* A fornalha permite que você crie mais itens
* O espaço superior deve conter um item que possa ser fundido (por exemplo, minério de ferro)
* O espaço inferior deve conter um combustível (por exemplo, carvão)
* Leia as dicas no guia de criação para saber mais sobre combustíveis e itens que podem ser fundidos.

### Ajuda Adicional
Mais ajuda sobre jogabilidade, blocos, itens e muito mais pode ser encontrada dentro do jogo. Você pode acessar a ajuda no menu do seu inventário.

### Itens Especiais
Os seguintes itens são interessantes para o Modo Criativo e para construtores de mapas de aventura. Eles não podem ser obtidos no jogo ou no inventário do Modo Criativo.

* Barreira: `mcl_core:barrier`

Use o comando /giveme para os obter. Veja a ajuda no jogo para obter mais informações.

## Instalação
Para executar o jogo com o melhor desempenho e suporte, recomendamos a versão estável mais recente do Luanti, mas sempre nos esforçamos para oferecer suporte a uma versão anterior à versão estável mais recente. Portanto, instale o Luanti primeiro. Somente versões estáveis do Luanti são oficialmente suportadas. Executar o VoxeLibre em versões de desenvolvedor do Luanti não é compatível.

Para instalar o VoxeLibre (se você ainda não o fez), mova esta pasta para a pasta "games" na sua pasta de dados do Luanti. Consulte o wiki do Luanti para obter mais informações.

## Links úteis
O repositório do VoxeLibre está no Mesehub. Para contribuir ou relatar problemas, acesse.

* Mesehub: <https://git.minetest.land/VoxeLibre/VoxeLibre>
* Discord: <https://discord.gg/xE4z8EEpDC>
* YouTube: <https://www.youtube.com/channel/UClI_YcsXMF3KNeJtoBfnk9A>
* ContentDB: <https://content.luanti.org/packages/wuzzy/mineclone2/>
* OpenCollective: <https://opencollective.com/voxelibre>
* Mastodon: <https://fosstodon.org/@VoxeLibre>
* Lemmy: <https://lemm.ee/c/voxelibre>
* Matrix space: <https://app.element.io/#/room/#voxelibre:matrix.org>
* Fóruns do Luanti: <https://forum.luanti.org/viewtopic.php?f=50&t=16407>
* Reddit: <https://www.reddit.com/r/VoxeLibre/>
* IRC (quase sem uso): <https://web.libera.chat/#mineclone2>

## Objetivos
Criar um jogo baseado em Minecraft, construído com o motor de jogo Luanti,
que seja gratuito, estável e modificável, com recursos aprimorados e utilizável
tanto no modo single-player quanto no multiplayer. Atualmente, muitos recursos
da versão Java do Minecraft já foram implementados, e aprimorar os recursos
existentes é uma prioridade em relação à adição de novos recursos.

Implementar recursos incluídos na versão atual do Minecraft + OptiFine
(OptiFine somente se compatível com o motor de jogo Luanti).

Criar uma experiência com desempenho otimizado que rode relativamente bem em computadores de baixo desempenho.

## Status de Desenvolvimento
Este jogo está atualmente em **beta**.
É jogável, mas ainda não está completo em termos de recursos. A compatibilidade com versões anteriores do Luanti não é garantida.
Atualizar seu mundo pode causar pequenos bugs.
Se você deseja usar as versões de desenvolvimento do VoxeLibre em produção, a branch master geralmente é relativamente estável.

Os seguintes recursos principais estão disponíveis:

* Ferramentas e armas
* Armaduras
* Sistema de criação: grade 2x2, bancada (grade 3x3), fornalha e guia de criação
* Baús, baús grandes, baús do End, caixas de shulker
* Fornalhas, funis
* Fome
* A maioria dos monstros e animais
* Todos os minerais do Minecraft
* A maioria dos blocos do mundo normal
* Água e lava
* Clima
* 28 biomas + 5 biomas do Nether
* O Nether, um mundo subterrâneo ardente em outra dimensão
* Circuitos de redstone (parcial)
* Carrinhos de mina (parcial)
* Efeitos de status (parcial)
* Experiência
* Encantamento
* Alquimia, poções, flechas imbuídas (parcial)
* Barcos
* Fogo
* Blocos de construção: escadas, lajes, portas, alçapões, cercas, portões (cerca), paredes
* Relógio
* Bússola
* Esponja
* Bloco de slime
* Plantas pequenas e mudas
* Tinturaria
* Bandeiras
* Blocos decorativos: vidro, vitral, painéis de vidro Terracota (e tintas), cabeças e muito mais
* Molduras
* Jukeboxes
* Camas
* Menu de inventário
* Inventário do Modo Criativo
* Agricultura
* Livros para escrever
* Comandos
* Vilas
* O Fim
* E muito mais!

Os seguintes recursos estão incompletos:

* Alguns monstros e animais
* Itens relacionados a Redstone
* Alguns carrinhos de mina especiais (carrinhos de mina com funil e baú funcionam)
* Alguns blocos e itens não triviais

Recursos bônus (não incluídos no Minecraft):

* Guia de criação incluso, mostrando receitas de criação e ferreiro
* Sistema de ajuda no jogo contendo informações extensas sobre o básico da jogabilidade, blocos, itens e muito mais
* Receitas de criação temporárias. Elas existem apenas para disponibilizar itens que seriam inacessíveis de outra forma quando você não estiver no Modo Criativo. Essas receitas serão removidas conforme o desenvolvimento progride e mais recursos são implementados.
* Totalmente modificável (graças à poderosa API Lua do Luanti)
* Novos blocos e itens:
	* Ferramenta de Informações, mostra informações sobre o que você encontra
	* Mais lajes e escadas
	* Portão de Tijolos do Nether
	* Cerca de Tijolos do Nether Vermelhos
	* Portão de Tijolos do Nether Vermelhos
* Estruturas de Substituição - Essas pequenas variações de estruturas do Minecraft servem como substitutas até que tenhamos estruturas maiores funcionando:
	* Cabana na Floresta (Vila)
	* Posto Avançado do Nether (Fortaleza)

Diferenças técnicas em relação ao Minecraft:
* Limite de altura de aproximadamente 31.000 blocos (muito maior que no Minecraft)
* Limite horizontal do mundo de aproximadamente 62.000 x 62.000 blocos (muito menor que no Minecraft, mas ainda muito grande)
* Ainda muito incompleto e com bugs
* Blocos, itens, inimigos e outros recursos estão faltando
* Alguns itens têm nomes ligeiramente diferentes para facilitar a distinção
* Música diferente na jukebox
* Texturas diferentes (Pixel Perfection)
* Sons diferentes (várias fontes)
* Motor de jogo diferente (Luanti)
* Easter eggs diferentes

… e, finalmente, VoxeLibre é software livre!

## Outros arquivos readme
* `LICENSE.txt`: O texto da licença GPLv3
* `CONTRIBUTING.md`: Informações para colaboradores
* `API.md`: Para modders de Luanti que desejam modificar este jogo
* `LEGAL.md`: Informações legais
* `CREDITS.md`: Lista de colaboradores
