# Developer information

This file explains information to document the code of Repixture and information for people
wanting to develop or mod Repixture.

Note the focus of Repixture is not to be a "base for modding", but to be a standalone
game in its own right. That having said, Repixture also doesn't actively oppose
modding.

## Core development

### Testing

There are some hidden testing/debug settings. Add them into `minetest.conf` to activate:

* `rp_testing_enable=true`: Enables Testing Mode. Performs some simple benchmarks on startup
  (See the log file / console) and also enables testing the validity of crafting
  recipes, gold trades, and more (printing errors if any errors were found).
  This also enables a few helper chat commands (see `/help`).
* `hunger_debug=true`: Enables Hunger Debug. This displays the internal hunger values on
  the screen.

## Some modding rules

* Crafting recipes (except cooking and fuel recipes) **MUST**
  be registered through `rp_crafting`.
* Modifying player physics (like running speed)
  **MUST** be done via `rp_player_effects`.

## Mod APIs

Some mods provide APIs to interact with. Check out the respective mod directories for a
file named `API.md`.

Mods with documented APIs:

* `rp_achievements`: Add and trigger achievements
* `rp_bed`: Get, set and unset (re)spwan position
* `rp_crafting`: Add crafting recipes
* `rp_default`: Sapling helpers, biome information
* `rp_door`: Add doors
* `rp_hunger`: Get and set hunger
* `rp_player_effects`: Add player effects (required if you want to modify player physics)
* `tt`: Custom tooltips

Beware: Calling functions that are not documented are NOT guaranted to be stable
in future versions, so use them with care.

## Groups

A reference of all groups used in this game can be found in `DEV_GROUPS.md`.
