local S = minetest.get_translator("rp_commands")

local mod_death_messages = minetest.get_modpath("rp_death_messages") ~= nil

minetest.register_chatcommand("hp", {
	privs = {server=true},
	--~ command syntax for /hp command. Translate the words, but the symbols MUST be left intact
	params = S("[<player>] <value>"),
	description = S("Set health points of player or yourself"),
	func = function(name, param)
		if minetest.settings:get_bool("enable_damage") == false then
			return false, S("Not possible, damage is disabled.")
		end
		if param == "" then
			return false
		end
		local targetname, hp = string.match(param, "(%S+) (%S+)")
		if not targetname then
			hp = param
			targetname = name
		end
		local target = minetest.get_player_by_name(targetname)
		if target == nil or not target:is_player() then
			return false, S("Player @1 does not exist.", targetname)
		end
		hp = minetest.parse_relative_number(hp, target:get_hp())
		if not hp then
			return false, S("Invalid health!")
		end
		if hp < 0 then
			hp = 0
		end
		local hp_max = target:get_properties().hp_max
		if hp > hp_max then
			hp = hp_max
		end
		if not hp then
			return false, S("Invalid health!")
		end

		target:set_hp(hp, { type = "set_hp", from = "mod", custom_type = "rp_commands:hp_command" })
		return true
	end,
})

if mod_death_messages then
	rp_death_messages.register_custom_hp_change_type("rp_commands:hp_command", S("You were killed by a higher power."))
end

