--[[
		Minetest-mod "Infinite Food Pouch", Adds a pouch of food which can be eaten infinitely often
		Copyright (C) 2022 J. A. Anders

		This program is free software; you can redistribute it and/or modify
		it under the terms of the GNU General Public License as published by
		the Free Software Foundation; version 3 of the License.

		This program is distributed in the hope that it will be useful,
		but WITHOUT ANY WARRANTY; without even the implied warranty of
		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
		GNU General Public License for more details.

		You should have received a copy of the GNU General Public License
		along with this program; if not, write to the Free Software
		Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
		MA 02110-1301, USA.
]]

--
-- Mod Version 0.1
--

infinite_food = {}

-- Get Translator
local S = minetest.get_translator("infinite_food")
infinite_food.get_translator = S
local S = infinite_food.get_translator


minetest.register_craftitem("infinite_food:pouch", {
  description = "Pouch of infinite food\nCan be eaten infinitely often",
  inventory_image = "infinite_food_pouch.png",
  on_use = minetest.item_eat(5, "infinite_food:pouch")
})


-- Crafting

if minetest.get_modpath("farming") then
  minetest.register_craft({
    type = "shaped",
    output = "infinite_food:pouch",
    recipe = {
      {"farming:straw","farming:straw","farming:straw"},
      {"group:wool","farming:straw","farming:straw"},
      {"group:wool","group:wool","group:wool"},
    }
  })
end