--[[
		Minetest-mod "Roadway", Adds simple roads to MT
		Copyright (C) 2021 J. A. Anders

		This program is free software; you can redistribute it and/or modify
		it under the terms of the GNU General Public License as published by
		the Free Software Foundation; version 3 of the License.

		This program is distributed in the hope that it will be useful,
		but WITHOUT ANY WARRANTY; without even the implied warranty of
		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
		GNU General Public License for more details.

		You should have received a copy of the GNU General Public License
		along with this program; if not, write to the Free Software
		Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
		MA 02110-1301, USA.
]]


--
-- Mod Version 0.1
--

roadway = {}

-- Get Translator
local S = minetest.get_translator("roadway")
roadway.get_translator = S
local S = roadway.get_translator


-- High of the Roads(1/4-, 1/2- and 3/4-Node)
local road_fixed_1 = { -8/16, -8/16, -8/16, 8/16, -4/16, 8/16}
local road_fixed_2 = { -8/16, -8/16, -8/16, 8/16, 0/16, 8/16}
local road_fixed_3 = { -8/16, -8/16, -8/16, 8/16, 4/16, 8/16}


-- The Road Nodes

minetest.register_node("roadway:road", {
  description = S("Road"),
  inventory_image = minetest.inventorycube("roadway_road.png"),
  tiles = {"roadway_road.png"},
  groups = {stone=1, cracky=1},
})

minetest.register_node("roadway:road_1", {
  description = S("Road 1/4"),
  tiles = {"roadway_road.png"},
  drawtype = "nodebox", -- All roads dont have 'inventory_image' that
  selection_box = {     -- the 'tiles' will be used for that
		type = "fixed",
		fixed = road_fixed_1
	},
	node_box = {
		type = "fixed",
		fixed = road_fixed_1
	},
  groups = {stone=1, cracky=1},
  paramtype = "light",
})

minetest.register_node("roadway:road_2", {
  description = S("Road 1/2"),
  tiles = {"roadway_road.png"},
  drawtype = "nodebox",
  selection_box = {
		type = "fixed",
		fixed = road_fixed_2
	},
	node_box = {
		type = "fixed",
		fixed = road_fixed_2
	},
  groups = {stone=1, cracky=1},
  paramtype = "light",
})


minetest.register_node("roadway:road_3", {
  description = S("Road 3/4"),
  tiles = {"roadway_road.png"},
  drawtype = "nodebox",
  selection_box = {
		type = "fixed",
		fixed = road_fixed_3
	},
	node_box = {
		type = "fixed",
		fixed = road_fixed_3
	},
  groups = {stone=1, cracky=1},
  paramtype = "light",
})

-- Tar to craft the roads

minetest.register_craftitem("roadway:tar_bio", {
  description = S("Biologic Tar"),
  inventory_image = "bucket.png^roadway_tar_bio.png",
  groups = {tar=1},
})

minetest.register_craftitem("roadway:tar_coal", {
  description = S("Coal Tar"),
  inventory_image = "bucket.png^roadway_tar_coal.png",
  groups = {tar=1},
})

-- Craft tar

minetest.register_craft({
  type = "shapeless",
  output = "roadway:tar_bio 5",
  recipe = {
    "group:flora",
    "group:flora",
    "group:flora",
    "bucket:bucket_empty",
  },
})

minetest.register_craft({
  type = "shapeless",
  output = "roadway:tar_coal 10",
  recipe = {
    "default:coal_lump",
    "default:coal_block",
    "default:coal_lump",
    "bucket:bucket_empty",
  },
})

-- Only when charcoal is used too

if minetest.get_modpath("charcoal") then
  minetest.register_craft({
    type = "shapeless",
    output = "roadway:tar_coal 10",
    recipe = {
      "charcoal:charcoal",
      "charcoal:charcoal_block",
      "charcoal:charcoal",
    },
  })
end


-- Craft roads

minetest.register_craft({
  type = "shaped",
  output = "roadway:road 2",
  recipe = {
    {"group:tar"},
    {"default:sand"},
    {"default:gravel"},
  },
  replacements = {{"group:tar", "bucket:bucket_empty"}},
})

minetest.register_craft({
  type = "shaped",
  output = "roadway:road_2 2",
  recipe = {
    {"roadway:road"},
  },
})

minetest.register_craft({
  type = "shapeless",
  output = "roadway:road_3",
  recipe = {
    "roadway:road_2",
    "roadway:road_1",
  },
})

minetest.register_craft({
  type = "shapeless",
  output = "roadway:road_2",
  recipe = {
    "roadway:road_1",
    "roadway:road_1",
  },
})

minetest.register_craft({
  type = "shapeless",
  output = "roadway:road_1 2",
  recipe = {
    "roadway:road_2",
  },
})

minetest.register_craft({
  type = "shapeless",
  output = "roadway:road_1 3",
  recipe = {
    "roadway:road_3",
  },
})

minetest.register_craft({
  type = "shapeless",
  output = "roadway:road",
  recipe = {
    "roadway:road_3",
    "roadway:road_1",
  },
})

minetest.register_craft({
  type = "shapeless",
  output = "roadway:road",
  recipe = {
    "roadway:road_2",
    "roadway:road_2",
  },
})

minetest.register_craft({
  type = "shapeless",
  output = "roadway:road",
  recipe = {
    "roadway:road_1",
    "roadway:road_1",
    "roadway:road_1",
    "roadway:road_1",
  },
})