local modname = core.get_current_modname()
local modpath = core.get_modpath(modname)
local S = core.get_translator(modname)

-- Init
minetest.register_craftitem("cvl_bleach:salt", {
	description = S("Salt"),
	_doc_items_longdesc = S("Salt comes from bucket of water."),
	inventory_image = "salt.png",
	stack_max = 64,
	groups = { craftitem = 1, brewitem=1 },
})

minetest.register_craftitem("cvl_bleach:bleach", {
	description = S("Bleach"),
	_doc_items_longdesc = S("Discolor wool blocks."),
	inventory_image = "bleach.png",
    stack_max = 16,
    groups = { craftitem = 1, brewitem=1 },
})

-- Craft
minetest.register_craft({
	type = "cooking",
	output = "cvl_bleach:salt 16",
	recipe = "mcl_buckets:bucket_water",
	cooktime = 10,
	replacements = {
		{"mcl_buckets:bucket_water", "mcl_buckets:bucket_empty"},
	}
})

minetest.register_craft({
	output = "cvl_bleach:bleach",
	recipe = {
		{"cvl_bleach:salt", "cvl_bleach:salt", "cvl_bleach:salt"},
		{"cvl_bleach:salt", "mcl_potions:water", "cvl_bleach:salt"},
		{"cvl_bleach:salt", "cvl_bleach:salt", "cvl_bleach:salt"},
	}
})

dofile(modpath.."/discolor.lua")