local modname = minetest.get_current_modname()
local modpath = minetest.get_modpath(modname)
local S = minetest.get_translator(modname)

-- Picks
minetest.register_tool("cat_voxelibre_tools:pick_granite_smooth", {
	description = S("Polished Granite Pickaxe"),
	_doc_items_longdesc = pickaxe_longdesc,
	inventory_image = "default_tool_granitepick.png",
	wield_scale = wield_scale,
	groups = { tool=1, pickaxe=1, dig_speed_class=4, enchantability=10 },
	tool_capabilities = {
		-- 1/1.2
		full_punch_interval = 0.83333333,
		max_drop_level=3,
		damage_groups = {fleshy=3},
		punch_attack_uses = 99,
	},
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_core:granite_smooth",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		pickaxey = { speed = 5, level = 3, uses = 198 }
	},
})

minetest.register_tool("cat_voxelibre_tools:pick_andesite_smooth", {
	description = S("Polished Andesite Pickaxe"),
	_doc_items_longdesc = pickaxe_longdesc,
	inventory_image = "default_tool_andesitepick.png",
	wield_scale = wield_scale,
	groups = { tool=1, pickaxe=1, dig_speed_class=4, enchantability=10 },
	tool_capabilities = {
		-- 1/1.2
		full_punch_interval = 0.83333333,
		max_drop_level=3,
		damage_groups = {fleshy=3},
		punch_attack_uses = 99,
	},
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_core:andesite_smooth",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		pickaxey = { speed = 5, level = 3, uses = 198 }
	},
})

minetest.register_tool("cat_voxelibre_tools:pick_diorite_smooth", {
	description = S("Polished Diorite Pickaxe"),
	_doc_items_longdesc = pickaxe_longdesc,
	inventory_image = "default_tool_dioritepick.png",
	wield_scale = wield_scale,
	groups = { tool=1, pickaxe=1, dig_speed_class=4, enchantability=10 },
	tool_capabilities = {
		-- 1/1.2
		full_punch_interval = 0.83333333,
		max_drop_level=3,
		damage_groups = {fleshy=3},
		punch_attack_uses = 99,
	},
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_core:diorite_smooth",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		pickaxey = { speed = 5, level = 3, uses = 198 }
	},
})

local make_grass_path = function(itemstack, placer, pointed_thing)
	-- Use pointed node's on_rightclick function first, if present
	local node = minetest.get_node(pointed_thing.under)
	if placer and not placer:get_player_control().sneak then
		if minetest.registered_nodes[node.name] and minetest.registered_nodes[node.name].on_rightclick then
			return minetest.registered_nodes[node.name].on_rightclick(pointed_thing.under, node, placer, itemstack) or itemstack
		end
	end

	-- Only make or remove grass path if tool used on side or top of target node
	if pointed_thing.above.y < pointed_thing.under.y then
		return itemstack
	end

-- Remove grass paths
	if (minetest.get_item_group(node.name, "path_remove_possible") == 1) and placer:get_player_control().sneak then
		local above = table.copy(pointed_thing.under)
		above.y = above.y + 1
		if minetest.get_node(above).name == "air" then
			if minetest.is_protected(pointed_thing.under, placer:get_player_name()) then
				minetest.record_protection_violation(pointed_thing.under, placer:get_player_name())
				return itemstack
			end

			if not minetest.is_creative_enabled(placer:get_player_name()) then
				-- Add wear (as if digging a shovely node)
				local toolname = itemstack:get_name()
				local wear = mcl_autogroup.get_wear(toolname, "shovely")
				if wear then
					itemstack:add_wear(wear)
					tt.reload_itemstack_description(itemstack) -- update tooltip
				end
			end
			minetest.sound_play({name="default_grass_footstep", gain=1}, {pos = above, max_hear_distance = 16}, true)
			minetest.swap_node(pointed_thing.under, {name="mcl_core:dirt"})
		end
	end

-- Make grass paths
	if (minetest.get_item_group(node.name, "path_creation_possible") == 1) and not placer:get_player_control().sneak then
		local above = table.copy(pointed_thing.under)
		above.y = above.y + 1
		if minetest.get_node(above).name == "air" then
			if minetest.is_protected(pointed_thing.under, placer:get_player_name()) then
				minetest.record_protection_violation(pointed_thing.under, placer:get_player_name())
				return itemstack
			end

			if not minetest.is_creative_enabled(placer:get_player_name()) then
				-- Add wear (as if digging a shovely node)
				local toolname = itemstack:get_name()
				local wear = mcl_autogroup.get_wear(toolname, "shovely")
				if wear then
					itemstack:add_wear(wear)
					tt.reload_itemstack_description(itemstack) -- update tooltip
				end
			end
			minetest.sound_play({name="default_grass_footstep", gain=1}, {pos = above, max_hear_distance = 16}, true)
			minetest.swap_node(pointed_thing.under, {name="mcl_core:grass_path"})
		end
	end
	return itemstack
end

-- Shovels
minetest.register_tool("cat_voxelibre_tools:shovel_granite_smooth", {
	description = S("Polished Granite Shovel"),
	_doc_items_longdesc = shovel_longdesc,
	_doc_items_usagehelp = shovel_use,
	inventory_image = "default_tool_graniteshovel.png",
	wield_scale = wield_scale,
	groups = { tool=1, shovel=1, dig_speed_class=4, enchantability=10 },
	tool_capabilities = {
		full_punch_interval = 1,
		max_drop_level=3,
		damage_groups = {fleshy=3},
		punch_attack_uses = 99,
	},
	on_place = make_grass_path,
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_core:granite_smooth",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		shovely = { speed = 5, level = 3, uses = 198 }
	},
})

minetest.register_tool("cat_voxelibre_tools:shovel_andesite_smooth", {
	description = S("Polished Andesite Shovel"),
	_doc_items_longdesc = shovel_longdesc,
	_doc_items_usagehelp = shovel_use,
	inventory_image = "default_tool_andesiteshovel.png",
	wield_scale = wield_scale,
	groups = { tool=1, shovel=1, dig_speed_class=4, enchantability=10 },
	tool_capabilities = {
		full_punch_interval = 1,
		max_drop_level=3,
		damage_groups = {fleshy=3},
		punch_attack_uses = 99,
	},
	on_place = make_grass_path,
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_core:andesite_smooth",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		shovely = { speed = 5, level = 3, uses = 198 }
	},
})

minetest.register_tool("cat_voxelibre_tools:shovel_diorite_smooth", {
	description = S("Polished Diorite Shovel"),
	_doc_items_longdesc = shovel_longdesc,
	_doc_items_usagehelp = shovel_use,
	inventory_image = "default_tool_dioriteshovel.png",
	wield_scale = wield_scale,
	groups = { tool=1, shovel=1, dig_speed_class=4, enchantability=10 },
	tool_capabilities = {
		full_punch_interval = 1,
		max_drop_level=3,
		damage_groups = {fleshy=3},
		punch_attack_uses = 99,
	},
	on_place = make_grass_path,
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_core:diorite_smooth",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		shovely = { speed = 5, level = 3, uses = 198 }
	},
})

-- Axes
local function make_stripped_trunk(itemstack, placer, pointed_thing)
    if pointed_thing.type ~= "node" then return end

    local node = minetest.get_node(pointed_thing.under)
    local node_name = minetest.get_node(pointed_thing.under).name

    local noddef = minetest.registered_nodes[node_name]

    if not noddef then
        minetest.log("warning", "Trying to right click with an axe the unregistered node: " .. tostring(node_name))
        return
    end

    if not placer:get_player_control().sneak and noddef.on_rightclick then
        return minetest.item_place(itemstack, placer, pointed_thing)
    end
    if minetest.is_protected(pointed_thing.under, placer:get_player_name()) then
        minetest.record_protection_violation(pointed_thing.under, placer:get_player_name())
        return itemstack
    end

    if noddef._mcl_stripped_variant == nil then
		return itemstack
	else
		minetest.swap_node(pointed_thing.under, {name=noddef._mcl_stripped_variant, param2=node.param2})
		if minetest.get_item_group(node_name, "waxed") ~= 0 then
			awards.unlock(placer:get_player_name(), "mcl:wax_off")
		end
		if not minetest.is_creative_enabled(placer:get_player_name()) then
			-- Add wear (as if digging a axey node)
			local toolname = itemstack:get_name()
			local wear = mcl_autogroup.get_wear(toolname, "axey")
			if wear then
				itemstack:add_wear(wear)
				tt.reload_itemstack_description(itemstack) -- update tooltip
			end
		end
	end
    return itemstack
end

minetest.register_tool("cat_voxelibre_tools:axe_granite_smooth", {
	description = S("Polished Granite Axe"),
	_doc_items_longdesc = axe_longdesc,
	inventory_image = "default_tool_graniteaxe.png",
	wield_scale = wield_scale,
	groups = { tool=1, axe=1, dig_speed_class=4, enchantability=10 },
	tool_capabilities = {
		full_punch_interval = 1.25,
		max_drop_level=3,
		damage_groups = {fleshy=9},
		punch_attack_uses = 99,
	},
	on_place = make_stripped_trunk,
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_core:granite_smooth",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		axey = { speed = 5, level = 3, uses = 198 }
	},
})

minetest.register_tool("cat_voxelibre_tools:axe_andesite_smooth", {
	description = S("Polished Andesite Axe"),
	_doc_items_longdesc = axe_longdesc,
	inventory_image = "default_tool_andesiteaxe.png",
	wield_scale = wield_scale,
	groups = { tool=1, axe=1, dig_speed_class=4, enchantability=10 },
	tool_capabilities = {
		full_punch_interval = 1.25,
		max_drop_level=3,
		damage_groups = {fleshy=9},
		punch_attack_uses = 99,
	},
	on_place = make_stripped_trunk,
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_core:andesite_smooth",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		axey = { speed = 5, level = 3, uses = 198 }
	},
})

minetest.register_tool("cat_voxelibre_tools:axe_diorite_smooth", {
	description = S("Polished Diorite Axe"),
	_doc_items_longdesc = axe_longdesc,
	inventory_image = "default_tool_dioriteaxe.png",
	wield_scale = wield_scale,
	groups = { tool=1, axe=1, dig_speed_class=4, enchantability=10 },
	tool_capabilities = {
		full_punch_interval = 1.25,
		max_drop_level=3,
		damage_groups = {fleshy=9},
		punch_attack_uses = 99,
	},
	on_place = make_stripped_trunk,
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_core:diorite_smooth",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		axey = { speed = 5, level = 3, uses = 198 }
	},
})

-- Swords
minetest.register_tool("cat_voxelibre_tools:sword_granite_smooth", {
	description = S("Polished Granite Sword"),
	_doc_items_longdesc = sword_longdesc,
	inventory_image = "default_tool_granitesword.png",
	wield_scale = wield_scale,
	groups = { weapon=1, sword=1, dig_speed_class=4, enchantability=10 },
	tool_capabilities = {
		full_punch_interval = 0.625,
		max_drop_level=3,
		damage_groups = {fleshy=5},
		punch_attack_uses = 198,
	},
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_core:granite_smooth",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		swordy = { speed = 5, level = 3, uses = 198 },
		swordy_cobweb = { speed = 5, level = 3, uses = 198 }
	},
})

minetest.register_tool("cat_voxelibre_tools:sword_andesite_smooth", {
	description = S("Polished Andesite Sword"),
	_doc_items_longdesc = sword_longdesc,
	inventory_image = "default_tool_andesitesword.png",
	wield_scale = wield_scale,
	groups = { weapon=1, sword=1, dig_speed_class=4, enchantability=10 },
	tool_capabilities = {
		full_punch_interval = 0.625,
		max_drop_level=3,
		damage_groups = {fleshy=5},
		punch_attack_uses = 198,
	},
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_core:andesite_smooth",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		swordy = { speed = 5, level = 3, uses = 198 },
		swordy_cobweb = { speed = 5, level = 3, uses = 198 }
	},
})

minetest.register_tool("cat_voxelibre_tools:sword_diorite_smooth", {
	description = S("Polished Diorite Sword"),
	_doc_items_longdesc = sword_longdesc,
	inventory_image = "default_tool_dioritesword.png",
	wield_scale = wield_scale,
	groups = { weapon=1, sword=1, dig_speed_class=4, enchantability=10 },
	tool_capabilities = {
		full_punch_interval = 0.625,
		max_drop_level=3,
		damage_groups = {fleshy=5},
		punch_attack_uses = 198,
	},
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_core:diorite_smooth",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		swordy = { speed = 5, level = 3, uses = 198 },
		swordy_cobweb = { speed = 5, level = 3, uses = 198 }
	},
})

dofile(modpath.."/crafting.lua")
dofile(modpath.."/aliases.lua")
