local modname = core.get_current_modname()
local modpath = core.get_modpath(modname)
local S = core.get_translator(modname)


local function merge_tables(table_to, table_from)
	for k, v in pairs(table_from) do
		table_to[k] = v
	end
end



-- Picks
local stone_pick_definition = core.registered_tools["mcl_tools:pick_stone"]

local dirt_pick_definition = table.copy(stone_pick_definition)
merge_tables(dirt_pick_definition, {
	description = S("Dirt Pickaxe"),
	_doc_items_hidden = false,
	inventory_image = "default_tool_dirtpick.png",
	groups = { tool=1, pickaxe=1, dig_speed_class=1, enchantability=10 },
	tool_capabilities = {
		full_punch_interval = 0.83333333,
		max_drop_level=3,
		damage_groups = {fleshy=3},
		punch_attack_uses = 23
	},
	_repair_material = "mcl_core:dirt",
	_mcl_diggroups = {
		pickaxey = { speed = 1, level = 3, uses = 35 }
	}
})

local snow_pick_definition = table.copy(dirt_pick_definition)
merge_tables(snow_pick_definition, {
	description = S("Snow Pickaxe"),
	inventory_image = "default_tool_snowpick.png",
	_repair_material = "mcl_core:snowblock"
})

local granite_smooth_pick_definition = table.copy(stone_pick_definition)
merge_tables(granite_smooth_pick_definition, {
	description = S("Polished Granite Pickaxe"),
	inventory_image = "default_tool_granitepick.png",
	groups = { tool=1, pickaxe=1, dig_speed_class=4, enchantability=10 },
	tool_capabilities = {
		full_punch_interval = 0.83333333,
		max_drop_level=3,
		damage_groups = {fleshy=3},
		punch_attack_uses = 99
	},
	_repair_material = "mcl_core:granite_smooth",
	_mcl_diggroups = {
		pickaxey = { speed = 5, level = 3, uses = 198 }
	}
})

local andesite_smooth_pick_definition = table.copy(granite_smooth_pick_definition)
merge_tables(andesite_smooth_pick_definition, {
	description = S("Polished Andesite Pickaxe"),
	inventory_image = "default_tool_andesitepick.png",
	_repair_material = "mcl_core:andesite_smooth"
})

local diorite_smooth_pick_definition = table.copy(granite_smooth_pick_definition)
merge_tables(diorite_smooth_pick_definition, {
	description = S("Polished Diorite Pickaxe"),
	inventory_image = "default_tool_dioritepick.png",
	_repair_material = "mcl_core:diorite_smooth"
})

local eye_of_ender_pick_definition = table.copy(stone_pick_definition)
merge_tables(eye_of_ender_pick_definition, {
	description = S("Eye Of Ender Pickaxe"),
	inventory_image = "eye_of_ender_pick.png",
	groups = { tool=1, pickaxe=1, dig_speed_class=5, enchantability=10 },
	tool_capabilities = {
		full_punch_interval = 0.83333333,
		max_drop_level=5,
		damage_groups = {fleshy=5},
		punch_attack_uses = 585,
	},
	_repair_material = "mcl_end:ender_eye",
	_mcl_diggroups = {
		pickaxey = { speed = 7, level = 5, uses = 1172 }
	},
})



core.register_tool("cat_voxelibre_tools:pick_dirt", dirt_pick_definition)
core.register_tool("cat_voxelibre_tools:pick_snow", snow_pick_definition)
core.register_tool("cat_voxelibre_tools:pick_granite_smooth", granite_smooth_pick_definition)
core.register_tool("cat_voxelibre_tools:pick_andesite_smooth", andesite_smooth_pick_definition)
core.register_tool("cat_voxelibre_tools:pick_diorite_smooth", diorite_smooth_pick_definition)
core.register_tool("cat_voxelibre_tools:eye_of_ender_pick", eye_of_ender_pick_definition)



-- Shovels
local stone_shovel_definition = core.registered_tools["mcl_tools:shovel_stone"]

local dirt_shovel_definition = table.copy(stone_shovel_definition)
merge_tables(dirt_shovel_definition, {
	description = S("Dirt Shovel"),
	_doc_items_hidden = false,
	inventory_image = "default_tool_dirtshovel.png",
	groups = { tool=1, shovel=1, dig_speed_class=2, enchantability=10 },
	tool_capabilities = {
		full_punch_interval = 1,
		max_drop_level=3,
		damage_groups = {fleshy=3},
		punch_attack_uses = 23
	},
	_repair_material = "mcl_core:dirt",
	_mcl_diggroups = {
		shovely = { speed = 2, level = 3, uses = 35 }
	}
})

local snow_shovel_definition = table.copy(dirt_shovel_definition)
merge_tables(snow_shovel_definition, {
	description = S("Snow Shovel"),
	inventory_image = "default_tool_snowshovel.png",
	_repair_material = "mcl_core:snowblock"
})

local granite_smooth_shovel_definition = table.copy(stone_shovel_definition)
merge_tables(granite_smooth_shovel_definition, {
	description = S("Polished Granite Shovel"),
	inventory_image = "default_tool_graniteshovel.png",
	groups = { tool=1, shovel=1, dig_speed_class=4, enchantability=10 },
	tool_capabilities = {
		full_punch_interval = 1,
		max_drop_level=3,
		damage_groups = {fleshy=3},
		punch_attack_uses = 99
	},
	_repair_material = "mcl_core:granite_smooth",
	_mcl_diggroups = {
		shovely = { speed = 5, level = 3, uses = 198 }
	}
})

local andesite_smooth_shovel_definition = table.copy(granite_smooth_shovel_definition)
merge_tables(andesite_smooth_shovel_definition, {
	description = S("Polished Andesite Shovel"),
	inventory_image = "default_tool_andesiteshovel.png",
	_repair_material = "mcl_core:andesite_smooth"
})

local diorite_smooth_shovel_definition = table.copy(granite_smooth_shovel_definition)
merge_tables(diorite_smooth_shovel_definition, {
	description = S("Polished Diorite Shovel"),
	inventory_image = "default_tool_dioriteshovel.png",
	_repair_material = "mcl_core:diorite_smooth"
})

local granite_smooth_shovel_definition = table.copy(stone_shovel_definition)
merge_tables(granite_smooth_shovel_definition, {
	description = S("Polished Granite Shovel"),
	inventory_image = "default_tool_graniteshovel.png",
	groups = { tool=1, shovel=1, dig_speed_class=4, enchantability=10 },
	tool_capabilities = {
		full_punch_interval = 1,
		max_drop_level=3,
		damage_groups = {fleshy=3},
		punch_attack_uses = 99
	},
	_repair_material = "mcl_core:granite_smooth",
	_mcl_diggroups = {
		shovely = { speed = 5, level = 3, uses = 198 }
	}
})

local eye_of_ender_shovel_definition = table.copy(stone_shovel_definition)
merge_tables(eye_of_ender_shovel_definition, {
	description = S("Eye Of Ender Shovel"),
	inventory_image = "eye_of_ender_shovel.png",
	groups = { tool=1, shovel=1, dig_speed_class=5, enchantability=10 },
	tool_capabilities = {
		full_punch_interval = 1,
		max_drop_level=5,
		damage_groups = {fleshy=5},
		punch_attack_uses = 585,
	},
	_repair_material = "mcl_end:ender_eye",
	_mcl_diggroups = {
		shovely = { speed = 7, level = 5, uses = 1172 }
	},
})

core.register_tool("cat_voxelibre_tools:shovel_dirt", dirt_shovel_definition)
core.register_tool("cat_voxelibre_tools:shovel_snow", snow_shovel_definition)
core.register_tool("cat_voxelibre_tools:shovel_granite_smooth", granite_smooth_shovel_definition)
core.register_tool("cat_voxelibre_tools:shovel_andesite_smooth", andesite_smooth_shovel_definition)
core.register_tool("cat_voxelibre_tools:shovel_diorite_smooth", diorite_smooth_shovel_definition)
core.register_tool("cat_voxelibre_tools:eye_of_ender_shovel", eye_of_ender_shovel_definition)



-- Axes
local stone_axe_definition = core.registered_tools["mcl_tools:axe_stone"]

local dirt_axe_definition = table.copy(stone_axe_definition)
merge_tables(dirt_axe_definition, {
	description = S("Dirt Axe"),
	_doc_items_hidden = false,
	inventory_image = "default_tool_dirtaxe.png",
	groups = { tool=1, axe=1, dig_speed_class=2, enchantability=10 },
	tool_capabilities = {
		full_punch_interval = 1.25,
		max_drop_level=3,
		damage_groups = {fleshy=5},
		punch_attack_uses = 23
	},
	_repair_material = "mcl_core:dirt",
	_mcl_diggroups = {
		axey = { speed = 2, level = 3, uses = 35 }
	}
})

local snow_axe_definition = table.copy(dirt_axe_definition)
merge_tables(snow_axe_definition, {
	description = S("Snow Axe"),
	inventory_image = "default_tool_snowaxe.png",
	_repair_material = "mcl_core:snowblock"
})

local granite_smooth_axe_definition = table.copy(stone_axe_definition)
merge_tables(granite_smooth_axe_definition, {
	description = S("Polished Granite Axe"),
	inventory_image = "default_tool_graniteaxe.png",
	groups = { tool=1, axe=1, dig_speed_class=4, enchantability=10 },
	tool_capabilities = {
		full_punch_interval = 1.25,
		max_drop_level=3,
		damage_groups = {fleshy=9},
		punch_attack_uses = 99
	},
	_repair_material = "mcl_core:granite_smooth",
	_mcl_diggroups = {
		axey = { speed = 5, level = 3, uses = 198 }
	}
})

local andesite_smooth_axe_definition = table.copy(granite_smooth_axe_definition)
merge_tables(andesite_smooth_axe_definition, {
	description = S("Polished Andesite Axe"),
	inventory_image = "default_tool_andesiteaxe.png",
	_repair_material = "mcl_core:andesite_smooth"
})

local diorite_smooth_axe_definition = table.copy(granite_smooth_axe_definition)
merge_tables(diorite_smooth_axe_definition, {
	description = S("Polished Diorite Axe"),
	inventory_image = "default_tool_dioriteaxe.png",
	_repair_material = "mcl_core:diorite_smooth"
})

local eye_of_ender_axe_definition = table.copy(stone_axe_definition)
merge_tables(eye_of_ender_axe_definition, {
	description = S("Eye Of Ender Axe"),
	inventory_image = "eye_of_ender_axe.png",
	groups = { tool=1, axe=1, dig_speed_class=5, enchantability=10 },
	tool_capabilities = {
		full_punch_interval = 1.25,
		max_drop_level=5,
		damage_groups = {fleshy=9},
		punch_attack_uses = 585,
	},
	_repair_material = "mcl_end:ender_eye",
	_mcl_diggroups = {
		axey = { speed = 7, level = 5, uses = 1172 }
	},
})


core.register_tool("cat_voxelibre_tools:axe_dirt", dirt_axe_definition)
core.register_tool("cat_voxelibre_tools:axe_snow", snow_axe_definition)
core.register_tool("cat_voxelibre_tools:axe_granite_smooth", granite_smooth_axe_definition)
core.register_tool("cat_voxelibre_tools:axe_andesite_smooth", andesite_smooth_axe_definition)
core.register_tool("cat_voxelibre_tools:axe_diorite_smooth", diorite_smooth_axe_definition)
core.register_tool("cat_voxelibre_tools:eye_of_ender_axe", eye_of_ender_axe_definition)



-- Swords
local stone_sword_definition = core.registered_tools["mcl_tools:sword_stone"]

local dirt_sword_definition = table.copy(stone_sword_definition)
merge_tables(dirt_sword_definition, {
	description = S("Dirt Sword"),
	_doc_items_hidden = false,
	inventory_image = "default_tool_dirtsword.png",
	groups = { weapon=1, sword=1, dig_speed_class=2, enchantability=10 },
	tool_capabilities = {
		full_punch_interval = 0.625,
		max_drop_level=3,
		damage_groups = {fleshy=4},
		punch_attack_uses = 23
	},
	_repair_material = "mcl_core:dirt",
	_mcl_diggroups = {
		swordy = { speed = 2, level = 3, uses = 35 },
		swordy_cobweb = { speed = 2, level = 3, uses = 35 }
	}
})

local snow_sword_definition = table.copy(dirt_sword_definition)
merge_tables(snow_sword_definition, {
	description = S("Snow Sword"),
	inventory_image = "default_tool_snowsword.png",
	_repair_material = "mcl_core:snowblock"
})

local granite_smooth_sword_definition = table.copy(stone_sword_definition)
merge_tables(granite_smooth_sword_definition, {
	description = S("Polished Granite Sword"),
	inventory_image = "default_tool_granitesword.png",
	groups = { weapon=1, sword=1, dig_speed_class=4, enchantability=10 },
	tool_capabilities = {
		full_punch_interval = 0.625,
		max_drop_level=3,
		damage_groups = {fleshy=5},
		punch_attack_uses = 198
	},
	_repair_material = "mcl_core:granite_smooth",
	_mcl_diggroups = {
		swordy = { speed = 5, level = 3, uses = 198 },
		swordy_cobweb = { speed = 5, level = 3, uses = 198 }
	}
})

local andesite_smooth_sword_definition = table.copy(granite_smooth_sword_definition)
merge_tables(andesite_smooth_sword_definition, {
	description = S("Polished Andesite Sword"),
	inventory_image = "default_tool_andesitesword.png",
	_repair_material = "mcl_core:andesite_smooth"
})

local diorite_smooth_sword_definition = table.copy(granite_smooth_sword_definition)
merge_tables(diorite_smooth_sword_definition, {
	description = S("Polished Diorite Sword"),
	inventory_image = "default_tool_dioritesword.png",
	_repair_material = "mcl_core:diorite_smooth"
})

local eye_of_ender_sword_definition = table.copy(stone_sword_definition)
merge_tables(eye_of_ender_sword_definition, {
	description = S("Eye Of Ender Sword"),
	inventory_image = "eye_of_ender_sword.png",
	groups = { weapon=1, sword=1, dig_speed_class=5, enchantability=10 },
	tool_capabilities = {
		full_punch_interval = 0.625,
		max_drop_level=5,
		damage_groups = {fleshy=9},
		punch_attack_uses = 1523,
	},
	_repair_material = "mcl_end:ender_eye",
	_mcl_diggroups = {
		swordy = { speed = 7, level = 5, uses = 1172 },
		swordy_cobweb = { speed = 7, level = 5, uses = 1172 }
	},
})


core.register_tool("cat_voxelibre_tools:sword_dirt", dirt_sword_definition)
core.register_tool("cat_voxelibre_tools:sword_snow", snow_sword_definition)
core.register_tool("cat_voxelibre_tools:sword_granite_smooth", granite_smooth_sword_definition)
core.register_tool("cat_voxelibre_tools:sword_andesite_smooth", andesite_smooth_sword_definition)
core.register_tool("cat_voxelibre_tools:sword_diorite_smooth", diorite_smooth_sword_definition)
core.register_tool("cat_voxelibre_tools:eye_of_ender_sword", eye_of_ender_sword_definition)



dofile(modpath.."/crafting.lua")
dofile(modpath.."/aliases.lua")
