local modname = core.get_current_modname()
local modpath = core.get_modpath(modname)
local S = core.get_translator(modname)


local function merge_tables(table_to, table_from)
	for k, v in pairs(table_from) do
		table_to[k] = v
	end
end



-- Picks
local stone_pick_definition = core.registered_tools["mcl_tools:pick_stone"]

local dirt_pick_definition = table.copy(stone_pick_definition)
merge_tables(dirt_pick_definition, {
	description = S("Dirt Pickaxe"),
	_doc_items_hidden = false,
	inventory_image = "dirt_pick.png",
	groups = { tool=1, pickaxe=1, dig_speed_class=1, enchantability=10 },
	tool_capabilities = {
		full_punch_interval = 0.83333333,
		max_drop_level=3,
		damage_groups = {fleshy=3},
		punch_attack_uses = 23
	},
	_repair_material = "mcl_core:dirt",
	_mcl_diggroups = {
		pickaxey = { speed = 1, level = 3, uses = 35 }
	}
})

local snow_pick_definition = table.copy(dirt_pick_definition)
merge_tables(snow_pick_definition, {
	description = S("Snow Pickaxe"),
	inventory_image = "snow_pick.png",
	_repair_material = "mcl_core:snowblock"
})

local water_pick_definition = table.copy(dirt_pick_definition)
merge_tables(water_pick_definition, {
	description = S("Water Pickaxe"),
	inventory_image = "water_pick.png",
	_repair_material = "mcl_buckets:bucket_water"
})

local smooth_granite_pick_definition = table.copy(stone_pick_definition)
merge_tables(smooth_granite_pick_definition, {
	description = S("Polished Granite Pickaxe"),
	inventory_image = "granite_pick.png",
	groups = { tool=1, pickaxe=1, dig_speed_class=4, enchantability=10 },
	tool_capabilities = {
		full_punch_interval = 0.83333333,
		max_drop_level=3,
		damage_groups = {fleshy=3},
		punch_attack_uses = 99
	},
	_repair_material = "mcl_core:granite_smooth",
	_mcl_diggroups = {
		pickaxey = { speed = 5, level = 3, uses = 198 }
	}
})

local smooth_andesite_pick_definition = table.copy(smooth_granite_pick_definition)
merge_tables(smooth_andesite_pick_definition, {
	description = S("Polished Andesite Pickaxe"),
	inventory_image = "andesite_pick.png",
	_repair_material = "mcl_core:andesite_smooth"
})

local smooth_diorite_pick_definition = table.copy(smooth_granite_pick_definition)
merge_tables(smooth_diorite_pick_definition, {
	description = S("Polished Diorite Pickaxe"),
	inventory_image = "diorite_pick.png",
	_repair_material = "mcl_core:diorite_smooth"
})

local lava_pick_definition = table.copy(smooth_granite_pick_definition)
merge_tables(lava_pick_definition, {
	description = S("Lava Pickaxe"),
	inventory_image = "lava_pick.png",
	_repair_material = "mcl_buckets:bucket_lava"
})

local eye_of_ender_pick_definition = table.copy(stone_pick_definition)
merge_tables(eye_of_ender_pick_definition, {
	description = S("Eye Of Ender Pickaxe"),
	inventory_image = "eye_of_ender_pick.png",
	groups = { tool=1, pickaxe=1, dig_speed_class=5, enchantability=10 },
	tool_capabilities = {
		full_punch_interval = 0.83333333,
		max_drop_level=5,
		damage_groups = {fleshy=5},
		punch_attack_uses = 585,
	},
	_repair_material = "mcl_end:ender_eye",
	_mcl_diggroups = {
		pickaxey = { speed = 7, level = 5, uses = 1172 }
	},
})

local ghast_blaze_pick_definition = table.copy(eye_of_ender_pick_definition)
merge_tables(ghast_blaze_pick_definition, {
	description = S("Ghast-Blaze Pickaxe"),
	inventory_image = "ghast_blaze_pick.png",
	_repair_material = {"mcl_mobitems:ghast_tear", "mcl_mobitems:blaze_rod"}
})


core.register_tool("cvl_tools:dirt_pick", dirt_pick_definition)
core.register_tool("cvl_tools:snow_pick", snow_pick_definition)
core.register_tool("cvl_tools:smooth_granite_pick", smooth_granite_pick_definition)
core.register_tool("cvl_tools:smooth_andesite_pick", smooth_andesite_pick_definition)
core.register_tool("cvl_tools:smooth_diorite_pick", smooth_diorite_pick_definition)
core.register_tool("cvl_tools:eye_of_ender_pick", eye_of_ender_pick_definition)
core.register_tool("cvl_tools:ghast_blaze_pick", ghast_blaze_pick_definition)
core.register_tool("cvl_tools:water_pick", water_pick_definition)
core.register_tool("cvl_tools:lava_pick", lava_pick_definition)



-- Shovels
local stone_shovel_definition = core.registered_tools["mcl_tools:shovel_stone"]

local dirt_shovel_definition = table.copy(stone_shovel_definition)
merge_tables(dirt_shovel_definition, {
	description = S("Dirt Shovel"),
	_doc_items_hidden = false,
	inventory_image = "dirt_shovel.png",
	groups = { tool=1, shovel=1, dig_speed_class=2, enchantability=10 },
	tool_capabilities = {
		full_punch_interval = 1,
		max_drop_level=3,
		damage_groups = {fleshy=3},
		punch_attack_uses = 23
	},
	_repair_material = "mcl_core:dirt",
	_mcl_diggroups = {
		shovely = { speed = 2, level = 3, uses = 35 }
	}
})

local snow_shovel_definition = table.copy(dirt_shovel_definition)
merge_tables(snow_shovel_definition, {
	description = S("Snow Shovel"),
	inventory_image = "snow_shovel.png",
	_repair_material = "mcl_core:snowblock"
})

local water_shovel_definition = table.copy(dirt_shovel_definition)
merge_tables(water_shovel_definition, {
	description = S("Water Shovel"),
	inventory_image = "water_shovel.png",
	_repair_material = "mcl_buckets:bucket_water"
})

local smooth_granite_shovel_definition = table.copy(stone_shovel_definition)
merge_tables(smooth_granite_shovel_definition, {
	description = S("Polished Granite Shovel"),
	inventory_image = "granite_shovel.png",
	groups = { tool=1, shovel=1, dig_speed_class=4, enchantability=10 },
	tool_capabilities = {
		full_punch_interval = 1,
		max_drop_level=3,
		damage_groups = {fleshy=3},
		punch_attack_uses = 99
	},
	_repair_material = "mcl_core:granite_smooth",
	_mcl_diggroups = {
		shovely = { speed = 5, level = 3, uses = 198 }
	}
})

local smooth_andesite_shovel_definition = table.copy(smooth_granite_shovel_definition)
merge_tables(smooth_andesite_shovel_definition, {
	description = S("Polished Andesite Shovel"),
	inventory_image = "andesite_shovel.png",
	_repair_material = "mcl_core:andesite_smooth"
})

local smooth_diorite_shovel_definition = table.copy(smooth_granite_shovel_definition)
merge_tables(smooth_diorite_shovel_definition, {
	description = S("Polished Diorite Shovel"),
	inventory_image = "diorite_shovel.png",
	_repair_material = "mcl_core:diorite_smooth"
})

local lava_shovel_definition = table.copy(smooth_granite_shovel_definition)
merge_tables(lava_shovel_definition, {
	description = S("Lava Shovel"),
	inventory_image = "lava_shovel.png",
	_repair_material = "mcl_buckets:bucket_lava"
})

local eye_of_ender_shovel_definition = table.copy(stone_shovel_definition)
merge_tables(eye_of_ender_shovel_definition, {
	description = S("Eye Of Ender Shovel"),
	inventory_image = "eye_of_ender_shovel.png",
	groups = { tool=1, shovel=1, dig_speed_class=5, enchantability=10 },
	tool_capabilities = {
		full_punch_interval = 1,
		max_drop_level=5,
		damage_groups = {fleshy=5},
		punch_attack_uses = 585,
	},
	_repair_material = "mcl_end:ender_eye",
	_mcl_diggroups = {
		shovely = { speed = 7, level = 5, uses = 1172 }
	},
})

local ghast_blaze_shovel_definition = table.copy(eye_of_ender_shovel_definition)
merge_tables(ghast_blaze_shovel_definition, {
	description = S("Ghast-Blaze Shovel"),
	inventory_image = "ghast_blaze_shovel.png",
	_repair_material = {"mcl_mobitems:ghast_tear", "mcl_mobitems:blaze_rod"}
})


core.register_tool("cvl_tools:dirt_shovel", dirt_shovel_definition)
core.register_tool("cvl_tools:snow_shovel", snow_shovel_definition)
core.register_tool("cvl_tools:smooth_granite_shovel", smooth_granite_shovel_definition)
core.register_tool("cvl_tools:smooth_andesite_shovel", smooth_andesite_shovel_definition)
core.register_tool("cvl_tools:smooth_diorite_shovel", smooth_diorite_shovel_definition)
core.register_tool("cvl_tools:eye_of_ender_shovel", eye_of_ender_shovel_definition)
core.register_tool("cvl_tools:ghast_blaze_shovel", ghast_blaze_shovel_definition)
core.register_tool("cvl_tools:water_shovel", water_shovel_definition)
core.register_tool("cvl_tools:lava_shovel", lava_shovel_definition)

-- Axes
local stone_axe_definition = core.registered_tools["mcl_tools:axe_stone"]

local dirt_axe_definition = table.copy(stone_axe_definition)
merge_tables(dirt_axe_definition, {
	description = S("Dirt Axe"),
	_doc_items_hidden = false,
	inventory_image = "dirt_axe.png",
	groups = { tool=1, axe=1, dig_speed_class=2, enchantability=10 },
	tool_capabilities = {
		full_punch_interval = 1.25,
		max_drop_level=3,
		damage_groups = {fleshy=5},
		punch_attack_uses = 23
	},
	_repair_material = "mcl_core:dirt",
	_mcl_diggroups = {
		axey = { speed = 2, level = 3, uses = 35 }
	}
})

local snow_axe_definition = table.copy(dirt_axe_definition)
merge_tables(snow_axe_definition, {
	description = S("Snow Axe"),
	inventory_image = "snow_axe.png",
	_repair_material = "mcl_core:snowblock"
})

local water_axe_definition = table.copy(dirt_axe_definition)
merge_tables(water_axe_definition, {
	description = S("Water Axe"),
	inventory_image = "water_axe.png",
	_repair_material = "mcl_buckets:bucket_water"
})

local smooth_granite_axe_definition = table.copy(stone_axe_definition)
merge_tables(smooth_granite_axe_definition, {
	description = S("Polished Granite Axe"),
	inventory_image = "granite_axe.png",
	groups = { tool=1, axe=1, dig_speed_class=4, enchantability=10 },
	tool_capabilities = {
		full_punch_interval = 1.25,
		max_drop_level=3,
		damage_groups = {fleshy=9},
		punch_attack_uses = 99
	},
	_repair_material = "mcl_core:granite_smooth",
	_mcl_diggroups = {
		axey = { speed = 5, level = 3, uses = 198 }
	}
})

local smooth_andesite_axe_definition = table.copy(smooth_granite_axe_definition)
merge_tables(smooth_andesite_axe_definition, {
	description = S("Polished Andesite Axe"),
	inventory_image = "andesite_axe.png",
	_repair_material = "mcl_core:andesite_smooth"
})

local smooth_diorite_axe_definition = table.copy(smooth_granite_axe_definition)
merge_tables(smooth_diorite_axe_definition, {
	description = S("Polished Diorite Axe"),
	inventory_image = "diorite_axe.png",
	_repair_material = "mcl_core:diorite_smooth"
})

local lava_axe_definition = table.copy(smooth_granite_axe_definition)
merge_tables(lava_axe_definition, {
	description = S("Lava Axe"),
	inventory_image = "lava_axe.png",
	_repair_material = "mcl_buckets:bucket_lava"
})

local eye_of_ender_axe_definition = table.copy(stone_axe_definition)
merge_tables(eye_of_ender_axe_definition, {
	description = S("Eye Of Ender Axe"),
	inventory_image = "eye_of_ender_axe.png",
	groups = { tool=1, axe=1, dig_speed_class=5, enchantability=10 },
	tool_capabilities = {
		full_punch_interval = 1.25,
		max_drop_level=5,
		damage_groups = {fleshy=9},
		punch_attack_uses = 585,
	},
	_repair_material = "mcl_end:ender_eye",
	_mcl_diggroups = {
		axey = { speed = 7, level = 5, uses = 1172 }
	},
})

local ghast_blaze_axe_definition = table.copy(eye_of_ender_axe_definition)
merge_tables(ghast_blaze_axe_definition, {
	description = S("Ghast-Blaze Axe"),
	inventory_image = "ghast_blaze_axe.png",
	_repair_material = {"mcl_mobitems:ghast_tear", "mcl_mobitems:blaze_rod"}
})


core.register_tool("cvl_tools:dirt_axe", dirt_axe_definition)
core.register_tool("cvl_tools:snow_axe", snow_axe_definition)
core.register_tool("cvl_tools:smooth_granite_axe", smooth_granite_axe_definition)
core.register_tool("cvl_tools:smooth_andesite_axe", smooth_andesite_axe_definition)
core.register_tool("cvl_tools:smooth_diorite_axe", smooth_diorite_axe_definition)
core.register_tool("cvl_tools:eye_of_ender_axe", eye_of_ender_axe_definition)
core.register_tool("cvl_tools:ghast_blaze_axe", ghast_blaze_axe_definition)
core.register_tool("cvl_tools:water_axe", water_axe_definition)
core.register_tool("cvl_tools:lava_axe", lava_axe_definition)



-- Swords
local stone_sword_definition = core.registered_tools["mcl_tools:sword_stone"]

local dirt_sword_definition = table.copy(stone_sword_definition)
merge_tables(dirt_sword_definition, {
	description = S("Dirt Sword"),
	_doc_items_hidden = false,
	inventory_image = "dirt_sword.png",
	groups = { weapon=1, sword=1, dig_speed_class=2, enchantability=10 },
	tool_capabilities = {
		full_punch_interval = 0.625,
		max_drop_level=3,
		damage_groups = {fleshy=4},
		punch_attack_uses = 23
	},
	_repair_material = "mcl_core:dirt",
	_mcl_diggroups = {
		swordy = { speed = 2, level = 3, uses = 35 },
		swordy_cobweb = { speed = 2, level = 3, uses = 35 }
	}
})

local snow_sword_definition = table.copy(dirt_sword_definition)
merge_tables(snow_sword_definition, {
	description = S("Snow Sword"),
	inventory_image = "snow_sword.png",
	_repair_material = "mcl_core:snowblock"
})

local water_sword_definition = table.copy(dirt_sword_definition)
merge_tables(water_sword_definition, {
	description = S("Water Sword"),
	inventory_image = "water_sword.png",
	_repair_material = "mcl_buckets:bucket_water"
})

local smooth_granite_sword_definition = table.copy(stone_sword_definition)
merge_tables(smooth_granite_sword_definition, {
	description = S("Polished Granite Sword"),
	inventory_image = "granite_sword.png",
	groups = { weapon=1, sword=1, dig_speed_class=4, enchantability=10 },
	tool_capabilities = {
		full_punch_interval = 0.625,
		max_drop_level=3,
		damage_groups = {fleshy=5},
		punch_attack_uses = 198
	},
	_repair_material = "mcl_core:granite_smooth",
	_mcl_diggroups = {
		swordy = { speed = 5, level = 3, uses = 198 },
		swordy_cobweb = { speed = 5, level = 3, uses = 198 }
	}
})

local smooth_andesite_sword_definition = table.copy(smooth_granite_sword_definition)
merge_tables(smooth_andesite_sword_definition, {
	description = S("Polished Andesite Sword"),
	inventory_image = "andesite_sword.png",
	_repair_material = "mcl_core:andesite_smooth"
})

local smooth_diorite_sword_definition = table.copy(smooth_granite_sword_definition)
merge_tables(smooth_diorite_sword_definition, {
	description = S("Polished Diorite Sword"),
	inventory_image = "diorite_sword.png",
	_repair_material = "mcl_core:diorite_smooth"
})

local lava_sword_definition = table.copy(smooth_granite_sword_definition)
merge_tables(lava_sword_definition, {
	description = S("Lava Sword"),
	inventory_image = "lava_sword.png",
	_repair_material = "mcl_buckets:bucket_lava"
})

local eye_of_ender_sword_definition = table.copy(stone_sword_definition)
merge_tables(eye_of_ender_sword_definition, {
	description = S("Eye Of Ender Sword"),
	inventory_image = "eye_of_ender_sword.png",
	groups = { weapon=1, sword=1, dig_speed_class=5, enchantability=10 },
	tool_capabilities = {
		full_punch_interval = 0.625,
		max_drop_level=5,
		damage_groups = {fleshy=9},
		punch_attack_uses = 1523,
	},
	_repair_material = "mcl_end:ender_eye",
	_mcl_diggroups = {
		swordy = { speed = 7, level = 5, uses = 1172 },
		swordy_cobweb = { speed = 7, level = 5, uses = 1172 }
	},
})

local ghast_blaze_sword_definition = table.copy(eye_of_ender_sword_definition)
merge_tables(ghast_blaze_sword_definition, {
	description = S("Ghast-Blaze Sword"),
	inventory_image = "ghast_blaze_sword.png",
	_repair_material = {"mcl_mobitems:ghast_tear", "mcl_mobitems:blaze_rod"}
})


core.register_tool("cvl_tools:dirt_sword", dirt_sword_definition)
core.register_tool("cvl_tools:snow_sword", snow_sword_definition)
core.register_tool("cvl_tools:smooth_granite_sword", smooth_granite_sword_definition)
core.register_tool("cvl_tools:smooth_andesite_sword", smooth_andesite_sword_definition)
core.register_tool("cvl_tools:smooth_diorite_sword", smooth_diorite_sword_definition)
core.register_tool("cvl_tools:eye_of_ender_sword", eye_of_ender_sword_definition)
core.register_tool("cvl_tools:ghast_blaze_sword", ghast_blaze_sword_definition)
core.register_tool("cvl_tools:water_sword", water_sword_definition)
core.register_tool("cvl_tools:lava_sword", lava_sword_definition)

-- MultiTools
local dirt_multitool_definition = table.copy(stone_pick_definition)
merge_tables(dirt_multitool_definition, {
	description = S("Dirt MultiTool"),
	_doc_items_hidden = false,
	inventory_image = "dirt_multitool.png",
	groups = { tool=1, pickaxe=1, dig_speed_class=2, enchantability=10 },
	tool_capabilities = {
		full_punch_interval = 0.625,
		max_drop_level=3,
		damage_groups = {fleshy=4},
		punch_attack_uses = 23
	},
	_repair_material = "mcl_core:dirt",
	_mcl_diggroups = {
		pickaxey = { speed = 1, level = 3, uses = 35 },
		shovely = { speed = 2, level = 3, uses = 35 },
		axey = { speed = 2, level = 3, uses = 35 },
		swordy = { speed = 2, level = 3, uses = 35 },
		swordy_cobweb = { speed = 2, level = 3, uses = 35 }
	}
})

local snow_multitool_definition = table.copy(dirt_multitool_definition)
merge_tables(snow_multitool_definition, {
	description = S("Snow MultiTool"),
	inventory_image = "snow_multitool.png",
	_repair_material = "mcl_core:snowblock"
})

local water_multitool_definition = table.copy(dirt_multitool_definition)
merge_tables(water_multitool_definition, {
	description = S("Water MultiTool"),
	inventory_image = "water_multitool.png",
	_repair_material = "mcl_buckets:bucket_water"
})

local smooth_granite_multitool_definition = table.copy(stone_pick_definition)
merge_tables(smooth_granite_multitool_definition, {
	description = S("Polished Granite MultiTool"),
	inventory_image = "granite_multitool.png",
	groups = { tool=1, pickaxe=1, dig_speed_class=4, enchantability=10 },
	tool_capabilities = {
		full_punch_interval = 0.625,
		max_drop_level=3,
		damage_groups = {fleshy=5},
		punch_attack_uses = 198
	},
	_repair_material = "mcl_core:granite_smooth",
	_mcl_diggroups = {
		pickaxey = { speed = 5, level = 3, uses = 198 },
		shovely = { speed = 5, level = 3, uses = 198 },
		axey = { speed = 5, level = 3, uses = 198 },
		swordy = { speed = 5, level = 3, uses = 198 },
		swordy_cobweb = { speed = 5, level = 3, uses = 198 }
	}
})

local smooth_andesite_multitool_definition = table.copy(smooth_granite_multitool_definition)
merge_tables(smooth_andesite_multitool_definition, {
	description = S("Polished Andesite MultiTool"),
	inventory_image = "andesite_multitool.png",
	_repair_material = "mcl_core:andesite_smooth"
})

local smooth_diorite_multitool_definition = table.copy(smooth_granite_multitool_definition)
merge_tables(smooth_diorite_multitool_definition, {
	description = S("Polished Diorite MultiTool"),
	inventory_image = "diorite_multitool.png",
	_repair_material = "mcl_core:diorite_smooth"
})

local lava_multitool_definition = table.copy(smooth_granite_multitool_definition)
merge_tables(lava_multitool_definition, {
	description = S("Lava MultiTool"),
	inventory_image = "lava_multitool.png",
	_repair_material = "mcl_buckets:bucket_lava"
})

local eye_of_ender_multitool_definition = table.copy(stone_pick_definition)
merge_tables(eye_of_ender_multitool_definition, {
	description = S("Eye Of Ender MultiTool"),
	inventory_image = "eye_of_ender_multitool.png",
	groups = { tool=1, pickaxe=1, dig_speed_class=5, enchantability=10 },
	tool_capabilities = {
		full_punch_interval = 0.625,
		max_drop_level=5,
		damage_groups = {fleshy=9},
		punch_attack_uses = 1523,
	},
	_repair_material = "mcl_end:ender_eye",
	_mcl_diggroups = {
		pickaxey = { speed = 7, level = 5, uses = 1172 },
		shovely = { speed = 7, level = 5, uses = 1172 },
		axey = { speed = 7, level = 5, uses = 1172 },
		swordy = { speed = 7, level = 5, uses = 1172 },
		swordy_cobweb = { speed = 7, level = 5, uses = 1172 }
	}
})

local ghast_blaze_multitool_definition = table.copy(eye_of_ender_multitool_definition)
merge_tables(ghast_blaze_multitool_definition, {
	description = S("Ghast-Blaze MultiTool"),
	inventory_image = "ghast_blaze_multitool.png",
	_repair_material = {"mcl_mobitems:ghast_tear", "mcl_mobitems:blaze_rod"}
})

core.register_tool("cvl_tools:dirt_multitool", dirt_multitool_definition)
core.register_tool("cvl_tools:snow_multitool", snow_multitool_definition)
core.register_tool("cvl_tools:water_multitool", water_multitool_definition)
core.register_tool("cvl_tools:smooth_granite_multitool", smooth_granite_multitool_definition)
core.register_tool("cvl_tools:smooth_andesite_multitool", smooth_andesite_multitool_definition)
core.register_tool("cvl_tools:smooth_diorite_multitool", smooth_diorite_multitool_definition)
core.register_tool("cvl_tools:lava_multitool", lava_multitool_definition)
core.register_tool("cvl_tools:eye_of_ender_multitool", eye_of_ender_multitool_definition)
core.register_tool("cvl_tools:ghast_blaze_multitool", ghast_blaze_multitool_definition)

dofile(modpath.."/crafting.lua")
dofile(modpath.."/aliases.lua")