-- compatibility hack for VoxeLibre enchantment system

local MODE_MATERIAL_THEN_TYPE = 1
local MODE_TYPE_THEN_MATERIAL = 2

local function register_compatibility_tool(tool_type, material_name, old_material_name, mode)
    local original_name = "cvl_tools:"..material_name.."_"..tool_type
    local alias_tail = ""

    if mode == MODE_MATERIAL_THEN_TYPE then
        alias_tail = old_material_name.."_"..tool_type
    else
        alias_tail = tool_type.."_"..old_material_name
    end

    local definition = table.copy(core.registered_tools[original_name])

    definition.groups.not_in_creative_inventory = 1

    core.register_tool(":cat_voxelibre_tools:"..alias_tail, definition)
end

local function register_compatibility_tools_for_material(material_name, old_material_name, mode)
    register_compatibility_tool("pick", material_name, old_material_name, mode)
    register_compatibility_tool("shovel", material_name, old_material_name, mode)
    register_compatibility_tool("axe", material_name, old_material_name, mode)
    register_compatibility_tool("sword", material_name, old_material_name, mode)
end

local materials = {
    dirt = {
        mode = MODE_TYPE_THEN_MATERIAL
    },
    snow = {
        mode = MODE_TYPE_THEN_MATERIAL
    },
    smooth_granite = {
        old_name = "granite_smooth",
        mode = MODE_TYPE_THEN_MATERIAL
    },
    smooth_andesite = {
        old_name = "andesite_smooth",
        mode = MODE_TYPE_THEN_MATERIAL
    },
    smooth_diorite = {
        old_name = "diorite_smooth",
        mode = MODE_TYPE_THEN_MATERIAL
    },
    eye_of_ender = {
        mode = MODE_MATERIAL_THEN_TYPE
    },
    ghast_blaze = {
        mode = MODE_MATERIAL_THEN_TYPE
    },
    water = {
        mode = MODE_MATERIAL_THEN_TYPE
    },
    lava = {
        mode = MODE_MATERIAL_THEN_TYPE
    }
}

for material_name, compatibility_properties in pairs(materials) do
    local old_material_name = material_name

    if compatibility_properties.old_name then
        old_material_name = compatibility_properties.old_name
    end

    register_compatibility_tools_for_material(material_name, old_material_name, compatibility_properties.mode)
end