core.register_node("feld_base:stone", {
	description = "Stone",
	tiles = {"feld_base_stone.jpg"},
	is_ground_content = true,
	stack_max = 64,
	groups = {pick=1, stone=1},
	drop = "feld_base:cobble",
})

core.register_node("feld_base:cobble", {
	description = "Cobblestone",
	tiles = {"feld_base_cobble.jpg"},
	stack_max = 64,
	groups = {pick=1, stone=2},
})

core.register_node("feld_base:sand_stone", {
	description = "Sandstone",
	tiles = {"feld_base_sand_stone_top.jpg", "feld_base_sand_stone_bottom.jpg", "feld_base_sand_stone_side.jpg"},
	is_ground_content = true,
	stack_max = 64,
	groups = {pick=1, stone=3},
})

core.register_node("feld_base:dirt", {
    description = "Dirt",
    tiles = {"feld_base_dirt.jpg"},
    stack_max = 64,
    groups = {crumbly=1, shovel=1, dirt=1},
})

core.register_node("feld_base:dirt_with_grass", {
    description = "Grass Block",
    tiles = {"feld_base_dirt_with_grass_top.jpg", "feld_base_dirt.jpg", "feld_base_dirt_with_grass.jpg"},
    stack_max = 64,
    groups = {crumbly=1, shovel=1, dirt=2},
	drop = "feld_base:dirt",
})

core.register_node("feld_base:sand", {
	description = "Sand",
	tiles = {"feld_base_sand.jpg"},
	is_ground_content = true,
	stack_max = 64,
	groups = {crumbly=1, falling_node=1, shovel=1, sand=1},
})

core.register_node("feld_base:water_source", {
    description = "Water Source",
    drawtype = "liquid",
    tiles = {"feld_base_water_source.png"},
    paramtype = "light",
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	drop = "",
	drowning = 1,
	liquidtype = "source",
	liquid_alternative_flowing = "feld_base:water_flowing",
	liquid_alternative_source = "feld_base:water_source",
	liquid_range = 7,
    groups = {water=1},
})

core.register_node("feld_base:water_flowing", {
    description = "Flowing Water",
    drawtype = "flowingliquid",
    tiles = {"feld_base_water_source.png"},
	special_tiles = {"feld_base_water_source.png", "feld_base_water_source.png"},
    paramtype = "light",
	paramtype2 = "flowingliquid",
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	drop = "",
	drowning = 1,
	liquidtype = "flowing",
	liquid_alternative_flowing = "feld_base:water_flowing",
	liquid_alternative_source = "feld_base:water_source",
	liquid_range = 7,
    groups = {water=2},
})

