core.register_alias("mapgen_stone", "feld_base:stone")
core.register_alias("mapgen_cobble", "feld_base:cobble")
core.register_alias("mapgen_water_source", "feld_base:water_source")
core.register_alias("mapgen_river_water_source", "feld_base:water_source")

core.register_biome({
    name = "feld_base:plane",
    node_top = "feld_base:dirt_with_grass",
    depth_top = 1,
    node_filler = "feld_base:dirt",
    depth_filler = 3,
	y_max = 51,
    y_min = 2,
    heat_point = 50,
    humidity_point = 60,
})

core.register_biome({
    name = "feld_base:desert",
    node_top = "feld_base:sand",
    depth_top = 3,
	node_stone = "feld_base:sand_stone",
	node_riverbed = "feld_base:sand",
	depth_riverbed = 3,
    y_max = 31000,
    y_min = 2,
    heat_point = 85,
    humidity_point = 20,
})

core.register_biome({
    name = "feld_base:forest",
    node_top = "feld_base:dirt_with_grass",
    depth_top = 1,
    node_filler = "feld_base:dirt",
    depth_filler = 3,
	y_max = 31000,
    y_min = 2,
    heat_point = 45,
    humidity_point = 50,
    _noise_params = {
        offset = 0.5,
        scale = 2,
        spread = {x = 8, y = 8, z = 8},
        octaves = 6,
        persist = 0.6,
        lacunarity = 2.0,
        flags = "defaults, eased"
    }
})

core.register_biome({
    name = "feld_base:beach",
    node_top = "feld_base:sand",
    depth_top = 1,
    node_filler = "feld_base:sand",
    depth_filler = 3,
	y_max = 1,
    y_min = -4,
    heat_point = 25,
    humidity_point = 99,
})

core.register_biome({
    name = "feld_base:ocean",
    node_top = "feld_base:sand",
    depth_top = 1,
    node_filler = "feld_base:sand",
    depth_filler = 1,
    node_stone = "feld_base:stone",
	y_max = -5,
    y_min = -31000,
    heat_point = 15,
    humidity_point = 100,
})