local S = minetest.get_translator("arena_lib")

----------------------------------------------
-----------------WORLD FOLDER-----------------
----------------------------------------------
local function load_world_folder()
  local wrld_dir = minetest.get_worldpath() .. "/arena_lib"
  local content = minetest.get_dir_list(wrld_dir)

  if not next(content) then
    local modpath = minetest.get_modpath("arena_lib")
    local src_dir = modpath .. "/IGNOREME"

    minetest.cpdir(src_dir, wrld_dir)
    os.remove(wrld_dir .. "/README.md")
    os.remove(wrld_dir .. "/BGM/.gitkeep")
    os.remove(wrld_dir .. "/Schematics/.gitkeep")
    os.remove(wrld_dir .. "/Thumbnails/.gitkeep")

  else
    --v------------------ LEGACY UPDATE, to remove in 9.0 -------------------v
    if not os.rename(wrld_dir .. "/Schematics/", wrld_dir .. "/Schematics") then
      local instructions = io.open(minetest.get_modpath("arena_lib") .. "/IGNOREME/instructions.txt", "r")
      local txt = instructions:read("*all")

      instructions:close()
      minetest.mkdir(wrld_dir .. "/Schematics/")
      minetest.safe_file_write(wrld_dir .. "/instructions.txt", txt)
    end
    --^------------------ LEGACY UPDATE, to remove in 9.0 -------------------^

    -- aggiungi musiche come contenuti dinamici per non appesantire il server
    local function iterate_dirs(dir)
      for _, f_name in pairs(minetest.get_dir_list(dir, false)) do
        -- NOT REALLY DYNAMIC MEDIA, since it's run when the server launches and there are no players online
        -- it's just to load these tracks from the world folder (so that `sound_play` recognises them without the full path)
        minetest.dynamic_add_media({filepath = dir .. "/" .. f_name}, function(name) end)
      end
      for _, subdir in pairs(minetest.get_dir_list(dir, true)) do
        iterate_dirs(dir .. "/" .. subdir)
      end
    end

    -- non si possono aggiungere contenuti dinamici all'avvio del server
    minetest.after(0.1, function()
      iterate_dirs(wrld_dir .. "/BGM")
      iterate_dirs(wrld_dir .. "/Thumbnails")
    end)
  end
end

load_world_folder()





----------------------------------------------
-------------------SETTINGS-------------------
----------------------------------------------
dofile(minetest.get_worldpath() .. "/arena_lib/SETTINGS.lua")

-- to remove in 8.0
-- rename PALETTE `_default` into `___`
if arena_lib.PALETTE._default then
  local file_content = {}
  local settings = io.open(minetest.get_worldpath() .. "/arena_lib/SETTINGS.lua", "r")

  for line in settings:lines() do
    if string.match(line, "_default") then
      line = line:gsub("_default", "___")
    end
    table.insert(file_content, line)
  end

  settings:close()

  settings = io.open(minetest.get_worldpath() .. "/arena_lib/SETTINGS.lua", "w")
  for k, v in ipairs(file_content) do
    settings:write(v .. "\n")
  end

  settings:close()
end

-- to remove in 9.0
if not arena_lib.RESET_NODES_PER_TICK then
  local settings = io.open(minetest.get_worldpath() .. "/arena_lib/SETTINGS.lua", "r")
  local param = {
    "",
    "-- For minigames with map regeneration enabled. The amount of nodes to reset on",
    "-- each step. The higher you set it the faster it'll go, but it'll also increase lag",
    "arena_lib.RESET_NODES_PER_TICK = 40"
  }
  local txt = settings:read("*all") .. table.concat(param, "\n")

  settings:close()
  minetest.safe_file_write(minetest.get_worldpath() .. "/arena_lib/SETTINGS.lua", txt)

  minetest.log("action", "[ARENA_LIB] Settings: `arena_lib.RESET_NODES_PER_TICK` was missing. Successfully added at the end of the file")
end





----------------------------------------------
------------------AUDIO_LIB-------------------
----------------------------------------------

audio_lib.register_sound("sfx", "arenalib_countdown", S("Countdown ticks"))
audio_lib.register_sound("sfx", "arenalib_match_join", S("Someone joins"))
audio_lib.register_sound("sfx", "arenalib_match_leave", S("Someone leaves"))