local S = minetest.get_translator("arena_lib")

local function get_region_formspec() end

local map_tools = {
  "arena_lib:map_region",
  "",                                 -- arena_lib:map_save
  "",                                 -- arena_lib:map_hard_reset
  "",
  "",
  "",
  "",
  "",
  "arena_lib:editor_return",
  "arena_lib:editor_quit",
}



minetest.register_tool("arena_lib:map_region", {

  description = S("Arena region (LMB pos1, RMB pos2, Q removes)"),
  inventory_image = "arenalib_tool_map_region.png",
  groups = {not_in_creative_inventory = 1},

  on_drop = function(itemstack, dropper, pos)
    local arena_name  = dropper:get_meta():get_string("arena_lib_editor.arena")
    minetest.show_formspec(dropper:get_player_name(), "arena_lib:settings_region", get_region_formspec(arena_name))
  end,

  on_use = function(itemstack, user, pointed_thing)
    local mod         = user:get_meta():get_string("arena_lib_editor.mod")
    local arena_name  = user:get_meta():get_string("arena_lib_editor.arena")
    local _, arena    = arena_lib.get_arena_by_name(mod, arena_name)
    local p_pos       = user:get_pos()
    local pos2        = arena.pos2 or p_pos

    -- copio perché arena.pos2 non è creato da vector.*, fallendo vector.check() in arena_lib.set_region()
    arena_lib.set_region(user:get_player_name(), mod, arena_name, p_pos, vector.copy(pos2), true)
  end,

  on_secondary_use = function(itemstack, user, pointed_thing)
    local mod         = user:get_meta():get_string("arena_lib_editor.mod")
    local arena_name  = user:get_meta():get_string("arena_lib_editor.arena")
    local _, arena    = arena_lib.get_arena_by_name(mod, arena_name)
    local p_pos       = user:get_pos()
    local pos1        = arena.pos1 or p_pos

    arena_lib.set_region(user:get_player_name(), mod, arena_name, vector.copy(pos1), p_pos, true)
  end,

  on_place = function(itemstack, placer, pointed_thing)
    local mod         = placer:get_meta():get_string("arena_lib_editor.mod")
    local arena_name  = placer:get_meta():get_string("arena_lib_editor.arena")
    local _, arena    = arena_lib.get_arena_by_name(mod, arena_name)
    local p_pos       = placer:get_pos()
    local pos1        = arena.pos1 or p_pos

    arena_lib.set_region(placer:get_player_name(), mod, arena_name, vector.copy(pos1), p_pos, true)
  end
})



minetest.register_tool("arena_lib:map_save", {
  description = S("Save a schematic of the map"),
  inventory_image = "arenalib_tool_map_save.png",
	groups = {not_in_creative_inventory = 1},
  on_drop = function() end,

  on_use = function (itemstack, player)
    local mod = player:get_meta():get_string("arena_lib_editor.mod")
    local arena_name = player:get_meta():get_string("arena_lib_editor.arena")

    arena_lib.save_map_schematic(player:get_player_name(), mod, arena_name, true)
  end
})



minetest.register_tool("arena_lib:map_hard_reset", {
  description = S("Load and paste the map schematic"),
  inventory_image = "arenalib_tool_map_load.png",
  groups = {not_in_creative_inventory = 1},
  on_drop = function() end,

  on_use = function (itemstack, player)
    local mod = player:get_meta():get_string("arena_lib_editor.mod")
    local arena_name = player:get_meta():get_string("arena_lib_editor.arena")
    local _, arena = arena_lib.get_arena_by_name(mod, arena_name)

    arena_lib.hard_reset_map(mod, arena)
    minetest.chat_send_player(player:get_player_name(), S("Schematic loaded!"))
  end
})



function arena_lib.give_map_tools(inv, mod)
  inv:set_list("main", map_tools)

  if arena_lib.mods[mod].regenerate_map then
    inv:set_stack("main", 2, "arena_lib:map_save")
    inv:set_stack("main", 3, "arena_lib:map_hard_reset")
  end
end





----------------------------------------------
---------------FUNZIONI LOCALI----------------
----------------------------------------------

function get_region_formspec(arena_name)
  local formspec = {
    "size[5,1.3]",
    "style[region_delete_confirm;bgcolor=red]",
    "hypertext[0.25,-0.1;5,1;delete_msg;<global halign=center>" .. S("Are you sure you want to delete the region of the arena?") .. "]",
    "button[3,0.7;1.5,0.5;region_delete_confirm;" .. S("Yes") .. "]",
    "button[0.5,0.7;1.5,0.5;region_delete_cancel;" .. S("Cancel") .. "]",
    "field_close_on_enter[;false]"
  }

  return table.concat(formspec, "")
end





----------------------------------------------
---------------GESTIONE CAMPI-----------------
----------------------------------------------

minetest.register_on_player_receive_fields(function(player, formname, fields)
  if formname ~= "arena_lib:settings_region" then return end

  local p_name      =   player:get_player_name()
  local mod         =   player:get_meta():get_string("arena_lib_editor.mod")
  local arena_name  =   player:get_meta():get_string("arena_lib_editor.arena")

  if fields.region_delete_confirm then
    minetest.close_formspec(p_name, formname)

    arena_lib.set_region(p_name, mod, arena_name, nil, nil, true)
  elseif fields.region_delete_cancel then
    minetest.close_formspec(p_name, formname)
  end
end)
