## 1. Audio_lib

Audio_lib is a library to easily manage the audio system of your game and mods.

### 1.1. Music types
The strong point of audio_lib is that it categorises sounds according to their type. This allows manipulation of category-specific audio settings (e.g. background music) without altering the rest (e.g. sound effects).

By default there are two music types: `"bgm"` (background music) and `"sfx"` (sound effects, NOT YET IMPLEMENTED). It'll be possible in the future to add custom types as well.

#### 1.1.1 BGM
Background music acts in a peculiar way: audio_lib won't allow the overlapping of two or more bgm, meaning it won't reproduce more tracks at the same time. Why? Well, because it'd be unusual to have more background tracks running together :D
Background music is always `loop = true`

### 1.2 Registering new sounds
Sounds must be registered before using them, as audio_lib stores their data in a local table. To do that:
* `audio_lib.register_sound(type, track_name, desc, def)`: registers a new sound of type `type` (see [1.1 Music types](###11-music-types)), using `track_name` audio file.
  * `desc` is a short description of the sound. It'll be very useful once accessibility options are integrated
  * `def` is a Minetest [Sound parameter table](https://github.com/minetest/minetest/blob/master/doc/lua_api.md#sound-parameter-table). `pos`, `object`, `to_player` and `exclude_player` won't work. If it's a bgm, nor will `loop = false`

Some examples:
```lua
-- register a bgm
audio_lib.register_sound("bgm", "mymod_bgm1", "The adventure begins")

-- register a bgm and tweaks its parameters
audio_lib.register_sound("bgm", "mymod_bgm1", "The adventure begins", {gain = 1.2, pitch = 0.9})
```

When you want to use a sound in the audio_lib functions, simply use the `track_name` name you've used during the registration

### 1.3 Utils
* `audio_lib.play_bgm(p_name, track_name, <override_params>)`: plays `track_name`, if registered, to `p_name`. `override_params` is a paramaters table that, if declared, will override the parameters of `track_name`
* `audio_lib.continue_bgm(p_name)`: resumes the last bgm `p_name` previously heard, starting from where it had left (MT 5.8+)
* `audio_lib.stop_bgm(p_name)`: interrupts the bgm `p_name` was currently listening to, if any
* `audio_lib.reload_music(p_name, old_settings)`: applies to `p_name` their new audio settings at runtime. `old_settings` is needed for calculation

### 1.4 Getters
* `audio_lib.get_player_bgm(p_name, <in_detail>)`: returns the name of the bgm file currently played for `p_name`, if any.
  * If `in_detail` is `true`, it returns a table instead with in-depth information about the track. Namely:
    ```lua
    {
      -- name of the file
      name = "",
      -- description put in the registration
      description = "",
      -- sound handle
      handle = 7,
      -- when it started to play, in minetest.get_us_time() format
      started_at = 433424,
      -- default MT sound parameters
      params = {}
    }
    ```
* `audio_lib.get_settings(p_name)`: returns a table containing `p_name` settings


## 2. About the author
I'm Zughy, a professional Italian pixel artist who fights for free software and digital ethics. If this library spared you a lot of time and you want to support me somehow, please consider donating on [Liberapay](https://liberapay.com/Zughy/)
