local function can_use() end
local function dash() end



local function register_propulsor(name, desc, stamina)

  minetest.register_tool("block_league:" .. name, {
    description = desc,
    wield_scale = {x=1.3, y=1.3, z=1.3},
    inventory_image = "bl_" .. name .. ".png",
    crosshair = "bl_propulsor_crosshair.png",
    jump_height = 5,
    groups = {oddly_breakable_by_hand = "2", propulsor = 1},

    on_use = function(itemstack, user, pointed_thing)
      if not can_use(user) then return end

      -- se non sta puntando nulla o sta puntando un giocatore, annullo
      if pointed_thing.type == "nothing" or (pointed_thing.type == "object" and minetest.is_player(pointed_thing.ref)) then return end

      local p_name = user:get_player_name()
      local arena = arena_lib.get_arena_by_player(p_name)

      if arena then
        -- se non ha abbastanza energia, annullo
        if not (arena.players[p_name].stamina >= stamina) then return end
        arena.players[p_name].stamina = arena.players[p_name].stamina - stamina
      end

      local dir = user:get_look_dir()
      local knockback = user:get_velocity().y < 1 and -15 or -10

      user:add_velocity(vector.multiply(dir, knockback))
      arena_lib.sound_play(p_name, "bl_propulsor_bounce")
    end,

    on_secondary_use = function(itemstack, user, pointed_thing)
      dash(user, stamina)
    end,

    on_place = function(itemstack, user, pointed_thing)
      dash(user, stamina)
    end
  })
end



register_propulsor("propulsor", "Propulsor", 20)
register_propulsor("propulsor_dm", "Deathmatch Propulsor", 50)





----------------------------------------------
---------------FUNZIONI LOCALI----------------
----------------------------------------------

function dash(player, stamina)
  if not can_use(player) then return end

  local p_name = player:get_player_name()
  local arena = arena_lib.get_arena_by_player(p_name)

  if arena then
    -- se non ha abbastanza energia, annullo
    if not (arena.players[p_name].stamina >= stamina) then return end
    arena.players[p_name].stamina = arena.players[p_name].stamina - stamina
  end

  local dir = player:get_look_dir()
  local look_horizontal = player:get_look_horizontal()
  local rotate_factor = player:get_player_control().left and 1.57 or -1.57
  local dash_dir = vector.rotate_around_axis(minetest.yaw_to_dir(look_horizontal), {x=0,y=1,z=0}, rotate_factor)

  player:add_velocity(vector.multiply(dash_dir, 16))
  arena_lib.sound_play(p_name, "bl_sword_dash")
end



function can_use(player, stamina)
  local meta = player:get_meta()
  if meta:get_int("bl_propulsor_delay") == 1 or
     meta:get_int("bl_death_delay") == 1 or
     meta:get_int("bl_weapon_state") == 3 or
     meta:get_int("bl_weapon_state") == 4 or
     meta:get_int("bl_is_speed_locked") == 1 then return end

  meta:set_int("bl_propulsor_delay", 1)

  minetest.after(0.3, function()
    if not player then return end
    player:get_meta():set_int("bl_propulsor_delay", 0)
  end)

  return true
end
