local version = "0.9.0"
local modpath = minetest.get_modpath("block_league")
local srcpath = modpath .. "/src"

local S = minetest.get_translator("block_league")
local NS = function(s) return s end

block_league = {}
dofile(modpath .. "/GLOBALS.lua")
dofile(srcpath .. "/_load.lua")


arena_lib.register_minigame("block_league", {
  name = S("Block League"),
  prefix = "[" .. S("Block League") .. "] ",
  icon = "bl_pixelgun.png",

  teams = { S("orange"), S("blue") },
  teams_color_overlay = { "orange", "blue"},
  can_disable_teams = true,     -- For tutorial only

  camera_offset = {
    nil,
    {x=8, y=4, z=-1}
  },

  hotbar = {
    slots = 4,
    background_image = "bl_gui_hotbar.png"
  },

  load_time = 6,
  celebration_time = 5,
  join_while_in_progress = true,
  time_mode = "decremental",

  can_drop = false,
  disable_inventory = true,
  disabled_damage_types = {"fall"},
  in_game_physics = block_league.PHYSICS,
  hud_flags = {
    crosshair = false,
    healthbar = true,
    hotbar = true,
    minimap = false,
    wielditem = true
  },

  custom_messages = {
    celebration_nobody = NS("Tie!")
  },

  properties = {
    mode = 1,           -- 0 Tutorial, 1 TD, 2 DM
    score_cap = 5,
    immunity_time = 5,
    death_waiting_time = 6,
    goal_orange = {},
    goal_blue = {},
    waiting_room_orange = {},
    waiting_room_blue = {},
    ball_spawn = {},
    min_y = 0
  },
  temp_properties = {
    weapons_disabled = true,
  },
  team_properties = {
    TDs = 0,
    kills = 0,
    deaths = 0
  },
  player_properties = {
    stamina = 100,
    stamina_max = 100,
    TDs = 0,
    kills = 0,
    points = 0,
    --entering_time = 0,            -- inutilizzato, servirà prob in futuro per calcolare exp
    weapons_magazine = {},          -- KEY: w_name, VALUE: curr_ammo
    current_weapon = "",
    dmg_received = {},              -- KEY: p_name, VALUE: {timestamp, dmg, weapon}
    dmg_dealt = 0
  },
  spectator_properties = {
    was_following_ball = false
  }
})



-- general
dofile(srcpath .. "/commands.lua")
dofile(srcpath .. "/database_manager.lua")
dofile(srcpath .. "/player_manager.lua")
dofile(srcpath .. "/privs.lua")
dofile(srcpath .. "/utils.lua")

-- visible_wielditem
dofile(srcpath .. "/deps/visible_wielditem.lua")
-- arena_lib
dofile(srcpath .. "/arena_lib/arena_editor.lua")
dofile(srcpath .. "/arena_lib/on_celebration.lua")
dofile(srcpath .. "/arena_lib/on_change_spectated_target.lua")
dofile(srcpath .. "/arena_lib/on_death.lua")
dofile(srcpath .. "/arena_lib/on_enable.lua")
dofile(srcpath .. "/arena_lib/on_entering.lua")
dofile(srcpath .. "/arena_lib/on_leaving.lua")
dofile(srcpath .. "/arena_lib/on_prejoin.lua")
dofile(srcpath .. "/arena_lib/on_respawn.lua")
dofile(srcpath .. "/arena_lib/on_start.lua")
dofile(srcpath .. "/arena_lib/on_time_tick.lua")
dofile(srcpath .. "/arena_lib/on_timeout.lua")
-- debug
dofile(srcpath .. "/debug/testkit.lua")
-- GUI
dofile(srcpath .. "/GUI/gui_profile.lua")
-- HUD
dofile(srcpath .. "/HUD/hud_broadcast.lua")
dofile(srcpath .. "/HUD/hud_critical.lua")
dofile(srcpath .. "/HUD/hud_info_panel.lua")
dofile(srcpath .. "/HUD/hud_keys.lua")
dofile(srcpath .. "/HUD/hud_log.lua")
dofile(srcpath .. "/HUD/hud_medals.lua")
dofile(srcpath .. "/HUD/hud_scoreboard.lua")
dofile(srcpath .. "/HUD/hud_skill.lua")
dofile(srcpath .. "/HUD/hud_spectate.lua")
dofile(srcpath .. "/HUD/hud_stamina.lua")
dofile(srcpath .. "/HUD/hud_weapons.lua")
-- game
dofile(srcpath .. "/game/game_main.lua")
dofile(srcpath .. "/game/input_manager.lua")
dofile(srcpath .. "/game/misc/fall.lua")
dofile(srcpath .. "/game/misc/immunity.lua")
dofile(srcpath .. "/game/misc/stamina.lua")
dofile(srcpath .. "/game/TD/ball.lua")
dofile(srcpath .. "/game/TD/rays.lua")
-- player
dofile(srcpath .. "/player/achievements.lua")
dofile(srcpath .. "/player/equip.lua")
dofile(srcpath .. "/player/exp.lua")
-- skills
dofile(srcpath .. "/skills/hp+.lua")
dofile(srcpath .. "/skills/sp+.lua")
-- abstract weapons
dofile(srcpath .. "/weapons/bullets.lua")
dofile(srcpath .. "/weapons/weapons.lua")
dofile(srcpath .. "/weapons/weapons_utils.lua")
-- weapons
dofile(srcpath .. "/weapons/grenade_launcher.lua")
dofile(srcpath .. "/weapons/pixelgun.lua")
dofile(srcpath .. "/weapons/propulsor.lua")
dofile(srcpath .. "/weapons/rocket_launcher.lua")
dofile(srcpath .. "/weapons/sword.lua")
dofile(srcpath .. "/weapons/smg.lua")

minetest.log("action", "[BLOCK_LEAGUE] Mod initialised, running version " .. version)
