local S = minetest.get_translator("block_league")

block_league.register_weapon("block_league:rocket_launcher", {

  description = S("Rocket Launcher"),
  profile_description = "Description test",

  mesh = "bl_rocketlauncher.obj",
  tiles = {"bl_rocketlauncher.png"},
  wield_scale = {x=1.3, y=1.3, z=1.3},
  inventory_image = "bl_rocketlauncher_icon.png",
  crosshair = "bl_smg_crosshair.png",

  weapon_type = "gun",
  magazine = 1,
  reload_time = 0.8,

  action1 = {
    type = "bullet",
    description = "Rocket launcher test",
    damage = 10,
    delay = 0.8,

    decrease_damage_with_distance = false,
    continuous_fire = true,
    -- TODO: range non ha senso, c'è lifetime sul proiettile
    -- TODO: per pierce, bisogna disattivare collisioni giocator3 (nodi possono rimanere (TODO: vari tipi di pierce es x armi che attraversano muri?))
    -- e controllare raggio attorno a proiettile, sennò non c'è modo di fargli attraversare l'entità/giocatorə

    sound = "bl_rocketlauncher_shoot",
    -- TODO: trail direttamente nel proiettile o mantengo coerenza con armi generiche?
    -- `damage` x es. ora lo prende da qua, non da proiettile; eviterei forse 1 e 1

    bullet = {
      name = "rocket", -- TODO: ha senso impostare il nome?

      mesh = "bl_rocket.obj",
      textures = {"bl_bullet_rocket.png"},
      visual_size = {x=1, y=1, z=1},
      collisionbox = {-0.1, -0.1, -0.1, 0.1, 0.1, 0.1},

      speed = 30,
      --bounciness = 0, -- TODO: di base 0. Utile per esempio per granate o proiettili che rimbalzano contro ai muri tipo crylink Xonotic
      lifetime = 5,

      explosion = { -- TODO: si può portare fuori, x tutte le armi (es. Cannonade); motivo per cui explode_on_contact rimane fuori, solo x proiettili
        range = 4,
        damage = 10,
        texture = "bl_rocket_particle.png",
      },

      explode_on_contact = true, -- TODO: considera rinominare in remove_on_contact (l'esplosione avviene se c'è explosion)
      gravity = false,

      -- TODO particelle per quando svanisce? Tipo effetto fumo

      trail = {
        image = "bl_bullet_rocket.png",
        life = 1,
        size = 2,
        interval = 5, -- in step
        amount = 20,
      },

      on_destroy = block_league.explode, -- Cosa fare quando si clicca destro sul proiettile
      on_right_click = function(self)
        self:_destroy()
      end
    },
  },




})
