local S = minetest.get_translator("block_league")

local function remove_HUD() end
local function remove_spectate_HUD() end
local function stop_sounds() end



arena_lib.on_end("block_league", function(arena, winners, is_forced)
  for sp_name, _ in pairs(arena.spectators) do
    block_league.HUD_spectate_remove(arena.players, sp_name)
    remove_HUD(sp_name, true)
  end

  for pl_name, stats in pairs(arena.players) do
    -- zoom out twice (first during the celebration) as the first time is to create
    -- a separation from the game, whereas the latter is to prevent to keep the
    -- gunsight view after the match (I don't want to disable it as I really like
    -- the fact you can zoom during the loading phase)
    block_league.deactivate_zoom(minetest.get_player_by_name(pl_name))
    remove_HUD(pl_name)
    stop_sounds(pl_name)
    pl_name:get_skill(block_league.get_player_skill(pl_name)):disable()

    --block_league.update_storage(pl_name)
  end

  -- se è tutorial, svuota
  if arena.mode == 0 then
    for pl_name, _ in pairs(arena.players) do
      bl_tutorial.unload(pl_name)
    end
  end
end)



arena_lib.on_quit("block_league", function(arena, p_name, is_spectator, reason)
  -- se non si è disconnesso, sgancia la palla e togli lo zoom. A quanto pare la
  -- palla non si sgancia da qua per chi si sconnette, prob get_player_name ritorna nullo
  if reason ~= 0 then
    if not is_spectator and arena.mode == 1 then
      local children = minetest.get_player_by_name(p_name):get_children()
      for _, child in pairs(children) do
        -- potrebbe essere essere un* spettator*, controllo che sia effettivamente la palla
        -- TEMP: get_luaentity() is needed for the moment, as entities on MT are
        -- half broken: they sometimes remain as an empty shell that can't be
        -- removed. If someone enters with a broken entity, we want to avoid the
        -- server go to kaboom (as their get_luaentity() returns nil).
        -- See https://github.com/minetest/minetest/issues/13297
        if not child:is_player() and child:get_luaentity() then
          child:set_detach()
        end
      end
    end

    block_league.deactivate_zoom(minetest.get_player_by_name(p_name))
  end

  remove_spectate_HUD(arena, p_name, is_spectator)
  remove_HUD(p_name, is_spectator)
  stop_sounds(p_name)

  p_name:get_skill(block_league.get_player_skill(p_name)):disable()

  if arena.mode == 0 then
    bl_tutorial.unload(p_name)
  else
    block_league.info_panel_update_all(arena)
  end
end)





----------------------------------------------
---------------FUNZIONI LOCALI----------------
----------------------------------------------

function remove_HUD(p_name, is_spectator)
  block_league.HUD_critical_remove(p_name)
  panel_lib.get_panel(p_name, "bl_stamina"):remove()
  panel_lib.get_panel(p_name, "bl_weapons"):remove()
  panel_lib.get_panel(p_name, "bl_crosshair"):remove()
  panel_lib.get_panel(p_name, "bl_skill"):remove()
  panel_lib.get_panel(p_name, "bl_broadcast"):remove()
  panel_lib.get_panel(p_name, "bl_scoreboard"):remove()
  panel_lib.get_panel(p_name, "bl_log"):remove()

  if is_spectator then return end

  panel_lib.get_panel(p_name, "bl_info_panel"):remove()

  if panel_lib.get_panel(p_name, "bl_keys") then
    panel_lib.get_panel(p_name, "bl_keys"):remove()
  end
end



function remove_spectate_HUD(arena, p_name, is_spectator)
  if is_spectator then
    block_league.HUD_spectate_remove(arena.players, p_name)
  else
    block_league.HUD_spectate_removeplayer(arena, p_name)
  end
end



function stop_sounds(p_name)
  audio_lib.stop_sound(p_name, "bl_voice_countdown_3")
end
