arena_lib.on_celebration("block_league", function(arena, winners)
  arena.weapons_disabled = true

  for pl_name, pl_stats in pairs(arena.players) do
    local player = minetest.get_player_by_name(pl_name)

    block_league.deactivate_zoom(player)
    player:get_meta():set_int("bl_immunity", 1)

    panel_lib.get_panel(pl_name, "bl_info_panel"):show()
    arena_lib.HUD_hide("broadcast", pl_name)
    audio_lib.stop_sound(pl_name, "bl_voice_countdown_3") -- in case of people quitting before the match starts
  end

  -- se è pareggio, passa una stringa (no one)
  local is_tie = type(winners) == "string" and true

  if not is_tie then
    local losers = winners == 1 and 2 or 1
    arena_lib.sound_play_team(arena, winners, "bl_jingle_victory")
    arena_lib.sound_play_team(arena, losers, "bl_jingle_defeat")
  else
    arena_lib.sound_play_all(arena, "bl_jingle_victory")
  end
end)
