local S = minetest.get_translator("block_league")

local function get_formspec() end
local function get_weapon_details() end
local function sanity_check() end

-- Funzionamento in breve: uso il metadato bl_profile_elem_active per tenere traccia
-- di una stringa equivalente al nome tecnico di un'arma o di un'abilità, senza
-- "block_league:". In caso di un'arma uso i campi del formspec weap e wslot; per
-- le abilità skill e sslot.
-- Uso il metadato bl_profile_is_equipping (0 o 1) per capire se è in fase di
-- equipaggiamento o meno

function block_league.show_profile(p_name)
  local p_meta = minetest.get_player_by_name(p_name):get_meta()

  p_meta:set_string("bl_profile_elem_active", "")
  p_meta:set_int("bl_profile_is_equipping", 0)
  minetest.show_formspec(p_name, "block_league:profile", get_formspec(p_name))
end



function get_formspec(p_name)
  local p_props   = minetest.get_player_by_name(p_name):get_properties()
  local p_weaps   = block_league.get_player_weapons(p_name)
  local p_skill   = block_league.get_player_skill(p_name)
  local skill_def = skills.get_skill_def(p_skill)
  local info_section = {}
  local p_meta = minetest.get_player_by_name(p_name):get_meta()
  local elem = p_meta:get_string("bl_profile_elem_active")
  local elem_technical = "block_league:" .. elem

  -- calcolo contenuto da metter sulla destra
  if elem == "" then
    info_section = { "hypertext[0.3,1;4.48,7;elem_desc;<global size=15 halign=center valign=middle><i>" .. S("Welcome to your Block League profile!") .. "\n"
      .. S("Here you can change your equipment and learn about weapons and skills: select one from the panel on the left to know more about it") .. "\n\n"
      .. S("More customisations will be possible in the future@1 (donations help)", "<style color=#7a9090>") .. "</style></i>]"
    }

  else
    local item, elem_name, body, button
    local weap = minetest.registered_items[elem_technical]
    local skill = skills.get_skill_def(elem_technical)

    -- se è un'arma..
    if weap then
      item = weap.mesh and "model[0,1.5;5.08,2.2;weap_model;" .. weap.mesh .. ";" .. table.concat(weap.tiles, ",") .. ";0,140;false;true]"
                       or "image[2,1.7;1.5,1.5;" .. weap.wield_image .. "]"
      elem_name = weap.description
      body = get_weapon_details(weap)

      if p_meta:get_int("bl_profile_is_equipping") == 1 then
        button = [[
          image_button[1.29,7.9;0.712,0.8;bl_gui_profile_button_equip_slot.png;equip_1;1]
          image_button[2.17,7.9;0.712,0.8;bl_gui_profile_button_equip_slot.png;equip_2;2]
          image_button[3.05,7.9;0.712,0.8;bl_gui_profile_button_equip_slot.png;equip_3;3]
          ]]
      else
        button = "image_button[1.45,7.9;2.2,0.8;bl_gui_profile_button_equip.png;equip;" .. S("EQUIP") .. "]"
      end

      -- TODO per quando si potranno rimuovere armi
      --[[if block_league.has_weapon_equipped(p_name, elem_technical) then
        button = "image_button[1.45,7.9;2.2,0.8;bl_gui_profile_button_unequip.png;unequip;" .. S("UNEQUIP") .. "]"
      else
        button = "image_button[1.45,7.9;2.2,0.8;bl_gui_profile_button_equip.png;equip;" .. S("EQUIP") .. "]"
      end]]

    -- se è un'abilità..
    elseif skill then
      item = "image[2,1.7;1.5,1.5;bl_skill_" .. elem .. ".png]"
      elem_name = skill.name
      body = "hypertext[0.3,4.2;4.48,4.3;elem_desc;<global size=15 halign=center><style color=#abc0c0><i>" .. skill._profile_description .. "</i>]"

      if elem_technical ~= p_skill then
        button = "image_button[1.45,7.9;2.2,0.8;bl_gui_profile_button_equip.png;equip;" .. S("EQUIP") .. "]"
      end
    end

    info_section = {
      item,
      "hypertext[0,0.35;5.08,0.8;elem_name;<global size=24 valign=middle halign=center><b>" .. elem_name .. "</b>]",
      body,
      button
    }
  end

  local right_elem = table.concat(info_section, "")
  local curr_achvmt_amnt = #achvmt_lib.get_player_achievements(p_name, {mod = "block_league"})
  local all_achvmt_amnt = achvmt_lib.get_amount({mod = "block_league"})

  -- corpo
  local formspec = {
    "formspec_version[4]",
    "size[19,9,true]",
    "no_prepend[]",
    "background[0,0;19,9;bl_gui_profile_bg.png]",
    "bgcolor[;true]",
    "style_type[item_image_button;border=false]",
    "style_type[image_button;border=false;font=bold]",
    "style[weap,wslot,sslot;font=mono;textcolor=#00000000]",
    "listcolors[#ffffff;#ffffff;#ffffff;#3153b7;#ffffff]",

    -- parte sinistra
    "model[0.08,0.8;5.08,3.6;chara;" .. p_props.mesh .. ";" .. table.concat(p_props.textures, ",") .. ";0,-150;false;true]",
    "container[0.49,5]",
    "image[0,0;1.05,1.05;bl_gui_profile_button_weap.png]]",
    "image[1.1,0;1.05,1.05;bl_gui_profile_button_weap.png]",
    "image[2.2,0;1.05,1.05;bl_gui_profile_button_weap.png]",
    "image[3.3,0;1.05,1.05;bl_gui_profile_button_skill.png]",
    "image_button[0.1,0.11;0.85,0.85;" .. (p_weaps[1] and minetest.registered_nodes[p_weaps[1]].inventory_image or "blank.png") .. ";weap;1]",
    "image_button[1.2,0.11;0.85,0.85;" .. (p_weaps[2] and minetest.registered_nodes[p_weaps[2]].inventory_image or "blank.png") .. ";weap;2]",
    "image_button[2.3,0.11;0.85,0.85;" .. (p_weaps[3] and minetest.registered_nodes[p_weaps[3]].inventory_image or "blank.png") .. ";weap;3]",
    "image_button[3.4,0.11;0.85,0.85;" .. skill_def.icon .. ";skill;]",
    "tooltip[skill;" .. skill_def.name .. "]",
    "container[0.05,1.55]",
    "image[0,0;0.8,0.8;bl_rank_beginner.png]",
    "hypertext[0.9,0;3.25,0.8;pname_txt;<global size=24 valign=middle><b>" .. p_name .. "</b>]",
    "image[0.05,1;0.22,0.22;bl_gui_profile_infobox_trophies.png]",
    "image[0.05,1.8;0.22,0.3;bl_gui_profile_infobox_money.png]",
    "hypertext[0.4,0.94;3.35,0.4;pname_txt;<global size=14 valign=middle><b>" .. curr_achvmt_amnt .. "/" .. all_achvmt_amnt .. "</b>]",
    "hypertext[0.4,1.78;3.35,0.4;pname_txt;<global size=14 valign=middle><b>---</b>]",
    "container_end[]",
    "container_end[]",

    -- parte centrale
    "container[5.85,0.35]",
    "hypertext[0,0;3.35,0.9;weap_txt;<global size=24 valign=middle><style color=#5be7b1><b>" .. S("Weapons") .. "</b>]",
    "image[0,1;1.05,1.05;bl_gui_profile_inv_weapon_unlocked.png]",
    "image[1.25,1;1.05,1.05;bl_gui_profile_inv_weapon_unlocked.png]",
    "image[2.5,1;1.05,1.05;bl_gui_profile_inv_weapon_unlocked.png]",
    "image[3.75,1;1.05,1.05;bl_gui_profile_inv_weapon_unlocked.png]",
    "image[5,1;1.05,1.05;bl_gui_profile_inv_weapon_unlocked.png]",
    "image[6.25,1;1.05,1.05;bl_gui_profile_inv_weapon_locked.png]",
    "image_button[0.1,1.11;0.85,0.85;bl_smg.png;wslot;smg]",
    "image_button[1.35,1.11;0.85,0.85;bl_sword.png;wslot;sword]",
    "image_button[2.6,1.11;0.85,0.85;bl_pixelgun.png;wslot;pixelgun]",
    "image_button[3.85,1.11;0.85,0.85;bl_peacifier.png;wslot;peacifier]",
    "image_button[5.10,1.11;0.85,0.85;bl_kunai.png;wslot;kunai]",
    "image[6.35,1.11;0.85,0.85;blank.png^[multiply:#777777]",
    "hypertext[6.28,1.05;0.95,0.95;soon_tm;<global size=13 halign=center valign=middle><style color=#abc0c0><b>" .. S("Soon") .. "</b>]",
    "container[0,4.5]",
    "hypertext[0,0;3.35,0.9;weap_txt;<global size=24 valign=middle><style color=#5be7b1><b>" .. S("Skills") .. "</b>]",
    "image[0,1;1.05,1.05;bl_gui_profile_inv_skill_unlocked.png]",
    "image[1.25,1;1.05,1.05;bl_gui_profile_inv_skill_unlocked.png]",
    "image[2.5,1;1.05,1.05;bl_gui_profile_inv_skill_locked.png]",
    "image_button[0.1,1.11;0.85,0.85;bl_skill_hp.png;sslot;hp]",
    "image_button[1.35,1.11;0.85,0.85;bl_skill_sp.png;sslot;sp]",
    "image[2.6,1.11;0.85,0.85;bl_skill_shield.png^[multiply:#777777]",
    "hypertext[2.53,1.05;0.95,0.95;soon_tm;<global size=13 halign=center valign=middle><style color=#abc0c0><b>" .. S("Soon") .. "</b>]",
    "container_end[]",
    "container_end[]",

    -- parte destra
    "container[13.88,0]",
    "image_button[5.2,0;0.8,0.8;bl_gui_profile_close.png;close;;true;false;]",
    right_elem,
    "container_end[]"
  }

  return table.concat(formspec, "")
end



function get_weapon_details(weap)
  local action_y = 0
  local action1, action1_hold, action1_air, action2, action2_hold, action2_air

  -- azioni varie
  if weap.action1 then
    action1 = "image[0," .. action_y .. ";0.4,0.55;bl_gui_profile_action_lmb.png]" ..
              "hypertext[0.6," .. action_y - 0.12 .. ";3.8,0.8;elem_desc;<global size=15 valign=middle><i>" .. weap.action1._description .. "</i>]"
    action_y = action_y + 0.8
  end

  if weap.action1_hold then
    action1_hold = "image[0," .. action_y .. ";0.4,0.55;bl_gui_profile_action_lmb_hold.png]" ..
              "hypertext[0.6," .. action_y - 0.12 .. ";3.8,0.8;elem_desc;<global size=15 valign=middle><i>" .. weap.action1_hold._description .. "</i>]"
    action_y = action_y + 0.8
  end

  if weap.action1_air then
    action1_air = "image[0," .. action_y .. ";0.4,0.55;bl_gui_profile_action_lmb_air.png]" ..
              "hypertext[0.6," .. action_y - 0.12 .. ";3.8,0.8;elem_desc;<global size=15 valign=middle><i>" .. weap.action1_air._description .. "</i>]"
    action_y = action_y + 0.8
  end

  if weap.action2 then
    action2 = "image[0," .. action_y .. ";0.4,0.55;bl_gui_profile_action_rmb.png]" ..
              "hypertext[0.6," .. action_y - 0.12 .. ";3.8,0.8;elem_desc;<global size=15 valign=middle><i>" .. weap.action2._description .. "</i>]"
    action_y = action_y + 0.8
  end

  if weap.action2_hold then
    action2_hold = "image[0," .. action_y .. ";0.4,0.55;bl_gui_profile_action_rmb_hold.png]" ..
              "hypertext[0.6," .. action_y - 0.12 .. ";3.8,0.8;elem_desc;<global size=15 valign=middle><i>" .. weap.action2_hold._description .. "</i>]"
    action_y = action_y + 0.8
  end

  if weap.action2_air then
    action1_air = "image[0," .. action_y .. ";0.4,0.55;bl_gui_profile_action_rmb_air.png]" ..
              "hypertext[0.6," .. action_y - 0.12 .. ";3.8,0.8;elem_desc;<global size=15 valign=middle><i>" .. weap.action2_air._description .. "</i>]"
    action_y = action_y + 0.8
  end

  local ammo = ""
  if weap.weapon_type ~= "melee" then
    ammo = table.concat({
      "image[0,1.6;0.4,0.4;bl_gui_profile_weapon_magazine.png]",
      "image[3,1.6;0.4,0.4;bl_gui_profile_weapon_reload.png]",
      "hypertext[0.6,1.53;1,0.6;elem_desc;<global size=16 valign=middle><i>" .. weap.magazine .. "  / --</i>]",
      "hypertext[3.6,1.53;1,0.6;elem_desc;<global size=16 valign=middle><i>" .. weap.reload_time .. "</i>]"
    })
  end

  local attributes = table.concat({
    "hypertext[0.3,4.12;4.48,0.9;elem_desc;<global size=15 halign=center valign=middle><style color=#abc0c0><i>" .. weap._profile_description .. "</i>]",
    "container[0.4,5.1]",
    action1       or "",
    action1_hold  or "",
    action1_air   or "",
    action2       or "",
    action2_hold  or "",
    action2_air   or "",
    ammo,
    "container_end[]",
  }, "")

  return attributes
end



function sanity_check(w_name)
  return weapons_lib.is_weapon(w_name)  -- TODO: quando armi/abilità saran sbloccabili, controlla che ce le abbia
end



----------------------------------------------
---------------GESTIONE CAMPI-----------------
----------------------------------------------

minetest.register_on_player_receive_fields(function(player, formname, fields)
  if formname ~= "block_league:profile" then return end

  if fields.quit then return end

  local p_name = player:get_player_name()
  local p_meta = player:get_meta()
  local elem_technical = "block_league:" .. p_meta:get_string("bl_profile_elem_active")

  p_meta:set_int("bl_profile_is_equipping", 0)

  if fields.close then
    minetest.close_formspec(p_name, "block_league:profile")
    return end

  if fields.weap then
    local weap = block_league.get_player_weapons(p_name)[tonumber(fields.weap)]

    if not weap then
      p_meta:set_string("bl_profile_elem_active", "")
    else
      p_meta:set_string("bl_profile_elem_active", string.sub(weap, 14, -1))
    end

  elseif fields.skill then
    player:get_meta():set_string("bl_profile_elem_active", string.sub(block_league.get_player_skill(p_name), 14, -1))
  elseif fields.wslot then
    player:get_meta():set_string("bl_profile_elem_active", fields.wslot)
  elseif fields.sslot then
    player:get_meta():set_string("bl_profile_elem_active", fields.sslot)
  elseif fields.equip then
    local weap = minetest.registered_items[elem_technical]

    if weap then
      p_meta:set_int("bl_profile_is_equipping", 1)
    else
      block_league.set_player_skill(p_name, elem_technical)
      audio_lib.play_sound("bl_gui_equip_confirm", {to_player = p_name})
    end

  elseif fields.equip_1 then
    if not sanity_check(elem_technical) then return end
    block_league.equip(p_name, elem_technical, 1)
    audio_lib.play_sound("bl_gui_equip_confirm", {to_player = p_name})
  elseif fields.equip_2 then
    if not sanity_check(elem_technical) then return end
    block_league.equip(p_name, elem_technical, 2)
    audio_lib.play_sound("bl_gui_equip_confirm", {to_player = p_name})
  elseif fields.equip_3 then
    if not sanity_check(elem_technical) then return end
    block_league.equip(p_name, elem_technical, 3)
    audio_lib.play_sound("bl_gui_equip_confirm", {to_player = p_name})
  elseif fields.unequip then
    block_league.unequip(p_name, elem_technical)
  end

  minetest.show_formspec(p_name, "block_league:profile", get_formspec(p_name))
end)
