local S = minetest.get_translator("block_league")



function block_league.kill_or_suicide(arena, player, dmg_rcvd_table, no_hitter_img)
  -- se le armi son disabilitate (quindi o in caricamento o dopo punto o in celebrazione) non mostrare niente
  if arena.weapons_disabled then
    block_league.HUD_spectate_update(arena, player:get_player_name(), "alive")
    return end

  local last_hitter = ""
  local last_hitter_timestamp = 99999

  for pla_name, dmg_data in pairs(dmg_rcvd_table) do
    if arena.current_time > dmg_data.timestamp - 5 and last_hitter_timestamp > dmg_data.timestamp then
      last_hitter = pla_name
      last_hitter_timestamp = dmg_data.timestamp
    end
  end

  if last_hitter ~= "" then
    block_league.kill(arena, minetest.registered_nodes[dmg_rcvd_table[last_hitter].weapon], minetest.get_player_by_name(last_hitter), player)
  else
    local p_name = player:get_player_name()
    block_league.HUD_spectate_update(arena, p_name, "alive")
    block_league.HUD_log_update(arena, no_hitter_img, p_name, "")
  end
end



function block_league.kill(arena, weapon, player, target)
  local p_name = player:get_player_name()
  local t_name = target:get_player_name()

  -- riproduco suono morte e aggiorno avatar per spettatorɜ
  arena_lib.sound_play(p_name, "bl_kill")
  block_league.HUD_spectate_update(arena, t_name, "alive")

  if t_name ~= p_name then
    -- informo dell'uccisione
    block_league.HUD_kill_update(p_name, S("YOU'VE KILLED @1", t_name))
    minetest.chat_send_player(t_name, minetest.colorize("#d7ded7", S("You've been killed by @1", minetest.colorize("#eea160", p_name))))

    if arena_lib.is_player_spectated(p_name) then
      for sp_name, _ in pairs(arena_lib.get_player_spectators(p_name)) do
        block_league.HUD_kill_update(sp_name, S("@1 HAS KILLED @2", p_name, t_name))
      end
    end

    if arena_lib.is_player_spectated(t_name) then
      for sp_name, _ in pairs(arena_lib.get_player_spectators(t_name)) do
        minetest.chat_send_player(sp_name, minetest.colorize("#d7ded7", S("@1 has been killed by @2", minetest.colorize("#eea160", t_name), minetest.colorize("#eea160", p_name))))
      end
    end

    local p_stats = arena.players[p_name]
    local team_id = p_stats.teamID
    local team = arena.teams[team_id]
    local points

    -- aggiungo l'uccisione
    team.kills = team.kills + 1
    p_stats.kills = p_stats.kills + 1

    -- calcolo i punti
    if arena.mode == 1 then
      if player:get_meta():get_int("bl_has_ball") == 1 or target:get_meta():get_int("bl_has_ball") == 1 then
        points = 4
      else
        points = 2
      end
    else
      points = 2
    end

    p_stats.points = p_stats.points + points

    local dmg_table = arena.players[t_name].dmg_received
    local a_dmg = 0
    local a_name

    -- controlla per assist..
    for pl_name, _ in pairs(dmg_table) do
      local dmg = dmg_table[pl_name].dmg
      if pl_name ~= p_name and arena.current_time > dmg_table[pl_name].timestamp - 5 and dmg > 5 and dmg > a_dmg then
        a_name = pl_name
        a_dmg = dmg
      end
    end

    -- ..e se esiste, esegui tutte le operazioni anche su chi l'ha
    if a_name and arena.players[a_name] then
      arena_lib.sound_play(a_name, "bl_kill")
      block_league.HUD_kill_update(a_name, S("YOU'VE CONTRIBUTED TO KILL @1", t_name))

      if arena_lib.is_player_spectated(a_name) then
        for sp_name, _ in pairs(arena_lib.get_player_spectators(p_name)) do
          block_league.HUD_kill_update(sp_name, S("@1 HAS CONTRIBUTED TO KILL @2", a_name, t_name))
        end
      end

      arena.players[a_name].points = arena.players[a_name].points + (points / 2)
      block_league.HUD_spectate_update(arena, a_name, "points")
    end

    -- aggiorno HUD
    block_league.HUD_infopanel_update_points(arena, team_id)
    block_league.HUD_spectate_update(arena, p_name, "points")
    block_league.HUD_log_update(arena, weapon.inventory_image, p_name, t_name, a_name)

    -- se è DM e il limite è raggiunto, finisce partita
    if arena.mode == 2 then
      block_league.HUD_scoreboard_update_score(arena)
      if team.kills == arena.score_cap then
        local mod = arena_lib.get_mod_by_player(p_name)
        arena_lib.load_celebration(mod, arena, team_id)
      end
    end

  else
    block_league.HUD_kill_update(t_name, S("You've killed yourself"))
    block_league.HUD_log_update(arena, "bl_log_suicide.png", p_name, "")
  end
end