local S = minetest.get_translator("block_league")

local function wait_for_respawn() end



arena_lib.on_death("block_league", function(arena, p_name, reason)
  local player = minetest.get_player_by_name(p_name)

  -- Stando a git blame, penso fosse stato messo per le entità che vengono invocate
  -- per immobilizzare chi gioca (es. per l'attacco in salto con la spada)
  if player:get_attach() then
    player:get_attach():remove()
  end

  local p_stats = arena.players[p_name]

  -- TD: se il giocatore è morto con la palla, questa si sgancia e torna a oscillare
  if arena.mode == 1 then
    local ball = block_league.get_ball(player)

    if ball then
      if player:get_pos().y < arena.min_y then
        ball:reset()
      else
        ball:detach()
      end

      -- reindirizza sulla palla gli spettatori
      for sp_name, _ in pairs(arena_lib.get_player_spectators(p_name)) do
        if arena.spectators[sp_name].was_following_ball then
          arena_lib.spectate_target("block_league", arena, sp_name, "entity", "Ball")
        end
      end
    end

  -- DM: se muoio suicida, perdo un'uccisione
  elseif arena.mode == 2 then
    p_stats.kills = p_stats.kills - 1
    local team_id = p_stats.teamID
    local team = arena.teams[team_id]
    team.deaths = team.deaths + 1
    block_league.HUD_infopanel_update_points(arena, team_id)
  end

  local p_meta = player:get_meta()

  p_meta:set_int("bl_immunity", 1)
  p_meta:set_int("bl_death_delay", 1)

  wait_for_respawn(arena, p_name, arena.death_waiting_time)
end)





----------------------------------------------
---------------FUNZIONI LOCALI----------------
----------------------------------------------

function wait_for_respawn(arena, p_name, time_left)
  if not arena_lib.is_player_in_arena(p_name, "block_league") or arena.weapons_disabled then
    arena_lib.HUD_hide("broadcast", p_name)
    return end

  if time_left > 0 then
    arena_lib.HUD_send_msg("broadcast", p_name, S("Back in the game in @1", time_left))
  else
    local player = minetest.get_player_by_name(p_name)

    player:get_meta():set_int("bl_death_delay", 0)
    arena_lib.HUD_hide("broadcast", p_name)

    -- se è nella sala d'attesa quando deve rinascere
    if player:get_hp() > 0 then
      block_league.HUD_spectate_update(arena, p_name, "alive")
      block_league.start_immunity_countdown(player)
      arena_lib.teleport_onto_spawner(player, arena)
    end

    return
  end

  time_left = time_left -1

  minetest.after(1, function()
    wait_for_respawn(arena, p_name, time_left)
  end)
end