local equip = {}             -- KEY p_name, INDEX { weapons = { 1 = w_name, 2 = w_name, 3 = w_name}, skill = s_name }

function block_league.init_equip(p_name)
  equip[p_name] = {}
end



function block_league.equip(p_name, w_name, slot)
  local p_weaps = equip[p_name].weapons
  local w2_name = p_weaps[slot]

  if w_name == w2_name then return end

  local w_prev_slot

  for i, ww_name in pairs(p_weaps) do
    if w_name == ww_name then
      w_prev_slot = i
    end
  end

  equip[p_name].weapons[slot] = w_name

  if w2_name and w_prev_slot then
    p_weaps[w_prev_slot] = w2_name
  elseif w_prev_slot then
    p_weaps[w_prev_slot] = nil
  end

  block_league.update_storage(p_name, "weapons", p_weaps)
end



function block_league.unequip(p_name, w_name)
  local p_weaps = equip[p_name].weapons

  for i, ww_name in pairs(p_weaps) do
    if w_name == ww_name then
      p_weaps[i] = nil
      block_league.update_storage(p_name, "weapons", p_weaps)
      return
    end
  end
end



function block_league.get_player_weapons(p_name)
  return equip[p_name].weapons
end



function block_league.get_player_skill(p_name)
  return equip[p_name].skill
end



function block_league.set_player_weapons(p_name, weapons)
  if type(weapons) ~= "table" then return end -- TODO controlla con weapons_lib se sono armi registrate

  equip[p_name].weapons = weapons
  --block_league.update_storage(p_name, "weapons", equip[p_name].weapons)
end



function block_league.set_player_skill(p_name, s_name)
  if type(s_name) ~= "string" or not skills.does_skill_exist(s_name) then return end

  equip[p_name].skill = s_name
  block_league.update_storage(p_name, "skill", s_name)
end



function block_league.has_weapon_equipped(p_name, w_name)
  if not equip[p_name] then return end

  for _, ww_name in pairs(equip[p_name].weapons) do
    if w_name == ww_name then
      return true
    end
  end
end
