controls.register_on_press(function(player, key)
  local p_name = player:get_player_name()

  if not arena_lib.is_player_in_arena(p_name, "block_league") or arena_lib.is_player_spectating(p_name) then return end

  if key == "zoom" and player:get_hp() > 0 then
    local arena = arena_lib.get_arena_by_player(p_name)

    if not arena.in_loading and not arena.in_celebration then
      local sk_name = block_league.get_equipped_skill(p_name)
      local skill = skills.get_def(sk_name)
      local sk_type = skill._type

      if sk_type == "continuous" or sk_type == "instant" then
        if skills.get_active_skills(p_name, "block_league")[sk_name] then
          p_name:stop_skill(sk_name)
        else
          block_league.remove_immunity(player)
          p_name:start_skill(sk_name)
        end
      end
    end
  end

  if key == "aux1" and not arena_lib.get_arena_by_player(p_name).in_celebration then
    panel_lib.get_panel(p_name, "bl_info_panel"):show()
  end

  -- TODO: abilità attive. Usare speed_crouch in physics_override identico a velocità giocatorə (così da non rallentare)
end)



controls.register_on_release(function(player, key)
  local p_name = player:get_player_name()

  if not arena_lib.is_player_in_arena(p_name, "block_league") or arena_lib.is_player_spectating(p_name) then return end

  -- AUX1
  if key == "aux1" and not arena_lib.get_arena_by_player(p_name).in_celebration then
    panel_lib.get_panel(p_name, "bl_info_panel"):hide()
  end
end)
