local S = core.get_translator("block_league")
local FS = function(...) return core.formspec_escape(S(...)) end

local function get_formspec() end
local function get_weapon_slot() end

-- for debug only
--core.register_on_joinplayer(function(player)
--  block_league.gui_show_xp_earned(player:get_player_name(), {{prev = 234, earned = 0}, {prev = 201, earned = 67}, {prev = 478, earned = 59}})
--end)



-- `is_final_view` false = non possono chiudere, xp guadagnata ancora non visibile
function block_league.gui_show_xp_earned(p_name, weaps_xp_data, lv_up_data, show_licence_guide, is_final_view)
  core.show_formspec(p_name, "block_league:xp_earned", get_formspec(p_name, weaps_xp_data, is_final_view))

  if not is_final_view then
    audio_lib.play_sound("bl_loadingxp", {to_player = p_name})
    core.after(1.1, function()
      if not core.get_player_by_name(p_name) then return end
      block_league.gui_show_xp_earned(p_name, weaps_xp_data, lv_up_data, show_licence_guide, true)
    end)

  else
    if is_final_view then
      -- se è la prima volta che una barra viene riempita, mostra la guida
      if show_licence_guide then
        block_league.gui_show_guide_lvup(p_name, weaps_xp_data)

      elseif lv_up_data then
        block_league.gui_show_lvup(p_name, lv_up_data.w_name, lv_up_data.new_lv, lv_up_data.next_levels, weaps_xp_data)
      end
    end
  end
end





----------------------------------------------
---------------FUNZIONI LOCALI----------------
----------------------------------------------

function get_formspec(p_name, weaps_xp_data, final_view)
  local equip = block_league.get_equipped_weapons(p_name)
  local quit_button = final_view and ("image_button_exit[7.78,9.3;2.45,0.7;bl_gui_xp_button.png;close;" .. FS("Close") .. "]") or ""

  local formspec = {
    "formspec_version[6]",
    "size[18,9.7]",
    "no_prepend[]",
    "allow_close[false]",
    "bgcolor[;true]",
    "style[close;noclip=true;border=false;font=mono]",
    "style[close:hovered;fgimg=bl_gui_xp_button_on.png]",
    "container[0.1,0.2]",
    "image[0.9,0;0.8,0.8;" .. "bl_level_" .. block_league.get_player_level(p_name)  .. ".png]",
    "hypertext[1.85,0;6,0.8;pname_txt;<global size=24 valign=middle><b>" .. p_name .. "</b>]",
    "container_end[]",

    "container[0,-0.25]",
    "container[0.98,2.04]",
    get_weapon_slot(p_name, equip[1], weaps_xp_data[1], final_view),
    "container_end[]",

    "container[0.98,4.31]",
    get_weapon_slot(p_name, equip[2], weaps_xp_data[2], final_view),
    "container_end[]",

    "container[0.98,6.58]",
    get_weapon_slot(p_name, equip[3], weaps_xp_data[3], final_view),
    "container_end[]",
    "container_end[]",

    quit_button
  }

  return table.concat(formspec, "")
end



function get_weapon_slot(p_name, w_name, weaps_xp_data, final_view)
  if not w_name then
    return "image[0,0;14.33,2;bl_gui_xp_bg_empty.png]"
    end

  local w_name_orig = block_league.get_original_weapon(w_name)

  if not block_league.is_weapon_exp_enabled(w_name_orig) then
    return "image[0,0;14.33,2;bl_gui_xp_bg.png]image[0.32,0.3;1.35,1.35;" .. core.registered_nodes[w_name].inventory_image ..
            "]hypertext[2.08,0.6;12,0.8;xp_not_enabled;<global size=18 halign=center valign=middle font=mono><style color=#cafff9>" .. FS("Xp not supported") .. "]"
    end

  local w_lv = block_league.get_weapon_lv(p_name, w_name_orig)

  if w_lv == block_league.get_weapons_max_lv() then
    return "image[0,0;14.33,2;bl_gui_xp_bg_silver.png]image[0.32,0.3;1.35,1.35;" .. core.registered_nodes[w_name].inventory_image ..
            "]image[2.08,0.635;12.19,0.65;bl_gui_xp_bar.png" ..
            "]image[1.9,1.5;0.4,0.37;bl_gui_xp_lv" .. w_lv .. ".png" ..
            "]hypertext[2.08,1.2;12,0.8;xp_txt;<global size=18 halign=center valign=middle font=mono><style color=#cafff9>MAX]"
  end

  local bg = w_lv <= 2 and "bl_gui_xp_bg.png" or "bl_gui_xp_bg_silver.png" -- TODO: in futuro anche oro e diamante (e metti diamante nell'if sopra)

  if block_league.has_exceeded_weekly_time(p_name) then
    return "image[0,0;14.33,2;" .. bg .. "]image[0.32,0.3;1.35,1.35;" .. core.registered_nodes[w_name].inventory_image ..
            "]image[1.9,1.5;0.4,0.37;bl_gui_xp_lv" .. w_lv .. ".png" ..
            "]hypertext[2.08,0.6;12,0.8;xp_not_enabled;<global size=18 halign=center valign=middle font=mono><style color=#cafff9>" .. FS("Xp dispenser currently broken :(") .. "]"
  end

  local prev_xp = weaps_xp_data.prev
  local earned_xp = weaps_xp_data.earned
  local required_xp = block_league.XP_REQUIRED_PER_LV[w_lv+1]
  local new_xp = prev_xp + earned_xp
  local new_xp_clamped = math.min(required_xp, new_xp)

  -- prev_xp : 228 = x : required_xp (228 è la larghezza dell'immagine della barra)
  local prev_perc = 228 * prev_xp / required_xp
  local new_perc = final_view and (228 * new_xp_clamped / required_xp) or prev_perc
  local is_xp_maxed = new_xp_clamped == required_xp
  local xp_stored = block_league.get_xp_stored(p_name, w_name_orig)

  local magenta_part = (earned_xp > 0 and final_view) and "^[fill:228x12:" .. prev_perc .. ",0:#e061f9" or ""
  local grey_part, padlock, extra_xp

  if is_xp_maxed then
    grey_part = ""
    padlock = "bl_gui_xp_padlock_on.png"
    extra_xp = "hypertext[15.8,0.6;12,0.8;extra_xp;<global size=18 valign=middle font=mono><style color=#fefd99>+" .. xp_stored .. "</style>]" ..
                "tooltip[extra_xp;" .. FS("Surplus xp you'll receive once levelling up") .. "]"
  else
    grey_part = "^[fill:228x12:" .. new_perc .. ",0:#556a77"
    padlock = "bl_gui_xp_padlock.png"
    extra_xp = ""
  end

  local curr_amnt = final_view and new_xp_clamped or prev_xp
  local earned_xp_txt = final_view and (" <style color=#ffa7f6>(+" .. (not is_xp_maxed and earned_xp - xp_stored or 0) .. ")</style>") or ""

  local section = {
    "image[0,0;14.33,2;" .. bg .. "]",
    "image[2.08,0.635;12.19,0.65;bl_gui_xp_bar.png" .. magenta_part .. grey_part .. "]",
    "image[1.9,1.5;0.4,0.37;bl_gui_xp_lv" .. w_lv .. ".png]",
    "image[0.32,0.3;1.35,1.35;" .. core.registered_nodes[w_name].inventory_image .. "]",
    "image[14.72,0.54;0.8,0.8;" .. padlock .. "]",
    "hypertext[2.08,1.2;12,0.8;xp_txt;<global size=18 halign=center valign=middle font=mono><style color=#cafff9>" .. curr_amnt .. "/" .. required_xp .. earned_xp_txt .. "]",
    extra_xp
  }

  return table.concat(section, "")
end