local S = core.get_translator("block_league")

local LINE_DIST = 22
local X_OFFSET = 15
local TITLE_Y_OFFSET = -65
local FIRST_LINE_Y_OFFSET = TITLE_Y_OFFSET + 13

local completed_warning = {
  text = S("Now play until the end!"),
  number = 0xffacc8,
  size = 1,
  offset = {x = X_OFFSET, y = 2},
}


-- debug
--[[core.register_on_joinplayer(function(player)
  core.after(0.5, function()
    block_league.HUD_infopanel_create(player:get_player_name())
    block_league.HUD_licences_create(player:get_player_name(), 4)
    core.chat_send_all(dump(panel_lib.get_panel(player:get_player_name(), "bl_licences")))
  end)
end)]]

function block_league.HUD_licences_create(p_name, players_amount)
  local sub_txt_elems = {}
  local i = 1

  -- per ogni licenza, crea un sottoelemento
  for _, w_name in ipairs(block_league.get_equipped_weapons(p_name, true)) do
    local progress = block_league.get_licence_progress(p_name, w_name)

    if progress then
      local w_name_readable = core.registered_items[w_name].description
      local w_next_lv = block_league.get_weapon_lv(p_name, w_name) + 1
      local info = block_league.get_licence_info(w_name, w_next_lv)

      sub_txt_elems[w_name] = {
        text = S("Lv @1", w_next_lv) .. " " .. w_name_readable .. ": " .. info.desc .. " (" .. progress.amount .. "/" .. info.goal .. ")",
        number = 0xdff6f5,
        size = 1,
        offset = {x = X_OFFSET, y = FIRST_LINE_Y_OFFSET + (i * LINE_DIST)},
      }

      i = i + 1
    end
  end

  local warning_txt = ""
  local in_progress = i > 1

  if in_progress then
    if block_league.has_exceeded_weekly_time(p_name) then
      warning_txt = S("Xp dispenser currently broken :(")
    elseif players_amount < 4 then
      warning_txt = S("You need at least 4 players to progress with the licence!")
    end
  end

  sub_txt_elems.warning = {
    text = warning_txt,
    number = 0xffacc8,
    size = 1,
    offset = {x = X_OFFSET, y = FIRST_LINE_Y_OFFSET + 10 + (i * LINE_DIST)}
  }

  Panel:new("bl_licences", {
    player = p_name,
    bg = "",
    position = { x = 0, y = 0.5 },
    title_alignment = { x = 1, y = 0 },
    title_offset = { x = X_OFFSET, y = TITLE_Y_OFFSET},
    z_index = 101,
    title = in_progress and S("Licences in progress") or "", -- se non ha trovato licenze in corso, lascia l'HUD invisibile
    title_size = {x = 2},
    title_color = 0xf6c33b,

    visible = false,

    sub_txt_elems = sub_txt_elems
  })
end



function block_league.HUD_licences_update_progress(p_name, w_name)
  local panel = panel_lib.get_panel(p_name, "bl_licences")
  local w_name_readable = core.registered_items[w_name].description
  local w_next_lv = block_league.get_weapon_lv(p_name, w_name) + 1
  local info = block_league.get_licence_info(w_name, w_next_lv)
  local progress = block_league.get_licence_progress(p_name, w_name)
  local completed_col = progress.completed and 0x5be7b1 or 0xdff6f5

  panel:update(nil, {[w_name] = {
    text = S("Lv @1", w_next_lv) .. " " .. w_name_readable .. ": " .. info.desc .. " (" .. progress.amount .. "/" .. info.goal .. ")",
    number = completed_col
  }})

  local completed_now = not panel.completed_warning and progress.completed

  if completed_now then
    panel:add_sub_elem("text", "completed_warning", completed_warning)

    local i = 1

    for _, ww_name in ipairs(block_league.get_equipped_weapons(p_name, true)) do
      if block_league.get_licence_progress(p_name, ww_name) then
        i = i + 1
      end
    end

    panel:update(nil, {completed_warning = {offset = {x = X_OFFSET, y = FIRST_LINE_Y_OFFSET + 25 + (i * LINE_DIST)}}})
  end
end



function block_league.HUD_licences_update_warning_few_players(arena, prev_amnt)
  local p_amount = arena.players_amount

  if (prev_amnt < 4 and p_amount < 4) or (prev_amnt >= 4 and p_amount >= 4) then return end

  for pl_name, _ in pairs(arena.players) do
    if block_league.has_licence_in_progress(pl_name) and not block_league.has_exceeded_weekly_time(pl_name) then
      local panel = panel_lib.get_panel(pl_name, "bl_licences")
      local txt

      if p_amount >= 4 then
        txt = ""
      else
        txt = S("You need at least 4 players to progress with the licence!")
      end

      panel:update(nil, {warning = {text = txt}})
    end
  end
end