local S = core.get_translator("block_league")

local STAMINA_COST = 20
local STAMINA_DRAIN_PER_CAST = 1



skills.register_skill("block_league:invisibility", {
  name = S("Invisibility"),
  icon = "bl_skill_invisibility.png",
  _profile_description = S("[Active] ") .. S("Become almost invisible (1% opacity).") .. "\n\n" .. S("Ambush your enemies!")
                    .. " " .. S("It consumes @1 to activate and @2 per second whilst active.", "<style color=#ffe446>" .. STAMINA_COST .. "</style>", "<style color=#ffe446>" .. STAMINA_DRAIN_PER_CAST*10 .. "</style>")
                    .. " " .. S("Interrupted by attacks and propulsor."),
  _type = "continuous",
  _arena = {},
  _prev_txtrs = {},
  _interrupt_by_attacking = true,

  hud = {{
      name = "overlay",
      type = "image",
      text = "bl_util_blacksquare.png^[colorizehsl:0:0:100^[opacity:65",
      scale = {x = 300, y = 300},
      z_index = -200
    }},

  -- TEMP: qua non vanno, mettili su on_start e on_stop
  --[[sounds = {
    start = {name = "bl_skill_invisibility_on"},
    stop = {name = "bl_skill_invisibility_off"},
  },]]

  loop_params = {cast_rate = 0.1},

  can_start = function(self, ...)
    local p_name = self.pl_name

    self._arena = arena_lib.get_arena_by_player(p_name)

    local arena = self._arena
    if not arena or not block_league.has_enough_stamina(arena, p_name, STAMINA_COST) then return end

    return true
  end,

  can_cast = function(self, ...)
    local arena = self._arena
    local p_data = arena.players[self.pl_name]

    -- primo controllo in caso sia uscitə dall'arena
    if p_data and p_data.stamina >= STAMINA_DRAIN_PER_CAST then
      return true
    else
      self:stop()
    end
  end,

  cast = function(self, ...)
    local p_name = self.pl_name
    local arena = self._arena

    block_league.subtract_stamina(arena, p_name, STAMINA_DRAIN_PER_CAST)
  end,

  on_start = function(self, ...)
    local p_name = self.pl_name
    local player = self.player
    local arena = self._arena

    self._prev_txtrs = player:get_properties().textures
    visible_wielditem.set_visibility(player, false)

    local p_txtrs = player:get_properties().textures

    for i, txtr in ipairs(p_txtrs) do
      p_txtrs[i] = txtr .. "^[opacity:10"

      for _, child in ipairs(player:get_children()) do
        if not child:is_player() then
          local name = child:get_luaentity().name
          if name ~= "block_league:ball" and name ~= "block_league:hp_bar" then
            local child_txtrs = child:get_properties().textures

            for j, child_txtr in ipairs(child_txtrs) do
              child_txtrs[j] = child_txtr .. "^[opacity:10"
            end

            child:set_properties({use_texture_alpha = true, textures = child_txtrs})
          end
        end
      end
    end

    player:set_properties({use_texture_alpha = true, textures = p_txtrs})
    audio_lib.play_sound("bl_skill_invisibility_on", {to_player = p_name})
    block_league.subtract_stamina(arena, p_name, STAMINA_COST)
  end,

  on_stop = function(self)
    local player = self.player

    audio_lib.play_sound("bl_skill_invisibility_off", {to_player = self.pl_name})

    -- se non è più in arena, lascia che ci pensi arena_lib (o rimane la patina)
    if not arena_lib.is_player_in_arena(self.pl_name) then return end

    player:set_properties({textures = self._prev_txtrs})
    visible_wielditem.set_visibility(player, true)

    for _, child in ipairs(player:get_children()) do
      if not child:is_player() then
        local name = child:get_luaentity().name
        if name ~= "block_league:ball" and name ~= "block_league:hp_bar" then
          local child_txtrs = child:get_properties().textures

          for j, child_txtr in ipairs(child_txtrs) do
            child_txtrs[j] = string.gsub(child_txtr, "%^%[opacity:10", "")
          end

          child:set_properties({textures = child_txtrs})
        end
      end
    end
  end,
})