local S = core.get_translator("block_league")
local FS = function(...) return core.formspec_escape(S(...)) end

local function get_formspec() end
local function get_page_content() end

local curr_page = {}        -- KEY: p_name; VAL: page
local xp_data = {}          -- KEY: p_name; VAL: xp_data



-- non espongo `weaps_xp_data`, usato solo dal gioco per rimostrare l'exp alla
-- chiusura (dato che non è possibile sovrapporre interfacce)
function block_league.gui_show_guide_lvup(p_name, weaps_xp_data)
  curr_page[p_name] = 1
  xp_data[p_name] = weaps_xp_data

  core.show_formspec(p_name, "block_league:guide_lv-up", get_formspec(1))
end





----------------------------------------------
---------------FUNZIONI LOCALI----------------
----------------------------------------------

function get_formspec(page)
  local content, buttons = get_page_content(page)

  local fs = {
    "formspec_version[6]",
    "size[10,10.5]",
    "no_prepend[]",
    "allow_close[false]",
    "bgcolor[;true]",
    "background[0,0;10,10.5;bl_gui_lv-up_bg.png]",
    "style_type[image_button:hovered;fgimg=bl_gui_guide_lvup_button_on.png]",
    "style[close:hovered;fgimg=bl_gui_profile_button_equip_on.png]",
    "hypertext[0,0.5;10,0.8;pname_txt;<global size=24 halign=center valign=middle><b>" .. FS("Levelling up") .. "</b>]",
    "container[1,1.5]",
    content,
    "container_end[]",
    buttons
  }

  return table.concat(fs, "")
end



 function get_page_content(page)
  local content, buttons

  if page == 1 then
    content = {
      "hypertext[0,0;8,5;txt;<global size=16>" .. FS("In order to level up, each weapon requires some <style @1>experience</style> and a <style @2>licence</style>.", "color=#f6c33b", "color=#f6c33b") .. "\n"
        .. FS("There are <style @1>10 levels for each weapon</style> and the sum of their levels gives you the level of your character.", "color=#f6c33b") .. "]",
      "image[-0.5,2.4;9,5.2;bl_gui_lv-up1.png]",
    }
    buttons = {
      "image_button[5.1,9.6;2.45,0.6;bl_gui_guide_lvup_button.png;next;->]"
    }
  elseif page == 2 then
    content = {
      "hypertext[0,0;8,5;txt;<global size=16>" .. FS("<style @1>Licences</style> are <style @2>quests to complete in a single game</style> (with at least 4 people) and they're unlocked once the exp bar is full.", "color=#f6c33b", "color=#f6c33b") .. "\n"
        .. FS("Complete the licence and the weapon will level up.") .. "]",
      "image[0,2.9;8,3.7;bl_gui_lv-up2.png]",
    }
    buttons = {
      "image_button[2.45,9.6;2.45,0.6;bl_gui_guide_lvup_button.png;prev;<-]",
      "image_button[5.1,9.6;2.45,0.6;bl_gui_guide_lvup_button.png;next;->]"
    }
  else
    content = {
      "image[0,0;0.5,0.5;bl_gui_warning.png]",
      "hypertext[0,0;8,5;txt;<global size=16><style color=#ffe446 font=mono>.</style>    " .. FS("Remember!") .. "\n"
        .. FS("Weapons stop earning experience until the licence is obtained.") .. "\n"
        .. FS("Furthermore, the higher the level, the harder it'll be the licence to get.") .. "]",
    }
    buttons = {
      "image_button[2.45,9.6;2.45,0.6;bl_gui_guide_lvup_button.png;prev;<-]",
      "image_button_exit[5.1,9.6;2.45,0.6;bl_gui_profile_button_equip.png;close;" .. FS("Close") .. "]"
    }
  end

  return table.concat(content, ""), table.concat(buttons, "")
 end





----------------------------------------------
---------------GESTIONE CAMPI-----------------
----------------------------------------------

core.register_on_player_receive_fields(function(player, formname, fields)
  if formname ~= "block_league:guide_lv-up" then return end

  local p_name = player:get_player_name()

  if fields.close then
    curr_page[p_name] = nil

    if xp_data[p_name] then
      block_league.gui_show_xp_earned(p_name, xp_data[p_name], nil, nil, true)
      xp_data[p_name] = nil
    end

    return
  end

  if fields.prev then
    curr_page[p_name] = curr_page[p_name] - 1
    core.show_formspec(p_name, "block_league:guide_lv-up", get_formspec(curr_page[p_name]))
  elseif fields.next then
    curr_page[p_name] = curr_page[p_name] + 1
    core.show_formspec(p_name, "block_league:guide_lv-up", get_formspec(curr_page[p_name]))
  end
end)