local S = core.get_translator("block_league")
local FS = function(...) return core.formspec_escape(S(...)) end

local function get_formspec() end
local function get_reward() end

local queued_lvls = {}      -- KEY: p_name; VAL: {1 = {w_name, p_lv}, 2 = ...}
local xp_data = {}          -- KEY: p_name; VAL: xp_data
local random_incitements = {
  FS("You are killing it!"),
  FS("You're awesome!"),
  FS("Go get'em, tiger!")
}



-- Non esporre
-- `weaps_xp_data` usato per rimostrare l'exp alla chiusura (dato che non è possibile
-- sovrapporre interfacce)
function block_league.gui_show_lvup(p_name, w_name, lv, next_levels, weaps_xp_data)
  queued_lvls[p_name] = next_levels
  xp_data[p_name] = weaps_xp_data

  -- effetto particellare
  core.add_particlespawner({
    amount = 18,
    time = 0.75,
    vel = vector.new(0, 6, 0),
    size = 20,
    texture = {
      name = "bl_levelup_particle.png",
      alpha_tween = {0.4, 0},
      scale_tween = {
      {x = 0.7,   y = 1.5},
      {x = 1.5, y = 1.5},
      },
    },
    attached = core.get_player_by_name(p_name),
    vertical = false,
    minexptime = 0.15,
    pos = {
      min = vector.new(-0.125, 0, -0.125),
      max = vector.new(0.125, 0, 0.125)
    }
  })

  audio_lib.stop_sound(p_name, "bl_loading_xp")
  audio_lib.play_sound("bl_lvup", {to_player = p_name})
  core.show_formspec(p_name, "block_league:lv-up", get_formspec(p_name, w_name, lv))
end





----------------------------------------------
---------------FUNZIONI LOCALI----------------
----------------------------------------------

function get_formspec(p_name, w_name, lv)
  local w_icon = core.registered_items[w_name].inventory_image
  local w_lv = block_league.get_weapon_lv(p_name, w_name)
  local licence = block_league.get_licence_info(w_name, w_lv)
  local reward = get_reward(licence)

  local fs = {
    "formspec_version[6]",
    "size[10,10.5]",
    "no_prepend[]",
    "bgcolor[;true]",
    "background[0,0;10,10.5;bl_gui_lv-up_bg.png]",
    "style[close:hovered;fgimg=bl_gui_profile_button_equip_on.png]",
    "hypertext[0,0.8;10,0.8;title;<global size=24 halign=center valign=middle><b>" .. FS("You've reached level @1!", lv) .. "</b>]",
    "container[1,2.5]",
    "image[1,0;1,1;" .. w_icon .. "]",
    "image[6,0;1,1;bl_level_" .. lv .. ".png]",
    "hypertext[0,0.5;8,1;arrow;<global size=16 halign=center>------------->]",
    "hypertext[0.5,1.1;2,5;w_lv;<global size=16 halign=center><style color=#1a162e>.</style> " .. FS("Lv. @1", w_lv) .. " <style color=#5be7b1>↑</style>]",
    "hypertext[5.5,1.1;2,5;p_lv;<global size=16 halign=center><style color=#1a162e>.</style> " .. FS("Lv. @1", lv) .. " <style color=#5be7b1>↑</style>]",
    reward,
    "container_end[]",
    "image_button_exit[3.85,9.6;2.45,0.6;bl_gui_profile_button_equip.png;close;" .. FS("Close") .. "]"
  }

  return table.concat(fs, "")
end



 function get_reward(licence)
  if licence.reward then
    local ret
    local rwrd = licence.reward
    local img, txt

    if rwrd.type == "SKIN" then
      local item = core.registered_items[rwrd.item]

      img = item.inventory_image
      txt = item.description .. " (" .. item._variant_name .. ")"
    end

    ret = {
      "box[0,2.2;8,4.3;#00000066]",
      "hypertext[0,2.4;8,5;pname_txt;<global size=16 halign=center>" .. FS("You've obtained the following rewards:") .. "]",
      "image[3.25,3.42;1.5,1.5;" .. img .. "]",
      "hypertext[0,5.7;8,5;pname_txt;<global size=16 halign=center><style color=#f6c33b>" .. txt .. "]",
    }

    return table.concat(ret, "")

  else
    return "hypertext[0,4.1;8,5;pname_txt;<global size=18 halign=center>" .. random_incitements[math.random(1, #random_incitements)] .. "]"
  end
 end





----------------------------------------------
---------------GESTIONE CAMPI-----------------
----------------------------------------------

core.register_on_player_receive_fields(function(player, formname, fields)
  if formname ~= "block_league:lv-up" then return end

  local p_name = player:get_player_name()

  if fields.close then
    if next(queued_lvls[p_name]) then
      local next = queued_lvls[p_name][1]
      audio_lib.play_sound("bl_lvup", {to_player = p_name})
      core.show_formspec(p_name, "block_league:lv-up", get_formspec(p_name, next.w_name, next.new_lv))
      table.remove(queued_lvls[p_name], 1)

    elseif xp_data[p_name] then
      block_league.gui_show_xp_earned(p_name, xp_data[p_name], nil, nil, true)
      xp_data[p_name] = nil
    end

    return
  end
end)
