local S = core.get_translator("bl_tutorial")

local function get_formspec() end

local requested_id = {}							-- KEY: p_name; VAL: curr_id



function bl_tutorial.suggest_tutorial(p_name, requested_ar_id)
	requested_id[p_name] = requested_ar_id
	core.show_formspec(p_name, "bl_tutorial:suggest_tutorial", get_formspec())
end





----------------------------------------------
---------------FUNZIONI LOCALI----------------
----------------------------------------------

function get_formspec()
  local formspec = {
    "formspec_version[4]",
    "size[6,3.6]",
		"allow_close[false]",
    "style[cancel;bgcolor=red]",
    "style[confirm;bgcolor=green]",
    "hypertext[0.5,0.1;5,2.2;msg;<global halign=center valign=middle>" .. S("It's recommended playing the tutorial before taking part in a real match. Do you wanna go to the tutorial instead?") .. "]",
    "button[3.25,2.5;1.75,0.7;confirm;" .. S("Yes, please") .. "]",
    "button[1,2.5;1.75,0.7;cancel;" .. S("No, I'm good") .. "]",
    "field_close_on_enter[;false]"
  }

  return table.concat(formspec, "")
end





----------------------------------------------
---------------GESTIONE CAMPI-----------------
----------------------------------------------

core.register_on_player_receive_fields(function(player, formname, fields)
  if formname ~= "bl_tutorial:suggest_tutorial" then return end

  local p_name = player:get_player_name()

  -- se rifiuta
  if fields.cancel then
    block_league.set_tutorial_skip(p_name)

		local arena = arena_lib.mods["block_league"].arenas[requested_id[p_name]]

		if not arena.in_game then
			arena_lib.join_queue("block_league", arena, p_name)
		else
			arena_lib.join_arena("block_league", p_name, requested_id[p_name])
		end

		requested_id[p_name] = nil
    core.close_formspec(p_name, "bl_tutorial:suggest_tutorial")

  -- se accetta
  elseif fields.confirm then
		local arena

		for _, ar in ipairs(arena_lib.mods["block_league"].arenas) do
			if ar.mode == 0 and ar.enabled then
				arena = ar
				break
			end
		end

    if arena.in_queue or arena.in_game then
      block_league.print_error(p_name, S("Tutorial is currently busy, please retry in a bit"))
      return end

    arena_lib.join_queue("block_league", arena, p_name)
    arena_lib.force_start(nil, "block_league", arena)
  end
end)
